/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.CcsPortfPositionModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class CcsPortfPositionPart
extends MxPart {
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    protected String filterType = "";
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    private Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    private Label lbMarket;
    @FXML
    protected CheckComboBox<String> ccmbSecAcc;
    @FXML
    private Label lbSecAcc;
    @FXML
    protected CheckComboBox<String> ccmbPort;
    @FXML
    private Label lbPort;
    @FXML
    private TableView<CcsPortfPosition> tablePosition;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecId;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecName;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colTotalVol;
    @FXML
    private TableColumn<CcsPortfPosition, String> colUnit;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCanVol;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCost;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCostAmt;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colProfit;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colTotalProfit;
    @FXML
    private TableColumn<CcsPortfPosition, MxNode> colMarket;
    @FXML
    private TableColumn<CcsPortfPosition, String> colAcc;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecAcc;
    @FXML
    private TableColumn<CcsPortfPosition, String> colPortfName;
    @FXML
    private TableColumn<CcsPortfPosition, String> colPortfId;
    @FXML
    private TableColumn<CcsPortfPosition, String> colRemark;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCapital;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colBuyCost;
    @FXML
    private TableColumn<CcsPosition, Number> colRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> colTodayRealizedPl;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colYield;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colPercent;
    @FXML
    protected MenuItem miClose;
    @FXML
    protected MenuItem miClear;
    @Inject
    private CcsPortfPositionModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IUiRightService rightModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private MObjFactory of;
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    @Inject
    protected PortfolioAccountModel subAccMng;
    @Inject
    private ScheduledExecutorService executorService;
    private static final int DEFAULT_SECONDS = 5;
    protected boolean accFalg = false;
    protected boolean portFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    protected Set<String> portIds = new HashSet<String>();
    private MxList<CcsPortfPosition> mxList = new MxList();
    private static final Logger logger = LogManager.getLogger(CcsPortfPositionPart.class);
    private Predicate<CcsPortfPosition> pd = p -> {
        String txt = this.searchText.getText().trim();
        if (!this.premise((CcsPosition)p)) {
            return false;
        }
        if (p.getSecId().contains(txt)) {
            return true;
        }
        if (p.getSecName().contains(txt)) {
            return true;
        }
        return this.extend((Position)p);
    };
    protected InvalidationListener lstnModel = ob -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
            this.tablePosition.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getList(), this.pd);
    @Inject
    private MEventService es;

    @Inject
    public CcsPortfPositionPart() {
        super("CcsPortfPositionPart.fxml");
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.check();
        this.fxmlDone = true;
        this.initCheckComboBox();
        this.model.initQuery();
    }

    private void initCheckComboBox() {
        this.initPosFilterAcc();
        this.initPosFilterSecAcc();
        this.initPosFilterMarket();
        this.initPosFilterPort();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"port_pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    this.ccmbPort.setVisible(false);
                    this.lbPort.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    this.ccmbPort.setVisible(false);
                    this.lbPort.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    this.ccmbPort.setVisible(false);
                    this.lbPort.setVisible(false);
                    break;
                }
                case "4": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    this.ccmbPort.setVisible(true);
                    this.lbPort.setVisible(true);
                    break;
                }
            }
            this.lstnSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.lstnSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
        this.portFalg = true;
    }

    private void initPosFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    private void initPosFilterAcc() {
        HashSet listAccount = new HashSet();
        this.subAccMng.getFundAccounts().forEach(fund -> {
            boolean bl = listAccount.add(fund.getInvestId());
        });
        LinkedList<String> listAll = new LinkedList<String>();
        listAll.add("\u5168\u90e8");
        listAll.addAll(listAccount);
        this.ccmbAccnt.getItems().addAll(listAll);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAll.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initPosFilterPort() {
        LinkedList<String> listPort = new LinkedList<String>();
        listPort.add("\u5168\u90e8");
        this.subAccMng.getPortfolios().forEach(port -> {
            if (this.subAccMng.getMap((Portfolio)port) == null) {
                logger.error("\u6295\u7ec4\u4e0b\u672a\u7f13\u5b58\u5230\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7" + port.getId());
                return;
            }
            Set<CcsFundAccount> fundList = this.subAccMng.getMap((Portfolio)port).keySet();
            for (CcsFundAccount fund : fundList) {
                if (!(fund instanceof CcsSubFundAccount)) continue;
                listPort.add(String.valueOf(port.getId()) + "__" + port.getName());
                break;
            }
        });
        this.ccmbPort.getItems().addAll(listPort);
        this.ccmbPort.getCheckModel().checkAll();
        int i = 1;
        while (i < listPort.size()) {
            this.ccmbPort.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.portFalg) {
                    this.portFalg = false;
                    if (!now.booleanValue() && this.ccmbPort.getItemBooleanProperty(0).get()) {
                        this.ccmbPort.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbPort.getItems().size() - this.ccmbPort.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbPort.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.portFalg = true;
                }
            });
            ++i;
        }
        this.ccmbPort.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.portFalg) {
                this.portFalg = false;
                if (now.booleanValue()) {
                    this.ccmbPort.getCheckModel().checkAll();
                } else {
                    this.ccmbPort.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.portFalg = true;
            }
        });
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbPort.getCheckModel().getCheckedItems();
            String portStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                portStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbPort.setText(portStr);
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
            this.portIds.clear();
            for (String id : this.ccmbPort.getCheckModel().getCheckedItems()) {
                this.portIds.add(id.split("__")[0]);
            }
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void initPosFilterSecAcc() {
        LinkedList<String> listSecAccnt = new LinkedList<String>();
        listSecAccnt.add("\u5168\u90e8");
        listSecAccnt.addAll(this.model.getInvestorSecIds());
        this.ccmbSecAcc.getItems().addAll(listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        int i = 1;
        while (i < listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            this.secIds.addAll((Collection<String>)this.ccmbSecAcc.getCheckModel().getCheckedItems());
        });
        this.ccmbSecAcc.getCheckModel().checkAll();
    }

    private void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void check() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String unClear = "";
        String unClose = "";
        switch (parentId) {
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-POSITION-QUERY": {
                unClose = "cms.tmx.instructions.part.portfolio.basket.position.query_close";
                unClear = "cms.tmx.instructions.part.portfolio.basket.position.query_clear";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.portfolio.position.query_clear";
                unClose = "cms.tmx.instructions.part.portfolio.position.query_close";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-REPO-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.portfolio.repo.position.query_clear";
                unClose = "cms.tmx.instructions.part.portfolio.repo.position.query_close";
                break;
            }
        }
        if (!this.rightModel.registerCheck(new String[]{unClear})) {
            this.miClear.setVisible(false);
        }
        if (!this.rightModel.registerCheck(new String[]{unClose})) {
            this.miClose.setVisible(false);
        }
    }

    public boolean premise(CcsPosition order) {
        if ("STD_BOND".equals(order.getSecType())) {
            return false;
        }
        System.currentTimeMillis();
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(order.getInvestorId());
            }
            case "4": {
                return this.portIds.contains("\u5168\u90e8") || this.portIds.contains(order.getPortfolioId());
            }
            case "2": {
                return this.secIds.contains("\u5168\u90e8") || this.secIds.contains(order.getInverstorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(order.getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    private void createTable() {
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPortfPosition pos;
            if (event.getClickCount() == 2) {
                CcsPortfPosition pos2 = (CcsPortfPosition)this.tablePosition.getSelectionModel().getSelectedItem();
                if (pos2 != null) {
                    String code = pos2.getSecId();
                    MEvent eCall = new MEvent();
                    eCall.put((Object)"sec_code", (Object)code);
                    eCall.put((Object)"count", (Object)pos2.getCanVol());
                    eCall.put((Object)"side_sell", (Object)(pos2.getCanVol() >= 0L ? 1 : 0));
                    eCall.put((Object)"portfolioId", (Object)pos2.getPortfolioId());
                    eCall.put((Object)"accntId", (Object)pos2.getExtAccId());
                    eCall.put((Object)"secAccount", (Object)pos2.getExtSecAccId());
                    eCall.put((Object)"tMarket", (Object)pos2.getMarket().getRaw());
                    this.es.sendEvent("trade.panel.set.code.portfoilio", eCall);
                }
            } else if (event.getClickCount() == 1 && (pos = (CcsPortfPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)pos.getSecId());
                e.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
        this.colSecId.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).totalVolProperty());
        this.colTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).unitProperty());
        this.colCanVol.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).canVolProperty());
        this.colCanVol.setCellFactory(cell -> new NumberTableCell());
        this.colCost.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).costProperty());
        this.colCost.setCellFactory(p -> new PriceCell());
        this.colCostAmt.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).costAmtProperty());
        this.colCostAmt.setCellFactory(p -> new PriceCell());
        this.colCapital.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).capitalizationProperty());
        this.colCapital.setCellFactory(p -> new PriceCell());
        this.colBuyCost.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).buyCostProperty());
        this.colBuyCost.setCellFactory(data -> new BuyCostCell());
        this.colProfit.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).profitProperty());
        this.colProfit.setCellFactory(p -> new PriceCell());
        this.colTotalProfit.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).totalProfitProperty());
        this.colTotalProfit.setCellFactory(p -> new PriceCell());
        this.colRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).realizedPlProperty());
        this.colRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colTodayRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).todayRealizedPlProperty());
        this.colTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colYield.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).yieldProperty());
        this.colYield.setCellFactory(data -> new DoubleTableCell());
        this.colPercent.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).percentProperty());
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.colMarket.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).inverstorSecIdProperty());
        this.colPortfName.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).portfolioNameProperty());
        this.colPortfId.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).portfolioIdProperty());
        this.colRemark.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).remarkProperty());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void closePosi() {
        CcsPortfPosition position = (CcsPortfPosition)this.tablePosition.getSelectionModel().getSelectedItem();
        if (position == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5e73\u4ed3");
            return;
        }
        if (position.getCanVol() == 0L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ef\u5356\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u5e73\u4ed3");
            return;
        }
        if (this.model.getPledgeCode().contains(position.getSecId())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u65b0\u6807\u51c6\u5238" + position.getSecId() + "\u65e0\u6cd5\u5e73\u4ed3\uff01");
            return;
        }
        LinkedList<CcsPortfPosition> posList = new LinkedList<CcsPortfPosition>();
        posList.add(position);
        if (this.createDialog(posList)) {
            return;
        }
        MEvent event = this.model.close(position);
        int countSuc = event.getInt("suc.count");
        if (countSuc == 1) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5e73\u4ed3\u63d0\u4ea4\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
        }
    }

    @FXML
    public void clearPosi() {
        if (this.tablePosition.getItems().size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u8868\u683c\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
            return;
        }
        FilteredList posList = this.tablePosition.getItems().filtered(pos -> !this.model.getPledgeCode().contains(pos.getSecId()) && pos.getCanVol() > 0L);
        int zeroNum = this.tablePosition.getItems().size() - posList.size();
        if (posList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u672a\u5904\u7406\uff1a" + zeroNum + "\u7b14");
            return;
        }
        if (this.createDialog((List<CcsPortfPosition>)posList)) {
            return;
        }
        this.exe.execute(() -> this.lambda$53((ObservableList)posList));
    }

    private void clear(List<CcsPortfPosition> list) {
        BasketSubmitResult submitResult = this.model.clearAll(list);
        Platform.runLater(() -> {
            if (submitResult != null) {
                if (submitResult.getFailedTimes().get() > 0) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + submitResult.getSuccessedTimes().get() + "\u7b14\n\u5931\u8d25\uff1a" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                } else {
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + submitResult.getSuccessedTimes().get() + "\u7b14\n\u5931\u8d25\uff1a" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                }
            }
        });
    }

    public boolean extend(Position posi) {
        return false;
    }

    private boolean createDialog(List<CcsPortfPosition> posList) {
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        this.model.queryMarketItem(posList);
        for (CcsPortfPosition po : posList) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(po.getExtAccId(), po.getExtSecAccId());
            en.setSec(po.getSecId());
            en.setSecName(po.getSecName());
            en.setAcc(po.getInvestorId());
            en.setSecAcc(po.getInverstorSecId());
            en.setSecType(po.getSecType());
            en.setMarket(po.getMarket().getRaw());
            en.setOrderType(50);
            en.setQuantity(po.getCanVol());
            en.setPortfolioName(po.getPortfolioName());
            en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(50)));
            try {
                en.setPrice(this.model.getNewPrice(po.getSecType(), po.getMarket().getRaw(), po.getSecId()));
                po.setNewPrice(en.getPrice());
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            catch (MException e) {
                en.setTip("\u884c\u60c5\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u4e0b\u5355");
                logger.error("\u5e73\u4ed3\u83b7\u53d6\u884c\u60c5\u5931\u8d25", (Throwable)e);
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u5e73\u4ed3");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private /* synthetic */ void lambda$53(ObservableList observableList) {
        this.clear((List<CcsPortfPosition>)observableList);
    }

    private class BuyCostCell
    extends DoubleTableCell<CcsPortfPosition> {
        int scale = 3;

        private BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsPortfPosition> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsPortfPosition posi = (CcsPortfPosition)CcsPortfPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsPortfPositionPart.this.refMng.getItem(posi.getMarket().getRaw(), posi.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

