/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfOrderModel;
import cms.tmx.query.current.views.CcsOrderPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class CcsPortfOrderPart
extends CcsOrderPart {
    @FXML
    private TableColumn<CcsOrder, String> colPortfolioId;
    @FXML
    private TableColumn<CcsOrder, String> colPortfolioName;
    @Inject
    protected CcsPortfOrderModel modelP;
    protected InvalidationListener lstnModel = ob -> {
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsOrder>)this.getModel().getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
        }
    };

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Override
    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @Override
    protected void createTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getPortfolioName()));
        super.createTable();
        this.tableDoubleClick();
    }

    protected void tableDoubleClick() {
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order;
            if (event.getClickCount() == 1 && (order = (CcsOrder)this.tableOrder.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getMarket());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @Override
    protected OrderQueryModel<CcsOrder> getModel() {
        return this.modelP;
    }
}

