/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfOrderModel;
import cms.tmx.query.current.views.CcsOrderPagePart;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class CcsPortfOrderPagePart
extends CcsOrderPagePart {
    @FXML
    private TableColumn<ObCcsOrder, String> portfolioId;
    @FXML
    private TableColumn<ObCcsOrder, String> portfolioName;
    @Inject
    protected CcsPortfOrderModel model;
    @FXML
    protected Label lbQuerying;
    protected InvalidationListener lstnModel = ob -> this.refreshList();

    @Override
    public void initialize() {
        super.initialize();
        this.model.queryingProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (newV.booleanValue()) {
                this.lbQuerying.setVisible(true);
            } else {
                this.lbQuerying.setVisible(false);
            }
        }));
    }

    @Override
    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Override
    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @Override
    protected void createTable() {
        this.portfolioId.setCellValueFactory(data -> new SimpleStringProperty(((ObCcsOrder)data.getValue()).getPortfolioId()));
        this.portfolioName.setCellValueFactory(data -> new SimpleStringProperty(((ObCcsOrder)data.getValue()).getPortfolioName()));
        super.createTable();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsOrder order;
            if (event.getClickCount() == 1 && (order = (ObCcsOrder)this.tableOrder.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
    }

    @Override
    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Override
    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.getModel().query();
    }

    @Override
    protected OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }
}

