/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfDealModel;
import cms.tmx.query.current.views.CcsDealPart;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class CcsPortfDealPart
extends CcsDealPart {
    @FXML
    protected TableColumn<CcsDeal, String> colPortfolioId;
    @FXML
    protected TableColumn<CcsDeal, String> colPortfolioName;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioId;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioName;
    @Inject
    protected CcsPortfDealModel modelP;
    @FXML
    protected TextField searchText;

    @Override
    @FXML
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void createTable() {
        super.createTable();
        this.afterCreateTable();
        this.tableDoubleClick();
    }

    protected void tableDoubleClick() {
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal deal;
            if (event.getClickCount() == 1 && (deal = (CcsDeal)this.tableDeal.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
        if (this.tableDealCount != null) {
            this.tableDealCount.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                CcsDeal deal;
                if (event.getClickCount() == 1 && (deal = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem()) != null) {
                    MEvent e = new MEvent();
                    e.put((Object)"sec_code", (Object)deal.getSecId());
                    e.put((Object)"tMarket", (Object)deal.getMarket().getRaw());
                    this.es.sendEvent("input_portfoilio_trade", e);
                }
            });
        }
    }

    @Override
    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getPortfolioId() + deal.getInstrument().getSecId() + deal.getSide().getRaw();
        return key;
    }

    protected void afterCreateTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        this.colCountPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colCountPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @Override
    protected DealQueryModel<CcsDeal> getModel() {
        return this.modelP;
    }
}

