/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.ObCcsDeal;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfDealModel;
import cms.tmx.query.current.views.CcsDealPagePart;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class CcsPortfDealPagePart
extends CcsDealPagePart {
    @FXML
    protected TableColumn<ObCcsDeal, String> portfolioId;
    @FXML
    protected TableColumn<ObCcsDeal, String> portfolioName;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioId;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioName;
    @Inject
    private CcsPortfDealModel model;
    @FXML
    protected TextField searchText;

    @Override
    @FXML
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void createTable() {
        super.createTable();
        this.afterCreateTable();
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsDeal deal;
            if (event.getClickCount() == 1 && (deal = (ObCcsDeal)this.tableDeal.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getInstrument().getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
        this.tableDealCount.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal deal;
            if (event.getClickCount() == 1 && (deal = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
    }

    @Override
    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getPortfolioId() + deal.getInstrument().getSecId() + deal.getSide().getRaw();
        return key;
    }

    protected void afterCreateTable() {
        this.portfolioId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).portfolioIdProperty());
        this.portfolioName.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).portfolioNameProperty());
        this.colCountPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colCountPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
    }

    @Override
    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.getModel().query();
    }

    @Override
    protected DealQueryModel<CcsDeal> getModel() {
        return this.model;
    }
}

