/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasketAlgoEvaluateDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(BasketAlgoEvaluateDialog.class);
    @FXML
    private TableView<AlgoStrategyDetails> tableAlgoDetail;
    @Inject
    private ExecutorService exe;
    @Inject
    private AlgoStrategyQueryModel model;
    @Inject
    protected MxAlert alert;
    public static AlgoBaseOrder baseOrder;
    protected MxList<AlgoStrategyDetails> mxList = new MxList();
    private ObservableList<AlgoStrategyDetails> list = FxUtils.newList();
    protected InvalidationListener instModel = ob -> {
        this.mxList.update(this.list);
        this.tableAlgoDetail.sort();
        this.tableAlgoDetail.refresh();
    };

    @FXML
    public void initialize() {
        this.creatTable();
        this.refresh();
    }

    protected void creatTable() {
        TableUtils.initValueFactory(this.tableAlgoDetail);
        this.tableAlgoDetail.setItems(this.mxList.getList());
        this.tableAlgoDetail.setPlaceholder((Node)new Label());
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> {
            try {
                List<AlgoStrategyDetails> listTemp = this.model.queryAlgoDetail(baseOrder.getSubAcct(), baseOrder.getOrderDate(), baseOrder.getOrderDate(), baseOrder.getBaseId());
                this.list.clear();
                this.list.addAll(listTemp);
                this.instModel.invalidated(null);
                Platform.runLater(() -> this.tableAlgoDetail.layout());
            }
            catch (MException e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    protected boolean isOK(ButtonType bt) {
        AlgoStrategyDetails item = this.getSelectedItem();
        if (item == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u6210\u5206\u80a1");
            return false;
        }
        return true;
    }

    public AlgoStrategyDetails getSelectedItem() {
        return (AlgoStrategyDetails)this.tableAlgoDetail.getSelectionModel().getSelectedItem();
    }
}

