/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.app.parts.SettingDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxWebDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.jxb.WebBrowserPart;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.query.current.views.AdjPositionParamDialog;
import cms.tmx.query.current.views.portfolio.AlgoDetailDialog;
import cms.tmx.query.current.views.portfolio.BasketAlgoEvaluateDialog;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.query.utils.SideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import cn.hutool.core.lang.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoQueryPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(AlgoQueryPart.class);
    protected MxList<AlgoBaseOrder> mxList = new MxList();
    @FXML
    protected TableView<AlgoBaseOrder> tableBase;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> status;
    @FXML
    private TableColumn<AlgoBaseOrder, Object> type;
    @FXML
    private TableColumn<AlgoBaseOrder, Object> operation;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> count;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> dealCount;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> dealAmount;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> side;
    @FXML
    private TableColumn<AlgoBaseOrder, String> orderErrInfo;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private MEventService es;
    @Inject
    protected AlgoQueryModel tradeModel;
    @Inject
    protected FundAccountMngServiceImpl faccService;
    @Inject
    protected CcsUnfinishedOrderModel orderModel;
    @Inject
    private AlgoStrategyQueryModel am;
    private List<String> CAN_REORDER_STATUS = Arrays.asList("2", "4", "5", "3");
    private List<String> CAN_REORDER_TYPE = Arrays.asList("14", "15", "16", "17", "19", "20");
    Map<String, List<CcsDeal>> mapNormal;
    Map<String, List<CcsDeal>> mapPortf;
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        ArrayList<AlgoBaseOrder> list = new ArrayList<AlgoBaseOrder>();
        list.addAll((Collection<AlgoBaseOrder>)this.tradeModel.getOrderList());
        list.addAll(this.tradeModel.getMiseList());
        this.mxList.update(list, order -> this.predicate((AlgoBaseOrder)order));
        this.mxList.getList().sort((a, b) -> b.getOrderStartTime().compareTo(a.getOrderStartTime()));
        this.tableBase.sort();
        this.tableBase.refresh();
    });
    private boolean cancelAuthorized = false;
    private boolean updateAuthorized = false;
    @Inject
    private IUiRightService rightModel;
    @Inject
    private AlgoMiseMng miseMng;

    AlgoQueryPart() {
    }

    protected boolean predicate(AlgoBaseOrder order) {
        return true;
    }

    @PreDestroy
    public void close() {
        this.tradeModel.changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    public void initialize() {
        this.checkRight();
        this.tradeModel.startQuery();
        this.tradeModel.changedProperty().addListener(this.lstnModel);
        this.createTable();
        this.refresh();
    }

    protected void checkRight() {
        String parentId = this.p.getParent().getParent().getId().replaceAll("-", ".");
        String cancel = "";
        String update = "";
        switch (parentId) {
            case "cms.tmx.instructions.part.regular.algo.query": 
            case "cms.tmx.instructions.part.portfolio.algo.query": 
            case "cms.tmx.instructions.part.regular.instruct.query": 
            case "cms.tmx.instructions.part.portfolio.hkwolun.algo.query": 
            case "cms.tmx.instructions.part.shortcut.instruct.query": 
            case "cms.tmx.instructions.part.regular.algo.query.zy": 
            case "cms.tmx.instructions.part.portfolio.basket.algorithm.query": 
            case "cms.tmx.instructions.part.basket.algo.query": 
            case "cms.tmx.instructions.part.hkwolun.algo.query": 
            case "cms.tmx.instructions.part.portfolio.repo.algo.query": {
                cancel = String.valueOf(parentId) + "_cancel";
                update = String.valueOf(parentId) + "_update";
            }
        }
        if (this.rightModel.registerCheck(new String[]{cancel})) {
            this.cancelAuthorized = true;
        }
        if (this.rightModel.registerCheck(new String[]{update})) {
            this.updateAuthorized = true;
        }
    }

    protected void createTable() {
        TableUtils.initValueFactory(this.tableBase);
        this.operation.setCellValueFactory(data -> this.setOperate((AlgoBaseOrder)data.getValue()));
        this.count.setCellFactory(cell -> new NumberTableCell());
        this.dealCount.setCellFactory(cell -> new NumberTableCell());
        this.dealAmount.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).dealAmountProperty());
        this.dealAmount.setCellFactory(cell -> new DoubleTableCell());
        this.tableBase.setItems(this.mxList.getList());
        this.tableBase.setPlaceholder((Node)new Label());
        this.status.setCellFactory(cell -> new StatusCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.orderErrInfo.setCellFactory(data -> new TooltipTableCell<AlgoBaseOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((AlgoBaseOrder)this.getValue()).getOrderErrInfo();
                }
                return null;
            }
        });
    }

    @FXML
    public void refresh() {
        this.tradeModel.query();
    }

    @FXML
    public void reOrder() {
        AlgoBaseOrder baseOrder = (AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem();
        if (baseOrder == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u672a\u9009\u4e2d\u7b97\u6cd5");
            return;
        }
        if (!this.CAN_REORDER_STATUS.contains(baseOrder.getStatus().getRaw())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ea\u6709\u5b8c\u7ed3\u72b6\u6001\u7684\u7b97\u6cd5\u53ef\u4ee5\u8fdb\u884c\u91cd\u4e0b");
            return;
        }
        if (!StringUtils.isEmpty((String)baseOrder.getPortfolioId()) || !StringUtils.isEmpty((String)baseOrder.getPortfolioName())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6295\u7ec4\u7b97\u6cd5\u6682\u4e0d\u652f\u6301\u91cd\u4e0b");
            return;
        }
        if (!this.CAN_REORDER_TYPE.contains(baseOrder.getType().getRaw())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ea\u6709\u7bee\u5b50\u7b97\u6cd5\u53ef\u4ee5\u8fdb\u884c\u91cd\u4e0b");
            return;
        }
        List fundList = this.faccService.getFundAccountList("CCS");
        for (FundAccount fund : fundList) {
            Set<Order> setQuery;
            if (!fund.getInvestId().equals(baseOrder.getInvestorId()) || (setQuery = this.orderModel.queryUnfinishedOrder(fund)) == null) continue;
            for (Order order : setQuery) {
                if (!baseOrder.getBaseId().equals(order.getBaseId()) || !order.isCanCancel()) continue;
                logger.info(String.valueOf(order.getOrderId()) + "\u72b6\u6001\u4e3a:" + order.getOrdStatus().getRaw() + ",\u65e0\u6cd5\u751f\u6210\u4e34\u65f6\u7bee\u5b50");
                this.alert.alert(Alert.AlertType.ERROR, "\u4e34\u65f6\u7bee\u5b50\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u5148\u624b\u5de5\u64a4\u56de\u539f\u6709\u672a\u5b8c\u6210\u59d4\u6258\u5355" + order.getOrderId());
                return;
            }
        }
        String date = DateTimeUtils.getDate();
        try {
            List<AlgoStrategyDetails> listTemp = this.am.queryAlgoDetail(baseOrder.getInvestorId(), date, date, baseOrder.getBaseId());
            Basket basket = new Basket();
            basket.setDirection(true);
            basket.setId(String.valueOf(baseOrder.getBaseId()) + UUID.randomUUID().toString().substring(0, 10));
            basket.setName(String.valueOf(baseOrder.getBaseId()) + "\u4e34\u65f6\u7bee\u5b50");
            basket.setUnModified(true);
            ArrayList<BasketItem> items = new ArrayList<BasketItem>();
            basket.setList(items);
            int i = 1;
            for (AlgoStrategyDetails algoStrategyDetails : listTemp) {
                logger.info(String.valueOf(algoStrategyDetails.getSecId()) + "|" + algoStrategyDetails.getOrderVol() + "|" + algoStrategyDetails.getDeal());
                if (algoStrategyDetails.getOrderVol() - algoStrategyDetails.getDeal() <= 0.0) continue;
                BasketItem item = new BasketItem();
                item.setUnit(QueryUtils.getUnit(algoStrategyDetails.getSecType(), algoStrategyDetails.getMarket()));
                item.setId(i++);
                item.setSecurityId(algoStrategyDetails.getSecId());
                item.setSecurityName(algoStrategyDetails.getSecName());
                item.setWeight(1.0);
                item.getMarket().setRaw(algoStrategyDetails.getMarket());
                item.getBs().setRaw(algoStrategyDetails.isBuy() ? "49" : "50");
                item.setCount(Double.valueOf(algoStrategyDetails.getOrderVol() - algoStrategyDetails.getDeal()).longValue());
                item.setPrice(algoStrategyDetails.getPriceLmt());
                item.setSecurityType(algoStrategyDetails.getSecType());
                items.add(item);
            }
            if (items.isEmpty()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8be5\u7bee\u5b50\u5df2\u5168\u90e8\u6210\u4ea4");
                return;
            }
            MEvent mEvent = new MEvent();
            mEvent.setObj((Object)basket);
            this.es.sendEvent("add.temp.basket", mEvent);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u751f\u6210\u7bee\u5b50" + basket.getName() + "\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7b97\u6cd5\u6267\u884c\u8fdb\u5ea6\u51fa\u9519" + (Object)((Object)e));
        }
    }

    private ReadOnlyObjectWrapper<Object> setOperate(AlgoBaseOrder order) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button cancel = new Button("\u64a4\u5355");
        Button update = new Button("\u64a4\u6539");
        Button param = new Button("\u7b97\u6cd5\u53c2\u6570");
        Button detail = new Button("\u7b97\u6cd5\u8be6\u60c5");
        Button evaluate = new Button("\u7b97\u6cd5\u8bc4\u4ef7");
        if (!"235".contains(order.getStatus().getRaw())) {
            cancel.setOnAction(event -> this.cancel(order));
            update.setOnAction(event -> this.update(order));
            if (!StringUtils.isApama((String)order.getType().getRaw())) {
                update.setVisible(false);
            }
        } else {
            cancel.setVisible(false);
            update.setVisible(false);
        }
        cancel.getStyleClass().add((Object)"btnOperation");
        update.getStyleClass().add((Object)"btnOperation");
        param.getStyleClass().add((Object)"btnOperation");
        detail.getStyleClass().add((Object)"btnOperation");
        evaluate.getStyleClass().add((Object)"btnOperation");
        cancel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"short"), true);
        update.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"short"), true);
        param.setOnAction(event -> this.lookOver(order));
        detail.setOnAction(event -> this.algoDetail(order));
        evaluate.setOnAction(event -> this.algoEvaluate(order));
        if (this.cancelAuthorized) {
            box.getChildren().add((Object)cancel);
        }
        if (this.updateAuthorized) {
            box.getChildren().add((Object)update);
        }
        box.getChildren().addAll((Object[])new Node[]{param, detail});
        String raw = order.getType().getRaw();
        if (!"17".equals(raw)) {
            box.getChildren().add((Object)evaluate);
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void cancel(AlgoBaseOrder order) {
        this.tableBase.getSelectionModel().select((Object)order);
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u7ec8\u6b62\u7b97\u6cd5\uff0c\u5e76\u64a4\u9500\u8be5\u7b97\u6cd5\u7684\u672a\u5b8c\u6210\u59d4\u6258\uff1f")) {
            try {
                if (AlgoMiseMng.isMise(order.getType().getRaw())) {
                    this.miseMng.miseCancelOrder(order.getSubAcct(), order.getBaseId());
                } else {
                    this.tradeModel.cancelOrder(order);
                }
                this.alert.alert(Alert.AlertType.INFORMATION, "\u7b97\u6cd5\u8ba2\u5355[" + order.getId() + "]\uff0c\u64a4\u9500\u6210\u529f\uff01");
            }
            catch (MException e) {
                String msg = e.getMessage();
                if ("\u4f20\u5165\u7684\u8ba2\u5355\u7f16\u53f7\u65e0\u6548".equals(msg)) {
                    msg = "\u4f20\u5165\u7684\u8ba2\u5355\u7f16\u53f7\u65e0\u6548\uff01\uff08\u5982\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7b49\u5f85\u7ed3\u679c\uff09";
                }
                this.alert.alert(Alert.AlertType.ERROR, msg);
                logger.error((Object)e, (Throwable)e);
            }
            this.refresh();
        }
    }

    private void update(AlgoBaseOrder order) {
        this.tableBase.getSelectionModel().select((Object)order);
        MEvent event = new MEvent();
        try {
            this.tradeModel.getOrderDetails(order);
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        event.setObj((Object)order);
        this.es.sendEvent("update.algo.event", event);
    }

    private void lookOver(AlgoBaseOrder order) {
        if (this.isStartegyDialog(order)) {
            return;
        }
        this.tableBase.getSelectionModel().select((Object)order);
        MEvent event = new MEvent();
        try {
            this.tradeModel.getOrderDetails(order);
            event.setObj((Object)order);
            this.es.sendEvent("algo.dialog", event);
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private boolean isStartegyDialog(AlgoBaseOrder order) {
        String type = order.getType().getRaw();
        if (!type.equals("17")) {
            return false;
        }
        AdjPositionParamDialog adj = (AdjPositionParamDialog)((Object)this.of.create(AdjPositionParamDialog.class));
        adj.setStrategy(order);
        MxDialog dialog = this.df.create((DialogObj)adj, "\u53c2\u6570");
        dialog.setBtnText(ButtonType.OK, "\u5173\u95ed");
        dialog.launch();
        return true;
    }

    protected void algoDetail(AlgoBaseOrder order) {
        this.tableBase.getSelectionModel().select((Object)order);
        AlgoDetailDialog.setBase(order);
        AlgoDetailDialog query = (AlgoDetailDialog)((Object)this.of.create(AlgoDetailDialog.class));
        MxDialog dialog = this.df.create((DialogObj)query, "\u7b97\u6cd5\u8be6\u60c5");
        dialog.launch();
    }

    protected void algoEvaluate(AlgoBaseOrder order) {
        try {
            this.tradeModel.getOrderDetails(order);
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        String code = order.getCode();
        String market = order.getMarket();
        String fundAcctId = order.getAlgoParam().getFundAccId();
        String secAcctId = order.getAlgoParam().getSecAccId();
        String subFundId = "";
        String subSecId = "";
        AlgoStrategyDetails details = null;
        if (AlgoMiseMng.isMise(order.getType().getRaw())) {
            details = this.basketAlgoEvaluate(order);
            if (details == null) {
                return;
            }
            code = details.getSecId();
            market = details.getMarket();
            fundAcctId = details.getFundAccntId();
            secAcctId = details.getSecAccntId();
            subFundId = details.getSubFundId();
            subSecId = details.getSubSecId();
        }
        String format = "/algo-evaluate?algoOid=%s&date=%s&secCode=%s&mkt=%s&slot=64&begin=%s&end=%s&fundAcct=%s&secAcct=%s&subFundAcct=%s&subSecAcct=%s";
        SettingDialog sd = (SettingDialog)this.of.create(SettingDialog.class);
        String url = String.format(format, order.getBaseId(), order.getOrderDate(), code, market, order.getOrderStartTime(), order.getOrderEndTime(), fundAcctId, secAcctId, subFundId, subSecId);
        sd.setUrl(url);
        logger.debug(String.valueOf(order.getBaseId()) + " : " + url);
        MxWebDialog dialog = this.df.createWeb((WebBrowserPart)sd, "\u7b97\u6cd5\u8bc4\u4ef7", 1200, 600);
        dialog.launch();
        dialog.disposeBrowser();
    }

    private AlgoStrategyDetails basketAlgoEvaluate(AlgoBaseOrder order) {
        BasketAlgoEvaluateDialog.baseOrder = order;
        BasketAlgoEvaluateDialog deatil = (BasketAlgoEvaluateDialog)((Object)this.of.create(BasketAlgoEvaluateDialog.class));
        MxDialog dialog = this.df.create((DialogObj)deatil, "\u8bf7\u9009\u62e9\u6210\u5206\u80a1");
        ButtonType btnType = dialog.launch();
        if (btnType == ButtonType.OK) {
            return deatil.getSelectedItem();
        }
        return null;
    }

    public class StatusCell<T>
    extends TableCell<T, MxNode> {
        private Label label = new Label();

        public StatusCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode node, boolean empty) {
            try {
                if (node == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                String raw = node.getRaw();
                if (raw == null || raw.trim().isEmpty()) {
                    return;
                }
                this.label.setText(node.getValue());
                if (raw.equals("2") || raw.equals("5") || raw.equals("999")) {
                    CssUtils.makeRise((Control)this.label);
                    this.label.setStyle("-fx-font-weight: bold;");
                } else {
                    CssUtils.makeEven((Control)this.label);
                    this.label.setStyle("");
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

