/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEventHandler;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfOrderModel;
import cms.tmx.query.current.views.CcsOrderPart;
import cms.tmx.query.current.views.portfolio.LoadPartModel;
import java.net.URL;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoOrderPart
extends CcsOrderPart {
    @FXML
    private TableColumn<CcsOrder, String> colPortfolioId;
    @FXML
    private TableColumn<CcsOrder, String> colPortfolioName;
    @Inject
    protected CcsOrderModel model;
    @Inject
    protected CcsPortfOrderModel pmodel;
    private MEventHandler lstnBase = event -> this.lstnSearch.invalidated(null);
    @Inject
    private LoadPartModel load;

    public AlgoOrderPart() {
        this.path = "CcsPortfOrderPart.fxml";
    }

    @Override
    public void initialize() {
        this.listener();
        this.createTable();
        if (this.model.getList().size() == 0) {
            this.model.query();
        }
        if (this.pmodel.getList().size() == 0) {
            this.pmodel.query();
        }
        this.onFocus();
        this.lstnSearch.invalidated(null);
        this.es.subscribe("algo.base.id", this.lstnBase);
    }

    @Override
    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.pmodel.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.es.unSubscribe("algo.base.id", this.lstnBase);
    }

    @Override
    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.pmodel.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Override
    @FXML
    public void refresh() {
        this.model.query();
        this.pmodel.query();
    }

    @Override
    protected void createTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getPortfolioName()));
        super.createTable();
    }

    @Override
    public boolean premise(CcsOrder en) {
        return en.getExecModeType() == 3 && en.getBaseId().equals(CcsOrderModel.baseId);
    }

    @Override
    protected OrderQueryModel<CcsOrder> getModel() {
        if (CcsOrderModel.isNormal) {
            return this.model;
        }
        return this.pmodel;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("CcsPortfOrderPart.fxml");
        }
        return url;
    }
}

