/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.views.portfolio.AlgoDetailDialog;
import cms.tmx.query.current.views.portfolio.DealHisPart;
import cms.tmx.query.current.views.portfolio.OrderHisPart;
import cms.tmx.query.current.views.portfolio.ProgressHisPart;
import cms.tmx.query.history.models.AlgoHisQueryModel;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;

public class AlgoHisQueryDialog
extends DialogObj {
    @FXML
    private AnchorPane paneEntrust;
    @FXML
    private AnchorPane paneOrder;
    @FXML
    private AnchorPane paneDeal;
    @Inject
    private ProgressHisPart entrustPart;
    @Inject
    private OrderHisPart orderPart;
    @Inject
    private DealHisPart dealPart;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabEntrust;
    @Inject
    private MEventService es;
    @Inject
    private AlgoHisQueryModel model;
    private static final double WIDTH = 828.0;
    static String baseId;
    static String sysId;

    AlgoHisQueryDialog() {
        this.fxml = String.valueOf(AlgoDetailDialog.class.getSimpleName()) + ".fxml";
    }

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    @FXML
    public void initialize() {
        this.paneEntrust.getChildren().add((Object)this.limitWidth(this.entrustPart.getContent()));
        this.paneDeal.getChildren().add((Object)this.limitWidth(this.dealPart.getContent()));
        this.paneOrder.getChildren().add((Object)this.limitWidth(this.orderPart.getContent()));
    }

    private Parent limitWidth(Parent content) {
        ((VBox)content).setPrefWidth(828.0);
        return content;
    }

    public void setOrder(AlgoBaseOrder baseOrder) {
        sysId = baseOrder.getId();
        if (AlgoMiseMng.isMise(baseOrder.getType().getRaw())) {
            baseId = baseOrder.getBaseId();
            MEvent event = new MEvent();
            event.setObj((Object)baseOrder);
            this.es.postEvent("his.basket.base.order.change.his", event);
        } else {
            baseId = String.valueOf(baseOrder.getBaseId()) + "_" + baseOrder.getId();
            Platform.runLater(() -> this.tabPane.getTabs().remove((Object)this.tabEntrust));
        }
        this.model.setHisBase(baseOrder);
    }
}

