/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.models.AlgoDetailModel;
import cms.tmx.query.current.models.HkwolunOrderModel;
import cms.tmx.query.current.models.portfolio.HkwolunPortfOrderModel;
import cms.tmx.query.current.views.portfolio.AlgoDetailDialog;
import cms.tmx.query.current.views.portfolio.CcsPortfOrderPart;
import cms.tmx.query.current.views.portfolio.LoadPartModel;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoDetailOrderPart
extends CcsPortfOrderPart {
    private static final Logger logger = LogManager.getLogger(AlgoDetailOrderPart.class);
    @Inject
    private AlgoDetailModel modelA;
    @Inject
    private HkwolunOrderModel modelHk;
    @Inject
    private HkwolunPortfOrderModel modelHkP;
    private boolean today = false;
    private boolean isPortf = false;
    protected InvalidationListener lstnModelA = ob -> {
        List<CcsOrder> newList = this.getList();
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.sort();
        });
    };
    protected InvalidationListener lstnSearchA = ob -> this.mxList.filter(this.getList(), this.pd);
    @Inject
    private LoadPartModel load;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void initialize() {
        String now = LocalDate.now().toString().replace("-", "");
        this.today = now.equals(AlgoDetailDialog.base.getOrderDate());
        this.isPortf = !AlgoDetailDialog.base.getPortfolioName().isEmpty();
        this.listener();
        this.createTable();
        try {
            if (this.today) {
                if (this.isPortf) {
                    if (this.modelP.getList().isEmpty()) {
                        if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                            this.modelHkP.query();
                        } else {
                            this.modelP.query();
                        }
                    } else {
                        this.lstnModelA.invalidated(null);
                    }
                } else if (this.model.getList().isEmpty()) {
                    if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                        this.modelHk.query();
                    } else {
                        this.model.query();
                    }
                } else {
                    this.lstnModelA.invalidated(null);
                }
            } else {
                this.modelA.setHisBase(AlgoDetailDialog.base);
                this.modelA.queryHisOrder();
            }
        }
        catch (MException e) {
            logger.error("query algo order faild", (Throwable)e);
        }
        this.onFocus();
    }

    @Override
    public boolean premise(CcsOrder en) {
        if (!this.today) {
            return true;
        }
        return en.getExecModeType() == 3 && en.getBaseId().equals(AlgoDetailDialog.baseId);
    }

    @Override
    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModelA);
        this.modelP.changedProperty().removeListener(this.lstnModelA);
        this.modelA.changedOrderProperty().removeListener(this.lstnModelA);
        this.modelHk.changedProperty().removeListener(this.lstnModelA);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @Override
    protected void listener() {
        if (this.today) {
            if (this.isPortf) {
                if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                    this.modelHkP.changedProperty().addListener(this.lstnModelA);
                } else {
                    this.modelP.changedProperty().addListener(this.lstnModelA);
                }
            } else if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                this.modelHk.changedProperty().addListener(this.lstnModelA);
            } else {
                this.model.changedProperty().addListener(this.lstnModelA);
            }
        } else {
            this.modelA.changedOrderProperty().addListener(this.lstnModelA);
        }
        this.searchText.textProperty().addListener(this.lstnSearchA);
    }

    @Override
    @FXML
    public void refresh() {
        try {
            if (this.today) {
                if (this.isPortf) {
                    if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                        this.modelHkP.query();
                    } else {
                        this.modelP.query();
                    }
                } else if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                    this.modelHk.query();
                } else {
                    this.model.query();
                }
            } else {
                this.modelA.setHisBase(AlgoDetailDialog.base);
                this.modelA.queryHisOrder();
            }
        }
        catch (MException e) {
            logger.error("query algo order faild", (Throwable)e);
        }
    }

    @Override
    protected void tableDoubleClick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CcsOrder> getList() {
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        if (this.today) {
            if (this.isPortf) {
                if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                    ObservableList<CcsOrder> observableList = this.modelHkP.getList();
                    synchronized (observableList) {
                        newList.addAll((Collection<CcsOrder>)this.modelHkP.getList());
                    }
                } else {
                    ObservableList<CcsOrder> observableList = this.modelP.getList();
                    synchronized (observableList) {
                        newList.addAll((Collection<CcsOrder>)this.modelP.getList());
                    }
                }
            } else if (StringUtils.belongto((String)AlgoDetailDialog.base.getMarket(), (String[])new String[]{"SHSC", "SZSC"})) {
                ObservableList observableList = this.modelHk.getList();
                synchronized (observableList) {
                    newList.addAll((Collection<CcsOrder>)this.modelHk.getList());
                }
            } else {
                ObservableList observableList = this.model.getList();
                synchronized (observableList) {
                    newList.addAll((Collection<CcsOrder>)this.model.getList());
                }
            }
        } else {
            newList.addAll(this.modelA.getListOrder());
        }
        return newList;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("CcsPortfOrderPart.fxml");
        }
        return url;
    }
}

