/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEventHandler;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.portfolio.CcsPortfDealModel;
import cms.tmx.query.current.views.CcsDealPart;
import cms.tmx.query.current.views.portfolio.LoadPartModel;
import java.net.URL;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoDealPart
extends CcsDealPart {
    @FXML
    private TableColumn<CcsDeal, String> colPortfolioId;
    @FXML
    private TableColumn<CcsDeal, String> colPortfolioName;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioId;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioName;
    @Inject
    protected CcsDealModel model;
    @Inject
    protected CcsPortfDealModel pmodel;
    private MEventHandler lstnBase = event -> this.lstnSearch.invalidated(null);
    @Inject
    private LoadPartModel load;

    public AlgoDealPart() {
        this.path = "CcsPortfDealPart.fxml";
    }

    @Override
    protected void createTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        this.colCountPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colCountPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        super.createTable();
        super.createCountTable();
    }

    @Override
    public void initialize() {
        this.listener();
        this.createTable();
        if (this.model.getList().size() == 0) {
            this.model.query();
        }
        if (this.pmodel.getList().size() == 0) {
            this.pmodel.query();
        }
        this.onFocus();
        this.lstnSearch.invalidated(null);
        this.es.subscribe("algo.base.id", this.lstnBase);
    }

    @Override
    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.pmodel.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.es.unSubscribe("algo.base.id", this.lstnBase);
    }

    @Override
    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.pmodel.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Override
    @FXML
    public void refresh() {
        this.model.query();
        this.pmodel.query();
    }

    @Override
    public boolean premise(CcsDeal en) {
        return en.getExecModeType() == 3 && en.getBaseId().equals(CcsDealModel.baseId);
    }

    @Override
    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getInstrument().getSecId() + deal.getBaseId();
        return key;
    }

    @Override
    protected DealQueryModel<CcsDeal> getModel() {
        if (CcsDealModel.isNormal) {
            return this.model;
        }
        return this.pmodel;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("CcsPortfDealPart.fxml");
        }
        return url;
    }
}

