/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.block;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.block.BlockUnfinishedModel;
import cms.tmx.query.current.views.block.BlockCancelConfirmDialog;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockUnfinishedOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BlockUnfinishedOrderPart.class);
    @FXML
    protected TableView<BlockOrder> tableUnOrder;
    @FXML
    protected TableColumn<BlockOrder, Boolean> selected;
    @FXML
    protected TableColumn<BlockOrder, String> colSecId;
    @FXML
    protected TableColumn<BlockOrder, String> colSecName;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colSide;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colType;
    @FXML
    protected TableColumn<BlockOrder, Number> colPrice;
    @FXML
    protected TableColumn<BlockOrder, Number> colOrderQty;
    @FXML
    protected TableColumn<BlockOrder, String> colUnit;
    @FXML
    protected TableColumn<BlockOrder, Number> colDoneVol;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colOrdStatus;
    @FXML
    protected TableColumn<BlockOrder, String> colOrderId;
    @FXML
    protected TableColumn<BlockOrder, String> colOrdTime;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colMarket;
    @FXML
    protected TableColumn<BlockOrder, String> colAccId;
    @FXML
    protected TableColumn<BlockOrder, String> colSecAcc;
    @FXML
    protected TableColumn<BlockOrder, String> colSysTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colOurTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colContractNo;
    @FXML
    protected TableColumn<BlockOrder, String> colOppositeTradingUnit;
    @FXML
    protected TableColumn<BlockOrder, String> colOppositeTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colContact;
    @FXML
    protected TableColumn<BlockOrder, String> colRemark;
    @FXML
    protected TextField searchText;
    @FXML
    protected CheckBox cbxAll;
    @FXML
    protected Button btnAllOrderCancel;
    @Inject
    private BlockUnfinishedModel model;
    @Inject
    private MxAlert alert;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    private MxList<BlockOrder> mlist = new MxList();
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected Predicate<BlockOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((BlockOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        return this.extend((BlockOrder)en);
    };
    protected InvalidationListener lstnSearch = ob -> {
        List<BlockOrder> list = this.model.getList();
        synchronized (list) {
            this.mlist.filter(this.model.getList(), this.pd);
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.cbxAll.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mlist.getList();
            synchronized (observableList) {
                this.mlist.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
    }

    public boolean premise(BlockOrder order) {
        return true;
    }

    public boolean extend(BlockOrder order) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<BlockOrder> newList = Collections.synchronizedList(new ArrayList());
        List<BlockOrder> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o2.getTime().compareTo(o1.getTime()));
            this.tableUnOrder.sort();
        });
    }

    public void createTable() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((BlockOrder)data.getValue()).selectedProperty());
        this.colSecId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSide.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sideProperty());
        this.colSide.setCellFactory(data -> new SideCell());
        this.colType.setCellValueFactory(data -> ((BlockOrder)data.getValue()).typeProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockOrder)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderQtyProperty());
        this.colOrderQty.setCellFactory(data -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).unitProperty());
        this.colDoneVol.setCellValueFactory(data -> ((BlockOrder)data.getValue()).dealQtyProperty());
        this.colDoneVol.setCellFactory(data -> new NumberTableCell());
        this.colOrdStatus.setCellValueFactory(data -> ((BlockOrder)data.getValue()).statusProperty());
        this.colOrderId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderIdProperty());
        this.colOrdTime.setCellValueFactory(data -> ((BlockOrder)data.getValue()).timeProperty());
        this.colMarket.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().marketProperty());
        this.colAccId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).inverstorSecIdProperty());
        this.colSysTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sysTraderProperty());
        this.colContractNo.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contractNoProperty());
        this.colOppositeTradingUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTradingUnitProperty());
        this.colOppositeTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTraderProperty());
        this.colContact.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contactProperty());
        this.colRemark.setCellValueFactory(data -> ((BlockOrder)data.getValue()).remarkProperty());
        this.colRemark.setCellFactory(data -> new TooltipTableCell<BlockOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((BlockOrder)this.getValue()).getRemark();
            }
        });
        this.tableUnOrder.setItems(this.mlist.getList());
        this.tableUnOrder.refresh();
    }

    @FXML
    public void cancel() {
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        this.tableUnOrder.getItems().forEach(en -> {
            if (en.isSelected()) {
                list.add((BlockOrder)en);
            }
        });
        if (list.isEmpty()) {
            return;
        }
        BlockCancelConfirmDialog obj = (BlockCancelConfirmDialog)((Object)this.of.create(BlockCancelConfirmDialog.class));
        obj.setList(list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            String result = this.model.cancel(list);
            this.alert.alert(Alert.AlertType.INFORMATION, result);
        }
    }

    @FXML
    public void allCancel() {
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        this.tableUnOrder.getItems().forEach(en -> list.add((BlockOrder)en));
        if (list.isEmpty()) {
            return;
        }
        BlockCancelConfirmDialog obj = (BlockCancelConfirmDialog)((Object)this.of.create(BlockCancelConfirmDialog.class));
        obj.setList(list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u5168\u90e8\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            String result = this.model.cancel(list);
            this.alert.alert(Alert.AlertType.INFORMATION, result);
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableUnOrder);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableUnOrder, (String)"\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class PriceCell
    extends DoubleTableCell<BlockOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

