/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.block;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.block.BlockOrderModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BlockOrderPart.class);
    @FXML
    protected TableView<BlockOrder> tableOrder;
    @FXML
    protected TableColumn<BlockOrder, String> colSecId;
    @FXML
    protected TableColumn<BlockOrder, String> colSecName;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colSide;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colType;
    @FXML
    protected TableColumn<BlockOrder, Number> colPrice;
    @FXML
    protected TableColumn<BlockOrder, Number> colOrderQty;
    @FXML
    protected TableColumn<BlockOrder, String> colUnit;
    @FXML
    protected TableColumn<BlockOrder, Number> colDoneVol;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colOrdStatus;
    @FXML
    protected TableColumn<BlockOrder, String> colOrderId;
    @FXML
    protected TableColumn<BlockOrder, String> colOrdTime;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colMarket;
    @FXML
    protected TableColumn<BlockOrder, String> colAccId;
    @FXML
    protected TableColumn<BlockOrder, String> colSecAcc;
    @FXML
    protected TableColumn<BlockOrder, String> colSysTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colOurTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colContractNo;
    @FXML
    protected TableColumn<BlockOrder, String> colOppositeTradingUnit;
    @FXML
    protected TableColumn<BlockOrder, String> colOppositeTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colContact;
    @FXML
    protected TableColumn<BlockOrder, String> colRemark;
    @FXML
    protected TextField searchText;
    @Inject
    private BlockOrderModel model;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    private MxList<BlockOrder> mlist = new MxList();
    protected Predicate<BlockOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((BlockOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        return this.extend((BlockOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected InvalidationListener lstnSearch = ob -> {
        List<BlockOrder> list = this.model.getList();
        synchronized (list) {
            this.mlist.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(BlockOrder order) {
        return true;
    }

    public boolean extend(BlockOrder order) {
        return false;
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<BlockOrder> newList = Collections.synchronizedList(new ArrayList());
        List<BlockOrder> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o2.getTime().compareTo(o1.getTime()));
            this.tableOrder.sort();
        });
    }

    public void createTable() {
        this.colSecId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSide.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sideProperty());
        this.colSide.setCellFactory(data -> new SideCell());
        this.colType.setCellValueFactory(data -> ((BlockOrder)data.getValue()).typeProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockOrder)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderQtyProperty());
        this.colOrderQty.setCellFactory(data -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).unitProperty());
        this.colDoneVol.setCellValueFactory(data -> ((BlockOrder)data.getValue()).dealQtyProperty());
        this.colDoneVol.setCellFactory(data -> new NumberTableCell());
        this.colOrdStatus.setCellValueFactory(data -> ((BlockOrder)data.getValue()).statusProperty());
        this.colOrderId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderIdProperty());
        this.colOrdTime.setCellValueFactory(data -> ((BlockOrder)data.getValue()).timeProperty());
        this.colMarket.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().marketProperty());
        this.colAccId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).inverstorSecIdProperty());
        this.colSysTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sysTraderProperty());
        this.colContractNo.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contractNoProperty());
        this.colOppositeTradingUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTradingUnitProperty());
        this.colOppositeTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTraderProperty());
        this.colContact.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contactProperty());
        this.colRemark.setCellValueFactory(data -> ((BlockOrder)data.getValue()).remarkProperty());
        this.colRemark.setCellFactory(data -> new TooltipTableCell<BlockOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((BlockOrder)this.getValue()).getRemark();
            }
        });
        this.tableOrder.setItems(this.mlist.getList());
        this.tableOrder.refresh();
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class PriceCell
    extends DoubleTableCell<BlockOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<BlockOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

