/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.block;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.DealSum;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.block.BlockDealModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class BlockDealPart
extends MxPart {
    @FXML
    protected TableView<BlockDeal> tableDeal;
    @FXML
    private TableColumn<BlockDeal, String> colSecId;
    @FXML
    private TableColumn<BlockDeal, String> colSecName;
    @FXML
    private TableColumn<BlockDeal, MxNode> colDir;
    @FXML
    private TableColumn<BlockDeal, Number> colVol;
    @FXML
    private TableColumn<BlockDeal, String> colUnit;
    @FXML
    private TableColumn<BlockDeal, Number> colPrice;
    @FXML
    private TableColumn<BlockDeal, String> colTime;
    @FXML
    private TableColumn<BlockDeal, MxNode> colMkt;
    @FXML
    private TableColumn<BlockDeal, String> colENo;
    @FXML
    private TableColumn<BlockDeal, String> colDealNo;
    @FXML
    private TableColumn<BlockDeal, String> colAcc;
    @FXML
    private TableColumn<BlockDeal, String> colSecAcc;
    @FXML
    private TableColumn<BlockDeal, Number> colAmt;
    @FXML
    private TableColumn<BlockDeal, String> colReference;
    @FXML
    protected TableView<DealSum> tableDealCount;
    @FXML
    private TableColumn<DealSum, String> colCountSecId;
    @FXML
    private TableColumn<DealSum, String> colCountSecName;
    @FXML
    private TableColumn<DealSum, MxNode> colCountDir;
    @FXML
    private TableColumn<DealSum, Number> colCountVol;
    @FXML
    private TableColumn<DealSum, String> colCountUnit;
    @FXML
    private TableColumn<DealSum, Number> colCountPrice;
    @FXML
    private TableColumn<DealSum, MxNode> colCountMkt;
    @FXML
    private TableColumn<DealSum, Number> colCountAmount;
    @FXML
    private TableColumn<DealSum, Number> colCount;
    @FXML
    private TableColumn<DealSum, String> colCountAcc;
    @FXML
    protected TextField searchText;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    @Inject
    protected BlockDealModel model;
    @Inject
    private IRefDataMng refMng;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<BlockDeal> mxList = new MxList();
    protected MxList<DealSum> mxCountList = new MxList();
    private static final Logger logger = LogManager.getLogger(BlockDealPart.class);
    @Inject
    private MxAlert alert;
    protected Predicate<BlockDeal> pd = deal -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((BlockDeal)deal)) {
            return false;
        }
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (deal.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (deal.getDealId().contains(text)) {
            return true;
        }
        return this.extend((BlockDeal)deal);
    };
    protected Predicate<DealSum> pdSum = deal -> {
        String text = this.searchText.getText().trim();
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        return deal.getInstrument().getSymbol().contains(text);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<BlockDeal> newList = Collections.synchronizedList(new ArrayList());
        List<BlockDeal> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getTime().compareTo(o1.getTime()));
            this.tableDeal.sort();
            this.mxCountList.update(this.model.getListSum(), this.pdSum);
            this.tableDealCount.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        List<BlockDeal> list = this.model.getList();
        synchronized (list) {
            this.mxList.filter(this.model.getList(), this.pd);
            this.mxCountList.filter(this.model.getListSum(), this.pdSum);
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.setRadio();
        this.createTable();
        this.createCountTable();
        this.refresh();
        this.onFocus();
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableDeal.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    protected void listener() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    @Focus
    public void onFocus() {
        this.tableDeal.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableDeal);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableDeal, (String)"\u6210\u4ea4\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public boolean premise(BlockDeal deal) {
        return true;
    }

    public boolean extend(BlockDeal deal) {
        return false;
    }

    protected void createTable() {
        this.colSecId.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().symbolProperty());
        this.colDir.setCellValueFactory(data -> ((BlockDeal)data.getValue()).sideProperty());
        this.colDir.setCellFactory(cell -> new SideCell());
        this.colVol.setCellFactory(column -> new NumberTableCell());
        this.colVol.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealQtyProperty());
        this.colUnit.setCellValueFactory(data -> ((BlockDeal)data.getValue()).unitProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockDeal)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new PriceCell());
        this.colTime.setCellValueFactory(data -> ((BlockDeal)data.getValue()).timeProperty());
        this.colMkt.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().marketProperty());
        this.colENo.setCellValueFactory(data -> ((BlockDeal)data.getValue()).orderIdProperty());
        this.colDealNo.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealIdProperty());
        this.colAcc.setCellValueFactory(data -> ((BlockDeal)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockDeal)data.getValue()).inverstorSecIdProperty());
        this.colAmt.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealAmountProperty());
        this.colAmt.setCellFactory(data -> new PriceCell());
        this.colReference.setCellValueFactory(data -> ((BlockDeal)data.getValue()).referenceProperty());
        this.tableDeal.setPlaceholder((Node)new Label());
        this.tableDeal.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableDeal);
    }

    protected void createCountTable() {
        this.colCountSecId.setCellValueFactory(data -> ((DealSum)data.getValue()).getInstrument().secIdProperty());
        this.colCountSecName.setCellValueFactory(data -> ((DealSum)data.getValue()).getInstrument().symbolProperty());
        this.colCountDir.setCellValueFactory(data -> ((DealSum)data.getValue()).sideProperty());
        this.colCountDir.setCellFactory(cell -> new SideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> ((DealSum)data.getValue()).dealQtyProperty());
        this.colCountUnit.setCellValueFactory(data -> ((DealSum)data.getValue()).unitProperty());
        this.colCountPrice.setCellValueFactory(data -> ((DealSum)data.getValue()).avgPxProperty());
        this.colCountPrice.setCellFactory(data -> new AvgPriceCell());
        this.colCountMkt.setCellValueFactory(data -> ((DealSum)data.getValue()).getInstrument().marketProperty());
        this.colCountAmount.setCellValueFactory(data -> ((DealSum)data.getValue()).dealAmountProperty());
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> ((DealSum)data.getValue()).dealCountProperty());
        this.colCountAcc.setCellValueFactory(data -> ((DealSum)data.getValue()).investorIdProperty());
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
    }

    private class AvgPriceCell
    extends DoubleTableCell<DealSum> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<BlockDeal> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell<T>
    extends TableCell<T, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

