/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.block;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;

public class BlockCancelConfirmDialog
extends DialogObj {
    @FXML
    private TableView<BlockOrder> tableItems;
    @FXML
    private TableColumn<BlockOrder, String> index;
    @FXML
    private TableColumn<BlockOrder, String> colCode;
    @FXML
    private TableColumn<BlockOrder, String> colName;
    @FXML
    private TableColumn<BlockOrder, MxNode> colMkt;
    @FXML
    private TableColumn<BlockOrder, MxNode> colDirection;
    @FXML
    protected TableColumn<BlockOrder, Number> colCount;
    @FXML
    protected TableColumn<BlockOrder, Number> colPrice;
    @FXML
    private TableColumn<BlockOrder, String> colAcc;
    @FXML
    private TableColumn<BlockOrder, String> colSecAcc;
    @FXML
    private TableColumn<BlockOrder, String> colPorfolio;
    @FXML
    private TableColumn<BlockOrder, String> colTip;
    @FXML
    private TableColumn<BlockOrder, String> colContractNo;
    @FXML
    private TableColumn<BlockOrder, String> colOppositeTradingUnit;
    @FXML
    private TableColumn<BlockOrder, String> colOppositeTrader;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label lbTotal;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<BlockOrder> list = FxUtils.newList();
    private long totalCount;
    private double totalAmt;
    private String strTip = "";
    private String dialogType;

    @FXML
    public void initialize() {
        this.createTable();
        this.initValue();
    }

    public void setList(List<BlockOrder> list) {
        this.list.setAll(list);
    }

    protected void initValue() {
        this.lbTotalCount.setText(Long.toString(this.totalCount));
        this.lbTotalAmt.setText(StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        this.lbTotal.setVisible(this.totalCount != 0L);
        this.lbTotalCount.setVisible(this.totalCount != 0L);
        this.lbTotalAmt.setVisible(this.totalAmt != 0.0);
        this.totalTip.setText(this.strTip);
        this.tpTip.setText(this.strTip);
    }

    protected void createTable() {
        TableUtils.isAuto(this.index);
        this.colCode.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().secIdProperty());
        this.colName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().symbolProperty());
        this.colMkt.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().marketProperty());
        this.colDirection.setCellValueFactory(data -> ((BlockOrder)data.getValue()).typeProperty());
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).inverstorSecIdProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockOrder)data.getValue()).priceProperty());
        this.colCount.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderQtyProperty());
        this.colTip.setCellValueFactory(m -> ((BlockOrder)m.getValue()).orderIdProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colContractNo.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contractNoProperty());
        this.colOppositeTradingUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTradingUnitProperty());
        this.colOppositeTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTraderProperty());
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setItems(this.list);
    }

    private class SideCell
    extends TableCell<BlockOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            String txt = value.getValue();
            txt = txt == null || txt.isEmpty() ? "\u64a4\u5355" : String.valueOf(txt) + "\u64a4\u5355";
            this.label.setText(txt);
            BlockOrder order = (BlockOrder)this.getTableRow().getItem();
            int side = StringUtils.parseInt((String)order.getSide().getRaw());
            switch (side) {
                case 49: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<BlockOrder, String> {
        private Label label = new Label();

        private TipCell() {
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                this.label.setTooltip(null);
                return;
            }
            value = "\u59d4\u6258\u7f16\u53f7\uff1a" + value;
            this.label.setText(value);
            this.label.setTooltip(new Tooltip(value));
            this.setGraphic((Node)this.label);
        }
    }
}

