/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.portfolio.UnusualOrderModel;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class UnusualOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(UnusualOrderPart.class);
    @FXML
    protected TableView<CcsOrder> tableUnOrder;
    @FXML
    protected TableColumn<CcsOrder, Boolean> selected;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colOrdTime;
    @FXML
    private TableColumn<CcsOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<CcsOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CcsOrder, String> colUnit;
    @FXML
    private TableColumn<CcsOrder, String> colOrderId;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colSecAcc;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CcsOrder, Number> colPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CcsOrder, String> colBaseId;
    @FXML
    private TableColumn<CcsOrder, String> colType;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> colUser;
    @FXML
    protected TableColumn<CcsOrder, String> colReference;
    @FXML
    private TableColumn<CcsOrder, Label> colCancel;
    @FXML
    protected TextField searchText;
    @FXML
    protected CheckBox cbxShowAll;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbPort;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @Inject
    private IAccountService accntService;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private IFundAccountService fundService;
    @Inject
    protected UnusualOrderModel orderModel;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IUiRightService rightsModel;
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    protected MxList<CcsOrder> mxList = new MxList();
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getUserId().contains(text)) {
            return true;
        }
        if (en.getUserName().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    private StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };
    protected InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        List<CcsOrder> list = this.orderModel.getList();
        synchronized (list) {
            newList.addAll(this.orderModel.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableUnOrder.sort();
            this.tableUnOrder.refresh();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.orderModel.getList(), this.pd);
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isCanSelect()) {
                    e.setSelected(now.booleanValue());
                } else {
                    e.setSelected(false);
                }
            });
        }
    };
    protected ChangeListener<Boolean> lstnCheckShowBox = (obv, old, now) -> this.mxList.filter(this.orderModel.getList(), this.pd);
    private String dimension;
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;
    @Inject
    private LoadPartModel load;

    @FXML
    public void initialize() {
        this.initValue();
        this.createTableView();
        this.listener();
        this.refresh();
        this.tableUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.unfinishedorder")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
    }

    protected void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.orderModel.changedProperty().addListener(this.lstnModel);
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
        this.cbxShowAll.selectedProperty().addListener(this.lstnCheckShowBox);
    }

    @PreDestroy
    protected void close() {
        this.orderModel.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
        this.cbxShowAll.selectedProperty().removeListener(this.lstnCheckShowBox);
    }

    private void initValue() {
        MxNode node = MxNodeFactory.create((String)"query_dimension", (String)PRICE_ADJUST_UNIT_PERCENT);
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals(PRICE_ADJUST_UNIT_PERCENT)) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            for (Account acc : listAcc) {
                if (acc.isExternalAsset()) continue;
                this.ccmbAccnt.getItems().add((Object)acc);
            }
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAcc.add(account.getInvestorId());
            }
            String accStr = listAcc.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private boolean rebuildPagi() {
        LinkedList<FundAccount> fundAcc = new LinkedList<FundAccount>();
        LinkedList<CcsSubFundAccount> subFund = new LinkedList<CcsSubFundAccount>();
        if (this.dimension.equals(PRICE_ADJUST_UNIT_PERCENT)) {
            this.fundService.getAllFundAccountList().forEach(item -> {
                if (this.lbAccnt.getText().contains(item.getInvestId()) && "CCS".equals(item.getMarketGrp())) {
                    fundAcc.add((FundAccount)item);
                }
            });
            this.orderModel.setExtList(fundAcc);
            if (fundAcc.isEmpty()) {
                return false;
            }
        } else {
            for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                if (portfolio.getId().isEmpty() || this.subAccMng.getMap(portfolio) == null) continue;
                for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                    if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                    CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                    subFund.add(subFundAccnt);
                }
            }
            this.orderModel.setSubList(subFund);
            if (subFund.isEmpty()) {
                return false;
            }
        }
        return !(PRICE_ADJUST_UNIT_PERCENT.equals(this.dimension) ? this.orderModel.getExtList().isEmpty() : this.orderModel.getSubList().isEmpty());
    }

    protected boolean premise(CcsOrder or) {
        return this.cbxShowAll.isSelected() || or.isCanSelect();
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    protected void createTableView() {
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((CcsOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new PriceCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(cell -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new AvgPriceCell());
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.colBaseId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getBaseId()));
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getOrdStatus()));
        this.colMarket.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().marketProperty());
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserId()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        this.colCancel.setCellValueFactory(data -> this.deleteBasket((TableColumn.CellDataFeatures<CcsOrder, Label>)data));
        this.tableUnOrder.setItems(this.mxList.getList());
        this.tableUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableUnOrder);
        this.colOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableUnOrder.getSortOrder().add(this.colOrdTime);
    }

    private ReadOnlyObjectWrapper<Label> deleteBasket(TableColumn.CellDataFeatures<CcsOrder, Label> basketData) {
        Label delBskBtn = new Label();
        delBskBtn.setText("\u624b\u5de5\u64a4\u5355");
        delBskBtn.setStyle("-fx-cursor:hand;");
        delBskBtn.getStyleClass().add((Object)"text-blue");
        final CcsOrder order = (CcsOrder)CcsOrder.class.cast(basketData.getValue());
        if (!order.isCanSelect()) {
            delBskBtn.setDisable(true);
        }
        delBskBtn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                UnusualOrderPart.this.orderCancelOne(order);
            }
        });
        return new ReadOnlyObjectWrapper((Object)delBskBtn);
    }

    protected void orderCancelOne(CcsOrder order) {
        ObservableList list = FxUtils.newList();
        list.add((Object)order);
        if (list.size() < 1) {
            return;
        }
        if (this.createDialog((List<CcsOrder>)list, "\u64a4\u5355\u786e\u8ba4", false)) {
            return;
        }
        MEvent event = this.orderModel.cancel((List<CcsOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableUnOrder, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableUnOrder, (String)"\u5f02\u5e38\u8ba2\u5355\u5904\u7406", (int)1, (int)(this.tableUnOrder.getColumns().size() - 1));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void refresh() {
        this.dimension = ((MxNode)this.btnDimension.getValue()).getRaw();
        if (!this.rebuildPagi()) {
            return;
        }
        this.orderModel.setDimension(this.dimension);
        this.orderModel.query();
    }

    @FXML
    protected void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        this.ordersCancel((List<CcsOrder>)list, "\u64a4\u5355\u786e\u8ba4", false);
    }

    protected void ordersCancel(List<CcsOrder> list, String dialogName, boolean isDiskless) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, TIP)) {
            return;
        }
        if (this.createDialog(list, dialogName, isDiskless)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.orderModel.cancel(list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private boolean createDialog(List<CcsOrder> list, String dialogName, boolean isDiskless) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setOrderId(or.getOrderId());
            if (!StringUtils.isEmpty((String)or.getReference())) {
                en.setReference(or.getReference());
            }
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setQuantity(or.getOrderQty() - or.getCumQty());
            en.setPrice(or.getPrice());
            if ("XSHG".equals(or.getInstrument().getMarket().getRaw()) && "BOND".equals(or.getInstrument().getSecType())) {
                en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
            } else {
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            en.setPortfolioName(or.getPortfolioName());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        obj.setIsDiskless(isDiskless);
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    private void sort(List<CcsCancelEntrust> enList) {
        Collections.sort(enList, new Comparator<CcsCancelEntrust>(){

            @Override
            public int compare(CcsCancelEntrust o1, CcsCancelEntrust o2) {
                if (o2.isIsModified() && !o1.isIsModified()) {
                    return 1;
                }
                if (o1.isIsModified() && !o2.isIsModified()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public boolean extend(CcsOrder en) {
        return false;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = UnusualOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<CcsOrder, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    CcsOrder ins = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canSelectProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = UnusualOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

