/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.current.models.SgeOrderModel;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class SgeOrderPart
extends MxPagePart<Order, ObSingleOrderNeeq> {
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Boolean> selected;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> side;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> positionEffect;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> errInfo;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> tifName;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> wthQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderAmount;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> totalValue;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> donePercent;
    @Inject
    protected MxAlert alert;
    @Inject
    private SgeOrderModel sgeModel;
    protected CheckBox checkBox = new CheckBox();
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securitySubType;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securityGroup;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> matchType;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> tif;
    @FXML
    protected MenuItem cancelOrd;
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49", "90", "54");

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.selected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.side.setCellFactory(cell -> new SideCell());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.positionEffect.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).positionEffectProperty());
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.wthQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.totalValue.setCellFactory(data -> new DoubleTableCell());
        this.tableView.getColumns().remove(this.tifName);
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    protected void initialize() {
        super.initialize();
        this.sgeModel.setUnfinishedOrder(true);
        this.refresh();
        this.initValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<Order> newList = new ArrayList<Order>();
        List<Order> list = this.getList();
        synchronized (list) {
            newList.addAll(this.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.sort();
            this.mxList.updatePageList();
            this.tableView.refresh();
            if (this.lbCurrentCount != null && this.lbTotalCount != null) {
                this.lbCurrentCount.setText(String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getPageList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    private void initValue() {
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getPageList();
            synchronized (observableList) {
                this.mxList.getPageList().forEach(e -> {
                    if (e.isCanCancel()) {
                        e.setSelected(now.booleanValue());
                    }
                });
            }
        });
        this.tableView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            ObSingleOrderNeeq item = (ObSingleOrderNeeq)this.tableView.getSelectionModel().getSelectedItem();
            if (event == null) {
                return;
            }
            if (event.getButton().name().compareToIgnoreCase("SECONDARY") == 0) {
                if (item.isCanCancel()) {
                    this.cancelOrd.setDisable(false);
                } else {
                    this.cancelOrd.setDisable(true);
                }
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getPageList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }

    @FXML
    protected void refresh() {
        try {
            this.sgeModel.setUnfinishedOrder(false);
            this.sgeModel.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.checkBox.setSelected(false);
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    protected List<Order> getList() {
        return this.sgeModel.getList();
    }

    protected MxModel getModel() {
        return this.sgeModel;
    }

    protected boolean predicate(Order data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getExtOrderId();
        return code.contains(text) || orderId.contains(text) || name.contains(text);
    }

    @FXML
    protected void cancelOrder() {
        ObSingleOrderNeeq item = (ObSingleOrderNeeq)this.tableView.getSelectionModel().getSelectedItem();
        if (!item.isCanCancel()) {
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u5355?")) {
            return;
        }
        try {
            this.sgeModel.cancelOrder(item);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void cancel() {
        ObservableList selectedItem = this.mxList.getPageList();
        int count = 0;
        ArrayList<ObSingleOrderNeeq> accList = new ArrayList<ObSingleOrderNeeq>();
        for (ObSingleOrderNeeq item : selectedItem) {
            if (!item.isSelected()) continue;
            accList.add(item);
        }
        if (accList.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u59d4\u6258");
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5171\u64a4" + accList.size() + "\u7b14\u59d4\u6258")) {
            return;
        }
        for (ObSingleOrderNeeq item : accList) {
            try {
                this.sgeModel.cancelOrder(item);
                ++count;
            }
            catch (MException e) {
                e.printStackTrace();
            }
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6210\u529f\u64a4\u5355" + count + "\u4e2a");
    }

    public class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private int scale = 3;

        public DoubleTableCell() {
        }

        public DoubleTableCell(int scale) {
            this.scale = scale;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(StringUtils.toThousands((String)String.valueOf(item), (int)this.scale));
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<ObSingleOrderNeeq, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        ObSingleOrderNeeq inst = (ObSingleOrderNeeq)ObSingleOrderNeeq.class.cast(this.getTableRow().getItem());
                        if (inst.isCanCancel()) {
                            inst.setSelected(true);
                        }
                    });
                    ObSingleOrderNeeq ins = (ObSingleOrderNeeq)ObSingleOrderNeeq.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canCancelProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

