/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.PledgePositionModel;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class PledgePositionPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(PledgePositionPart.class);
    @FXML
    private TextField searchText;
    @FXML
    private TableView<CcsPosition> tablePosition;
    @FXML
    private TableColumn<CcsPosition, String> colPledgeCode;
    @FXML
    private TableColumn<CcsPosition, String> colPledgeName;
    @FXML
    private TableColumn<CcsPosition, Number> colMultiplier;
    @FXML
    private TableColumn<CcsPosition, String> colStdCode;
    @FXML
    private TableColumn<CcsPosition, String> colSecId;
    @FXML
    private TableColumn<CcsPosition, String> colSecName;
    @FXML
    private TableColumn<CcsPosition, Number> colTotalVol;
    @FXML
    private TableColumn<CcsPosition, Number> colCanVol;
    @FXML
    private TableColumn<CcsPosition, Number> colImpawnIn;
    @FXML
    private TableColumn<CcsPosition, Number> colCanOut;
    @FXML
    private TableColumn<CcsPosition, MxNode> colMarket;
    @FXML
    private TableColumn<CcsPosition, String> colAcc;
    @FXML
    private TableColumn<CcsPosition, String> colSecAcc;
    @FXML
    protected MenuItem miClose;
    @FXML
    protected MenuItem miClear;
    @Inject
    private PledgePositionModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    private MxList<CcsPosition> mxList = new MxList();
    private InvalidationListener lstnRefMng = ob -> Platform.runLater(() -> this.refresh());
    private Predicate<CcsPosition> pd = t -> {
        String txt = this.searchText.getText().trim();
        if (t.getRefItem().getCode().contains(txt)) {
            return true;
        }
        if (t.getRefItem().getName().contains(txt)) {
            return true;
        }
        if (this.premise((Position)t) && t.getSecId().contains(txt)) {
            return true;
        }
        return this.premise((Position)t) && t.getSecName().contains(txt);
    };
    protected InvalidationListener lstnModel = ob -> {
        this.mxList.update(this.model.getList(), this.pd);
        this.tablePosition.sort();
        this.tablePosition.refresh();
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getList(), this.pd);
    @Inject
    private MEventService es;

    @FXML
    public void initialize() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.createTable();
        this.onFocus();
        this.refresh();
        this.refMng.doneProperty().addListener(this.lstnRefMng);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.refMng.doneProperty().removeListener(this.lstnRefMng);
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    private void createTable() {
        int doubleClickCount = 2;
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPosition pos;
            if (event.getClickCount() == doubleClickCount && (pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                String code = pos.getRefItem().getCode();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                RefItem refItem = this.refMng.getItem(pos.getMarket().getRaw(), pos.getSecId());
                if (refItem != null) {
                    eCall.put((Object)"sec_type", (Object)refItem.getType());
                }
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"count", (Object)pos.getCanVol());
                eCall.put((Object)"side_sell", (Object)(pos.getCanVol() >= 0L ? 1 : 0));
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                eCall.put((Object)"count", (Object)pos.getCanVol());
                this.es.sendEvent("trade.panel.set.code.pledge", eCall);
            }
        });
        this.colPledgeCode.setCellValueFactory(data -> ((CcsPosition)data.getValue()).getRefItem().codeProperty());
        this.colPledgeName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).getRefItem().nameProperty());
        this.colMultiplier.setCellValueFactory(data -> ((CcsPosition)data.getValue()).getRefItem().multiplierProperty());
        this.colStdCode.setCellValueFactory(data -> ((CcsPosition)data.getValue()).getRefItem().stdCodeProperty());
        this.colSecId.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolProperty());
        this.colCanVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).canVolProperty());
        this.colImpawnIn.setCellValueFactory(data -> ((CcsPosition)data.getValue()).impawnInProperty());
        this.colCanOut.setCellValueFactory(data -> {
            double availImpawnOut = ((CcsPosition)data.getValue()).getAvailImpawnOut();
            SimpleIntegerProperty ssp = new SimpleIntegerProperty(0);
            double multiplier = this.model.getMultiMap(((CcsPosition)data.getValue()).getMarket().getRaw(), ((CcsPosition)data.getValue()).getSecId());
            if (multiplier == 0.0) {
                ssp.set(0);
                return ssp;
            }
            CcsPosition position = this.model.getCcsPosition(((CcsPosition)data.getValue()).getExtSecAccId(), ((CcsPosition)data.getValue()).getRefItem().getStdCode());
            double canVol = 0.0;
            if (position == null) {
                ssp.set(0);
                return ssp;
            }
            canVol = position.getCanVolDouble();
            PledgeInfo pleInfo = ((CcsPosition)data.getValue()).getRefItem();
            if ("XSHE".equals(position.getMarket().getRaw())) {
                if (pleInfo.getParValue() == 0.0) {
                    ssp.set(0);
                    logger.error(String.valueOf(pleInfo.getCode()) + "|" + pleInfo.getMarket() + "\u9762\u503c\u4e3a0");
                    return ssp;
                }
                double calCount = canVol * 100.0 / (multiplier * pleInfo.getParValue());
                ssp.set(new BigDecimal(calCount < availImpawnOut ? calCount : availImpawnOut).intValue());
            } else if (canVol / multiplier < availImpawnOut) {
                ssp.set(new BigDecimal(canVol / multiplier).intValue());
            } else {
                ssp.set(new BigDecimal(availImpawnOut).intValue());
            }
            return ssp;
        });
        this.colMarket.setCellValueFactory(data -> ((CcsPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).inverstorSecIdProperty());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        this.colSecId.setSortType(TableColumn.SortType.ASCENDING);
        this.tablePosition.getSortOrder().add(this.colSecId);
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u8d28\u62bc\u5238\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public boolean premise(Position posi) {
        return true;
    }
}

