/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxFileChooser;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.OtcOrderDetail;
import cms.tmx.http.workflow.dto.CounterPartyAccount;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.CounterPartyMngService;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.current.views.InstructionOtcFundDialog;
import cms.tmx.query.current.views.InstructionUploadDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.current.views.NewInstructionAuditDialog;
import cms.tmx.query.history.views.InstructionSideCell;
import cms.tmx.query.otc.views.InstructionOtcDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.PdfExportUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class NewInstructionQueryPart
extends MxPart {
    @FXML
    protected TableView<ObInstruction> tableNewInstruction;
    @FXML
    protected TableColumn<ObInstruction, Boolean> colSelected;
    @FXML
    protected TableColumn<ObInstruction, String> colInsId;
    @FXML
    protected TableColumn<ObInstruction, String> colInsType;
    @FXML
    protected TableColumn<ObInstruction, String> colTradePlatform;
    @FXML
    protected TableColumn<ObInstruction, String> colInsStatus;
    @FXML
    protected TableColumn<ObInstruction, Object> colInsOption;
    @FXML
    protected TableColumn<ObInstruction, Object> colInsDetail;
    @FXML
    protected TableColumn<ObInstruction, String> colSide;
    @FXML
    protected TableColumn<ObInstruction, String> colInsInfo;
    @FXML
    protected TableColumn<ObInstruction, String> colPortfolioId;
    @FXML
    protected TableColumn<ObInstruction, String> colPortfolioName;
    @FXML
    protected TableColumn<ObInstruction, String> colSecId;
    @FXML
    protected TableColumn<ObInstruction, String> colSecName;
    @FXML
    protected TableColumn<ObInstruction, String> colTargetSecId;
    @FXML
    protected TableColumn<ObInstruction, String> colTargetSecName;
    @FXML
    protected TableColumn<ObInstruction, String> colTradeDate;
    @FXML
    protected TableColumn<ObInstruction, Number> colSubscribeAmt;
    @FXML
    protected TableColumn<ObInstruction, Number> colRedeemQty;
    @FXML
    protected TableColumn<ObInstruction, Number> colTransferQty;
    @FXML
    protected TableColumn<ObInstruction, String> colRedeemDate;
    @FXML
    protected TableColumn<ObInstruction, String> colBonusType;
    @FXML
    protected TableColumn<ObInstruction, Number> colBonusAmt;
    @FXML
    protected TableColumn<ObInstruction, Number> colBonusQty;
    @FXML
    protected TableColumn<ObInstruction, String> colOperators;
    @FXML
    protected TableColumn<ObInstruction, String> colBeginTime;
    @FXML
    protected TableColumn<ObInstruction, String> colEndTime;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MxAlert alert;
    @FXML
    protected TextField searchText;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbPort;
    @FXML
    private CheckComboBox<String> ccmbSide;
    @FXML
    private Label lbSide;
    @FXML
    private CheckBox cbTodo;
    @FXML
    private Button btnBatchApp;
    @Inject
    protected NewInstructionModel model;
    @Inject
    protected ResourceModel resourceModel;
    @Inject
    protected InstructionExecMng resourceDetailMng;
    @Inject
    protected IUiRightService rightsModel;
    @Inject
    protected IRefDataMng refMng;
    protected CheckBox checkBox = new CheckBox();
    protected static final int DOUBLE_CLICK_COUNT = 2;
    @Inject
    protected ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    private EPartService eps;
    @Inject
    private MxFileChooser fileChooser;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private WorkflowTemplateApi workflowApi;
    @Inject
    private WorkflowTemplateApi workflowTemplateApi;
    @Inject
    private OtcPortfolioAccountModel portfolioModel;
    protected MxList<ObInstruction> mxList = new MxList();
    private boolean portfolioFlag = false;
    private Portfolio portfolio = new Portfolio();
    private List<String> listPortId = FxUtils.newList();
    private List<Portfolio> listPortfolio = new LinkedList<Portfolio>();
    private List<String> listSide = new LinkedList<String>();
    private boolean sideFlag = false;
    private static final String ALL = "\u5168\u9009";
    private String accStr = "";
    protected Predicate<ObInstruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObInstruction)en)) {
            return false;
        }
        if (!this.premisePortfolio((ObInstruction)en)) {
            return false;
        }
        if (!this.premiseSide((ObInstruction)en)) {
            return false;
        }
        if (!en.getId().contains(text) && !en.getSecurityCode().contains(text)) {
            return false;
        }
        if (this.extend((ObInstruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        this.mxList.update(newList, this.pd);
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getId().compareTo(o1.getId()));
        this.tableNewInstruction.refresh();
        this.tableNewInstruction.sort();
    });
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.model.getList().getList(), this.pd);
        }
        this.tableNewInstruction.refresh();
        this.tableNewInstruction.sort();
    });
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (now.booleanValue()) {
                    if (e.isIsApproveStep()) {
                        e.setSelected(now.booleanValue());
                    }
                } else {
                    e.setSelected(now.booleanValue());
                }
            });
        }
    };
    private ChangeListener<Boolean> lstnSide = (obv, old, now) -> {
        if (this.sideFlag) {
            this.sideFlag = false;
            if (!now.booleanValue() && this.ccmbSide.getItemBooleanProperty(0).get()) {
                this.ccmbSide.getItemBooleanProperty(0).set(false);
            }
            if (now.booleanValue() && this.ccmbSide.getItems().size() - this.ccmbSide.getCheckModel().getCheckedItems().size() == 1) {
                this.ccmbSide.getItemBooleanProperty(0).set(true);
            }
            this.lstnSearch.invalidated(null);
            this.sideFlag = true;
        }
    };
    private ChangeListener<Boolean> lstnSideFirst = (obv, old, now) -> {
        if (now == null) {
            return;
        }
        if (this.sideFlag) {
            this.sideFlag = false;
            if (now.booleanValue()) {
                this.ccmbSide.getCheckModel().checkAll();
            } else {
                this.ccmbSide.getCheckModel().clearChecks();
            }
            this.lstnSearch.invalidated(null);
            this.sideFlag = true;
        }
    };
    private InvalidationListener lstnSideAll = ob -> {
        ObservableList listItem = this.ccmbSide.getCheckModel().getCheckedItems();
        this.accStr = listItem.contains(ALL) ? listItem.toString().substring(2 + ALL.length(), listItem.toString().length() - 1) : listItem.toString().substring(1, listItem.toString().length() - 1);
        this.lbSide.setText(this.accStr);
        this.lbSide.setTooltip(new Tooltip(this.lbSide.getText()));
    };
    private InvalidationListener lstnPortAll = ob -> {
        ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
        ObservableList listPortName = FxUtils.newList();
        this.listPortId.clear();
        for (Portfolio port : checkedItems) {
            if (port.getId().isEmpty()) continue;
            listPortName.add(port.getName());
            this.listPortId.add(port.getId());
        }
        String portStr = listPortName.toString();
        this.lbPort.setText(portStr.substring(1, portStr.length() - 1));
        this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
    };
    private ChangeListener<Boolean> lstnPort = (obv, old, now) -> {
        if (this.portfolioFlag) {
            this.portfolioFlag = false;
            if (!now.booleanValue() && this.ccmbPort.getItemBooleanProperty(0).get()) {
                this.ccmbPort.getItemBooleanProperty(0).set(false);
            }
            if (now.booleanValue() && this.ccmbPort.getItems().size() - this.ccmbPort.getCheckModel().getCheckedItems().size() == 1) {
                this.ccmbPort.getItemBooleanProperty(0).set(true);
            }
            this.lstnSearch.invalidated(null);
            this.portfolioFlag = true;
        }
    };
    private ChangeListener<Boolean> lstnPortFirst = (obv, old, now) -> {
        if (now == null) {
            return;
        }
        if (this.portfolioFlag) {
            this.portfolioFlag = false;
            if (now.booleanValue()) {
                this.ccmbPort.getCheckModel().checkAll();
            } else {
                this.ccmbPort.getCheckModel().clearChecks();
            }
            this.lstnSearch.invalidated(null);
            this.portfolioFlag = true;
        }
    };
    @Inject
    private CounterPartyMngService cpService;
    @Inject
    private LoadPartModel load;

    public boolean premise(ObInstruction order) {
        if (this.cbTodo.isSelected()) {
            return order.isTodo();
        }
        return true;
    }

    private boolean premisePortfolio(ObInstruction e) {
        ObservableList listAccnt = this.ccmbPort.getCheckModel().getCheckedItems();
        if (listAccnt.contains(this.portfolio)) {
            return true;
        }
        return this.listPortId.contains(e.getPortfolioId());
    }

    private boolean premiseSide(ObInstruction e) {
        ObservableList listSide = this.ccmbSide.getCheckModel().getCheckedItems();
        if (listSide.contains(ALL)) {
            return true;
        }
        return listSide.contains(e.getSideName());
    }

    public boolean extend(ObInstruction order) {
        return false;
    }

    @Focus
    public void onFocus() {
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.getLstnModel());
        this.searchText.textProperty().removeListener(this.getLstnSearch());
        int i = 1;
        while (i < this.listSide.size()) {
            this.ccmbSide.getItemBooleanProperty(i).removeListener(this.lstnSide);
            ++i;
        }
        this.ccmbSide.getItemBooleanProperty(0).removeListener(this.lstnSideFirst);
        this.ccmbSide.getCheckModel().getCheckedItems().removeListener(this.lstnSideAll);
        i = 1;
        while (i < this.listPortfolio.size()) {
            this.ccmbPort.getItemBooleanProperty(i).removeListener(this.lstnPort);
            ++i;
        }
        this.ccmbPort.getItemBooleanProperty(0).removeListener(this.lstnPortFirst);
        this.ccmbPort.getCheckModel().getCheckedItems().removeListener(this.lstnPortAll);
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
        this.cbTodo.setSelected(true);
        this.cbTodo.selectedProperty().addListener(this.getLstnSearch());
        this.btnBatchApp.setOnMouseClicked(event -> this.batchApprove());
        this.initPortfolio();
        this.initSide();
        this.lstnSearch.invalidated(null);
    }

    private void initPortfolio() {
        this.portfolio.setId("");
        this.portfolio.setName(ALL);
        this.listPortfolio.add(this.portfolio);
        ArrayList<Portfolio> portfolioList = new ArrayList<Portfolio>(this.portfolioModel.getPortfolios());
        portfolioList.forEach(item -> {
            if (this.portfolioModel.getMap((Portfolio)item) != null && !this.portfolioModel.getMap((Portfolio)item).isEmpty()) {
                this.listPortfolio.add((Portfolio)item);
            }
        });
        this.ccmbPort.getItems().addAll(this.listPortfolio);
        this.ccmbPort.getCheckModel().checkAll();
        int i = 1;
        while (i < this.listPortfolio.size()) {
            this.ccmbPort.getItemBooleanProperty(i).addListener(this.lstnPort);
            ++i;
        }
        this.ccmbPort.getItemBooleanProperty(0).addListener(this.lstnPortFirst);
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(this.lstnPortAll);
        this.ccmbPort.getCheckModel().checkAll();
        this.portfolioFlag = true;
    }

    private void initSide() {
        this.listSide.add(ALL);
        Map map = MxDict.NEW_INSTRUCTION_SIDE_MAP;
        for (String str : map.values()) {
            if ("\u8f6c\u5165".equals(str) || "\u8f6c\u51fa".equals(str)) continue;
            this.listSide.add(str);
        }
        this.ccmbSide.getItems().addAll(this.listSide);
        this.ccmbSide.getCheckModel().checkAll();
        int i = 1;
        while (i < this.listSide.size()) {
            this.ccmbSide.getItemBooleanProperty(i).addListener(this.lstnSide);
            ++i;
        }
        this.ccmbSide.getItemBooleanProperty(0).addListener(this.lstnSideFirst);
        this.ccmbSide.getCheckModel().getCheckedItems().addListener(this.lstnSideAll);
        this.ccmbSide.getCheckModel().checkAll();
        this.sideFlag = true;
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableNewInstruction);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableNewInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createTable() {
        this.colSelected.setGraphic((javafx.scene.Node)this.checkBox);
        this.colSelected.setCellValueFactory(data -> ((ObInstruction)data.getValue()).selectedProperty());
        this.colSelected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colInsId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).idProperty());
        this.colInsType.setCellValueFactory(data -> ((ObInstruction)data.getValue()).typeNameProperty());
        this.colTradePlatform.setCellValueFactory(data -> ((ObInstruction)data.getValue()).tradePlatformProperty());
        this.colInsStatus.setCellValueFactory(data -> ((ObInstruction)data.getValue()).statusNameProperty());
        this.colSide.setCellValueFactory(data -> ((ObInstruction)data.getValue()).sideNameProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colPortfolioId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).portfolioIdProperty());
        this.colPortfolioName.setCellValueFactory(data -> ((ObInstruction)data.getValue()).portfolioNameProperty());
        this.colSecId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).securityCodeProperty());
        this.colSecName.setCellValueFactory(data -> ((ObInstruction)data.getValue()).securityNameProperty());
        this.colTargetSecId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).underlyingSecurityCodeProperty());
        this.colTargetSecName.setCellValueFactory(data -> ((ObInstruction)data.getValue()).underlyingSecurityNameProperty());
        this.colTradeDate.setCellValueFactory(data -> ((ObInstruction)data.getValue()).tradeDateProperty());
        this.colSubscribeAmt.setCellValueFactory(data -> ((ObInstruction)data.getValue()).subscribeAmtProperty());
        this.colSubscribeAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colRedeemQty.setCellValueFactory(data -> ((ObInstruction)data.getValue()).redeemQtyProperty());
        this.colRedeemQty.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colTransferQty.setCellValueFactory(data -> ((ObInstruction)data.getValue()).transFerQtyProperty());
        this.colTransferQty.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colRedeemDate.setCellValueFactory(data -> ((ObInstruction)data.getValue()).redeemDateProperty());
        this.colBonusType.setCellValueFactory(data -> ((ObInstruction)data.getValue()).bonusTypeNameProperty());
        this.colBonusAmt.setCellValueFactory(data -> ((ObInstruction)data.getValue()).bonusAmtProperty());
        this.colBonusAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colBonusQty.setCellValueFactory(data -> ((ObInstruction)data.getValue()).bonusQtyProperty());
        this.colBonusQty.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colOperators.setCellValueFactory(data -> ((ObInstruction)data.getValue()).operatorsProperty());
        this.colBeginTime.setCellValueFactory(data -> ((ObInstruction)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((ObInstruction)data.getValue()).endTimeProperty());
        this.colInsOption.setCellValueFactory(data -> this.setOperate((ObInstruction)data.getValue()));
        this.colInsDetail.setCellValueFactory(data -> this.setDetail((ObInstruction)data.getValue()));
        this.colInsInfo.setCellValueFactory(data -> ((ObInstruction)data.getValue()).errInfoProperty());
        this.colInsInfo.setCellFactory(data -> new TooltipTableCell<ObInstruction, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObInstruction)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.tableNewInstruction.setItems(this.mxList.getList());
        this.tableNewInstruction.setPlaceholder((javafx.scene.Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableNewInstruction);
        this.tableDoubleClickHandler();
    }

    protected void tableDoubleClickHandler() {
        this.tableNewInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                ObInstruction instruction = (ObInstruction)this.tableNewInstruction.getSelectionModel().getSelectedItem();
                this.sendEvent(instruction);
            }
        });
    }

    private void batchApprove() {
        List appInsList = this.mxList.getList().stream().filter(item -> item.isSelected() && item.isIsApproveStep()).collect(Collectors.toList());
        if (appInsList.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u672a\u9009\u4e2d\u53ef\u5ba1\u6279\u7684\u6307\u4ee4");
            return;
        }
        StringBuilder ids = new StringBuilder("");
        int i = 0;
        while (i < appInsList.size()) {
            ObInstruction obIns = (ObInstruction)appInsList.get(i);
            if (i == appInsList.size() - 1) {
                ids.append(obIns.getId());
            } else {
                ids.append(obIns.getId()).append(",");
            }
            ++i;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u5bf9\u6307\u4ee4" + ids.toString() + "\u8fdb\u884c\u6279\u91cf\u5ba1\u6279")) {
            return;
        }
        for (ObInstruction obInstruction : appInsList) {
            List workflowTasks = obInstruction.getWorkflowTasks();
            String operation = "";
            WorkflowTask task = null;
            for (WorkflowTask workflowTask : workflowTasks) {
                if (workflowTask.getPermissibleList().contains("2")) {
                    task = workflowTask;
                    operation = "2";
                }
                if (!workflowTask.getPermissibleList().contains("6")) continue;
                task = workflowTask;
                operation = "6";
            }
            if (task == null) {
                this.logger.error("\u6307\u4ee4\u5ba1\u6279\u5931\u8d25\uff0c\u672a\u53d6\u5230\u5ba1\u6279\u4efb\u52a1" + obInstruction.getId());
                continue;
            }
            try {
                this.model.audit(obInstruction, operation, task, (List<WorkflowAttachment>)obInstruction.getAttachments());
            }
            catch (MException | Exception e) {
                this.logger.error("\u6307\u4ee4\u5ba1\u6279\u5931\u8d25:" + obInstruction.getId() + e.getMessage());
            }
        }
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colTargetSecId.setVisible(true);
        this.colTargetSecName.setVisible(true);
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableNewInstruction.getSortOrder().add(this.colInsId);
        this.tableNewInstruction.sort();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ReadOnlyObjectWrapper<Object> setOperate(ObInstruction instruction) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        if (instruction.isCanCancel() && instruction.isCanCancelOrder()) {
            Button btn = new Button("\u64a4\u9500");
            btn.setMinWidth(100.0);
            btn.setOnAction(event -> this.cancel(instruction));
            btn.getStyleClass().add((Object)"btnOperation");
            box.getChildren().add((Object)btn);
        }
        if ("SIDE_CREATION".equals(instruction.getSide()) || "SIDE_REDEEM".equals(instruction.getSide()) || "SIDE_SUBSCRIBE".equals(instruction.getSide())) {
            Button btnExport = new Button("\u5bfc\u51fa\u6307\u4ee4");
            btnExport.setMinWidth(100.0);
            btnExport.getStyleClass().add((Object)"btnOperation");
            btnExport.setOnAction(event -> this.exportInstruction(instruction));
            box.getChildren().add((Object)btnExport);
        }
        if ("FundDetail".equals(instruction.getType()) && ("55555-04-01".equals(instruction.getCounterId()) || "99999-04-01".equals(instruction.getCounterId()))) {
            Button btnOrder = new Button("\u91cd\u4e0b");
            btnOrder.setMinWidth(100.0);
            btnOrder.getStyleClass().add((Object)"btnOperation");
            btnOrder.setOnAction(event -> this.reOrder(instruction));
            box.getChildren().add((Object)btnOrder);
        }
        if (instruction.getWorkflowTasks() != null) {
            for (WorkflowTask task : instruction.getWorkflowTasks()) {
                String[] stringArray = task.getPermissibleList().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block33: {
                        String action = stringArray[n2];
                        String actionName = WorkflowOptEnum.getById((String)action).actionName;
                        if (!StringUtils.isEmpty((String)actionName)) {
                            Button btn = new Button(actionName);
                            btn.setMinWidth(100.0);
                            btn.getStyleClass().add((Object)"btnOperation");
                            switch (action) {
                                case "0": {
                                    btn.setOnAction(event -> this.upLoadOa(instruction, action, task));
                                    break;
                                }
                                case "1": {
                                    btn.setOnAction(event -> this.upLoadAttechment(instruction, action, task));
                                    break;
                                }
                                case "2": {
                                    btn.setOnAction(event -> this.audit(instruction, action, task));
                                    break;
                                }
                                case "3": {
                                    btn.setOnAction(event -> this.reject(instruction, action, task));
                                    break;
                                }
                                case "4": {
                                    btn.setOnAction(event -> this.confirm(instruction, action, task));
                                    break;
                                }
                                case "5": 
                                case "8": {
                                    if (!"kStatusApproved".equals(instruction.getStatus()) && !"kStatusExecuting".equals(instruction.getStatus())) {
                                        btn = null;
                                        break block33;
                                    } else {
                                        if (instruction.getJobs() == null || instruction.getJobs().isEmpty()) break;
                                        double availOrderQty = ((ExecJob)instruction.getJobs().get(0)).getAvailOrderQty();
                                        double targetQty = ((ExecJob)instruction.getJobs().get(0)).getTargetQty();
                                        double cumQty = ((ExecJob)instruction.getJobs().get(0)).getCumQty();
                                        if (availOrderQty > 0.0) {
                                            btn.setText("\u6267\u884c");
                                            btn.setOnAction(event -> this.executeOrder(instruction));
                                        }
                                        if (!(availOrderQty < targetQty) || !(cumQty < targetQty) || !instruction.isCanCancelOrder()) break;
                                        btn.setText("\u4ea4\u6613\u64a4\u5355");
                                        btn.setOnAction(event -> this.orderCancel(instruction));
                                        break;
                                    }
                                }
                                case "6": {
                                    btn.setOnAction(event -> this.audit(instruction, action, task));
                                    break;
                                }
                                case "7": 
                                case "9": {
                                    btn.setOnAction(event -> this.reject(instruction, action, task));
                                }
                            }
                            if (btn != null) {
                                box.getChildren().add((Object)btn);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void exportInstruction(ObInstruction instruction) {
        String fileName = String.valueOf(instruction.getId()) + ".pdf";
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("pdf files (*.pdf)", new String[]{".pdf"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName(fileName);
        File file = chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        InputStream templateStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("template/OtcInstructionReport.pdf");
        if (templateStream == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u672a\u627e\u5230\u6307\u4ee4\u6a21\u677f\u6587\u4ef6");
            return;
        }
        Map<String, String> dataMap = this.buildDataMap(instruction);
        PdfExportUtils.exportPdf((InputStream)templateStream, (String)file.getPath(), dataMap);
    }

    private Map<String, String> buildDataMap(ObInstruction instruction) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("side", instruction.getSideName());
        dataMap.put("leader", instruction.getOperators());
        dataMap.put("secId", instruction.getSecurityCode());
        dataMap.put("secName", instruction.getSecurityName());
        dataMap.put("price", StringUtils.toThousands((Number)instruction.getOtcOrderDetail().getPrice(), (int)4));
        if ("SIDE_REDEEM".equals(instruction.getSide())) {
            dataMap.put("valueType", "\u6570\u91cf\uff08\u4efd\uff09");
            dataMap.put("amountOrQty", StringUtils.toThousands((Number)instruction.getOtcOrderDetail().getOrderQty(), (int)2));
        } else {
            dataMap.put("valueType", "\u91d1\u989d\uff08\u5143\uff09");
            dataMap.put("amountOrQty", StringUtils.toThousands((Number)instruction.getOtcOrderDetail().getOrderAmount(), (int)2));
        }
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        dataMap.put("date", sdf2.format(new Date()));
        return dataMap;
    }

    private void orderCancel(ObInstruction instruction) {
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500\u59d4\u6258\uff1f")) {
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)instruction);
        this.es.sendEvent("cancel.order.by.instruction", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(false, type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    private void executeOrder(ObInstruction instruction) {
        NewInstructionReq newInsReq = new NewInstructionReq();
        Instruction ins = new Instruction();
        ins.setPortfolioName(instruction.getPortfolioName());
        newInsReq.setInstruction(ins);
        ins.setDetail((Object)instruction.getOtcOrderDetail());
        InstructionOtcFundDialog obj = (InstructionOtcFundDialog)((Object)this.of.create(InstructionOtcFundDialog.class));
        OtcOrderDetail detail = (OtcOrderDetail)newInsReq.getInstruction().getDetail();
        if (instruction.getOtcOrderDetail().getParty() != null) {
            List counterBanks = this.cpService.getCounterBanks();
            for (CounterPartyAccount counterPartyAccount : counterBanks) {
                if (!counterPartyAccount.getCounterParty().getId().equals(instruction.getOtcOrderDetail().getParty().getPartyId())) continue;
                detail.setCounterPartyName(counterPartyAccount.getCounterParty().getName());
            }
        }
        obj.setDialog(newInsReq);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        try {
            this.model.execInsTask(instruction);
            TaskLog log = new TaskLog();
            List workflowTasks = instruction.getWorkflowTasks();
            Iterator iterator = workflowTasks.iterator();
            if (iterator.hasNext()) {
                WorkflowTask workflowTask = (WorkflowTask)iterator.next();
                Node node = workflowTask.getNode();
                if (node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_EXECUTE.actionId)) {
                    log.setNodeId(node.getNodeId());
                    log.setNodeName(node.getNodeName());
                    log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_EXECUTE.actionId);
                } else if (node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) {
                    log.setNodeId(node.getNodeId());
                    log.setNodeName(node.getNodeName());
                    log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId);
                } else {
                    return;
                }
            }
            log.setWorkflowId(instruction.getEntryId());
            log.setOpUser(this.baseApi.getUserId());
            this.workflowApi.recordTaskLog(log);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6267\u884c\u5931\u8d25" + (Object)((Object)e));
            return;
        }
        this.logger.info("\u6307\u4ee4\u6267\u884c\u6210\u529f,id:" + instruction.getId());
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u6267\u884c\u6210\u529f");
    }

    private void cancel(ObInstruction instruction) {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500")) {
            try {
                this.model.cancel(instruction);
            }
            catch (MException e) {
                this.logger.error("\u6307\u4ee4\u64a4\u9500\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25 " + e.getMessage());
                return;
            }
            this.logger.info("\u6307\u4ee4\u64a4\u9500\u6210\u529f,id:" + instruction.getId());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u64a4\u9500\u6210\u529f");
        }
    }

    private void confirm(ObInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        this.sendEvent(instruction);
    }

    private void reject(ObInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5ba1\u6279\u62d2\u7edd\u8be5\u6307\u4ee4")) {
            return;
        }
        try {
            this.model.reject(instruction, action, task, null);
        }
        catch (MException e) {
            this.logger.error("\u6307\u4ee4\u5ba1\u6279\u62d2\u7edd\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u5ba1\u6279\u62d2\u7edd\u5931\u8d25 " + e.getMessage());
            return;
        }
        this.logger.info("\u6307\u4ee4\u5ba1\u6279\u62d2\u7edd\u6210\u529f,id:" + instruction.getId());
        this.alert.alert(Alert.AlertType.INFORMATION, "\u5ba1\u6279\u62d2\u7edd\u6210\u529f");
    }

    private void audit(ObInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        MEvent eCall = new MEvent();
        MPart newPart = null;
        if ("FundDetail".equals(instruction.getType())) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.otc.approve");
            if (newPart == null) {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
            eCall.put((Object)"instruction", (Object)instruction);
            this.es.sendEvent("instruction.set.on.panel", eCall);
            return;
        }
        NewInstructionAuditDialog obj = (NewInstructionAuditDialog)((Object)this.of.create(NewInstructionAuditDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u5ba1\u6279");
        dialog.getButton(ButtonType.OK).setVisible(false);
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        obj.setOk(dialog.getButton(ButtonType.OK));
        obj.setCancel(dialog.getButton(ButtonType.CANCEL));
        obj.setInstruction(instruction);
        ButtonType bt = dialog.launch();
        if (bt.equals(ButtonType.OK)) {
            try {
                this.model.audit(instruction, action, task, (List<WorkflowAttachment>)instruction.getAttachments());
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u5ba1\u6279\u5931\u8d25" + e.getMessage());
                return;
            }
        } else {
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u5ba1\u6279\u6210\u529f");
        this.logger.info("\u6307\u4ee4\u5ba1\u6279\u6210\u529f,id:" + instruction.getId());
    }

    private void reOrder(ObInstruction instruction) {
        this.selectRow(instruction);
        MEvent eCall = new MEvent();
        MPart newPart = null;
        if ("FundDetail".equals(instruction.getType())) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.otc.place");
            if (newPart == null) {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
            eCall.put((Object)"instruction", (Object)instruction);
            eCall.put((Object)"otcPartTypeInstruction", (Object)"otcPartTypeInstruction");
            this.es.sendEvent("instruction.set.on.panel", eCall);
            return;
        }
    }

    private void upLoadAttechment(ObInstruction instruction, String action, WorkflowTask task) {
        HashSet<WorkflowAttachment> attachments = new HashSet<WorkflowAttachment>();
        InstructionUploadDialog obj = (InstructionUploadDialog)((Object)this.of.create(InstructionUploadDialog.class));
        obj.setInstruction(instruction);
        obj.setUploadType("contract");
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0a\u4f20\u9644\u4ef6" + instruction.getId());
        if (!ButtonType.OK.equals(dialog.launch())) {
            return;
        }
        attachments.addAll((Collection<WorkflowAttachment>)obj.getAttachmentList());
        ArrayList<WorkflowAttachment> newAttachments = new ArrayList<WorkflowAttachment>(attachments);
        instruction.setAttachments(newAttachments);
        try {
            this.model.complateTask(instruction.getId(), instruction.getEntryId(), action, task, newAttachments);
        }
        catch (MException e) {
            this.logger.error("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u4e0a\u4f20\u9644\u4ef6\u6210\u529f,id:" + instruction.getId());
    }

    private void upLoadOa(ObInstruction instruction, String action, WorkflowTask task) {
        HashSet<WorkflowAttachment> attachments = new HashSet<WorkflowAttachment>();
        InstructionUploadDialog obj = (InstructionUploadDialog)((Object)this.of.create(InstructionUploadDialog.class));
        obj.setInstruction(instruction);
        obj.setUploadType("oa");
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0a\u4f20OA" + instruction.getId());
        if (!ButtonType.OK.equals(dialog.launch())) {
            return;
        }
        attachments.addAll((Collection<WorkflowAttachment>)obj.getAttachmentList());
        ArrayList<WorkflowAttachment> newAttachments = new ArrayList<WorkflowAttachment>(attachments);
        instruction.setAttachments(newAttachments);
        try {
            this.model.complateTask(instruction.getId(), instruction.getEntryId(), action, task, newAttachments);
        }
        catch (MException e) {
            this.logger.error("\u4e0a\u4f20oa\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u4e0a\u4f20oa\u6210\u529f,id:" + instruction.getId());
    }

    private WorkflowAttachment chooserFile(String type) {
        WorkflowAttachment attachment = null;
        File file = this.fileChooser.get();
        if (file == null) {
            return null;
        }
        if (file.length() > 65535000L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u8d85\u8fc7\u5927\u5c0f\u9650\u5236\uff1a64M");
            return null;
        }
        try {
            attachment = this.workflowTemplateApi.uploadAttachment(file);
            attachment.setType(type);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25," + e.getMessage());
            return null;
        }
        return attachment;
    }

    protected void sendEvent(ObInstruction instruction) {
        if (instruction == null) {
            return;
        }
        if (instruction.getWorkflowTasks() != null) {
            for (WorkflowTask task : instruction.getWorkflowTasks()) {
                String[] stringArray = task.getPermissibleList().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double availOrderQty;
                    String action = stringArray[n2];
                    if (("8".equals(action) || "5".equals(action)) && ("kStatusApproved".equals(instruction.getStatus()) || "kStatusExecuting".equals(instruction.getStatus())) && instruction.getJobs() != null && !instruction.getJobs().isEmpty() && (availOrderQty = ((ExecJob)instruction.getJobs().get(0)).getAvailOrderQty()) > 0.0) {
                        this.executeOrder(instruction);
                        return;
                    }
                    ++n2;
                }
            }
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001");
            return;
        }
        MEvent eCall = new MEvent();
        if ("FundDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.otc.confirm");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.otc.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    protected void selectRow(ObInstruction instruction) {
        this.tableNewInstruction.getSelectionModel().select((Object)instruction);
    }

    protected ReadOnlyObjectWrapper<Object> setDetail(ObInstruction instruction) {
        HBox box = new HBox(){

            public String toString() {
                return "\u8be6\u60c5";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button detail = new Button("\u8be6\u60c5");
        detail.getStyleClass().add((Object)"btnOperation");
        detail.setOnAction(event -> this.showDetail(instruction));
        box.getChildren().addAll((Object[])new javafx.scene.Node[]{detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    protected void showDetail(ObInstruction instruction) {
        this.selectRow(instruction);
        InstructionOtcDialog obj = (InstructionOtcDialog)((Object)this.of.create(InstructionOtcDialog.class));
        obj.setObInstruction(instruction);
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    public void setLstnCheckbox(ChangeListener<? super Boolean> lstnCheckbox) {
        this.lstnCheckbox = lstnCheckbox;
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<ObInstruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    ObInstruction cfr_ignored_0 = (ObInstruction)ObInstruction.class.cast(this.getTableRow().getItem());
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        ObInstruction inst = (ObInstruction)ObInstruction.class.cast(this.getTableRow().getItem());
                        inst.setApprManualSelected(true);
                    });
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

