/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.query.current.models.NewInstructionModel;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class NewInstructionAuditDialog
extends DialogObj {
    @FXML
    private Button passBtn;
    @FXML
    private Button detailBtn;
    @FXML
    private Button cancelBtn;
    @Inject
    private EPartService eps;
    @Inject
    private MEventService es;
    private ObInstruction instruction;
    @Inject
    protected NewInstructionModel model;
    private Button ok;
    private Button cancel;

    @FXML
    public void initialize() {
        this.initialValues();
    }

    protected boolean isOK(ButtonType bt) {
        return true;
    }

    private void initialValues() {
        this.passBtn.setOnAction(e -> this.pass());
        this.detailBtn.setOnAction(e -> this.detail());
        this.cancelBtn.setOnAction(e -> this.cancel());
        Platform.runLater(() -> this.passBtn.requestFocus());
    }

    private void cancel() {
        this.cancel.fire();
    }

    private void detail() {
        this.sendEvent(this.instruction);
        this.cancel.fire();
    }

    private void pass() {
        this.ok.fire();
    }

    private void sendEvent(ObInstruction instruction) {
        if (instruction.isFinished()) {
            return;
        }
        MEvent eCall = new MEvent();
        if ("FundDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.otc.confirm");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.otc.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    public Button getOk() {
        return this.ok;
    }

    public void setOk(Button ok) {
        this.ok = ok;
    }

    public Button getCancel() {
        return this.cancel;
    }

    public void setCancel(Button cancel) {
        this.cancel = cancel;
    }

    public void setInstruction(ObInstruction instruction) {
        this.instruction = instruction;
    }
}

