/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.NeeqInstructionModel;
import cms.tmx.query.current.views.InstructionNeeqDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.history.views.InstructionSideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class NeeqInstructionQueryPart
extends MxPart {
    @FXML
    protected TableView<ObSimpleInstruction> tableNewInstruction;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colInsId;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colBelongTo;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colInsType;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colSecId;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colSecName;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colLevelInfo;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colQty;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colInsPrice;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colSide;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colOrderAmount;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colCumAmount;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colCumQty;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colInsProgress;
    @FXML
    protected TableColumn<ObSimpleInstruction, Number> colAvgPx;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colInsStatus;
    @FXML
    protected TableColumn<ObSimpleInstruction, Object> colInsOption;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colInsInfo;
    @FXML
    protected TableColumn<ObSimpleInstruction, Object> colInsDetail;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colBeginTime;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colEndTime;
    @FXML
    protected TableColumn<ObSimpleInstruction, MxNode> colMarket;
    @FXML
    protected TableColumn<ObSimpleInstruction, String> colSecuritySubType;
    @FXML
    protected TableColumn<ObSimpleInstruction, MxNode> colTif;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MxAlert alert;
    @FXML
    protected TextField searchText;
    @Inject
    protected NeeqInstructionModel model;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected ExecutorService exe;
    @Inject
    protected MEventService es;
    @Inject
    protected EPartService eps;
    protected CheckBox checkBox = new CheckBox();
    protected static final int DOUBLE_CLICK_COUNT = 2;
    protected MxList<ObSimpleInstruction> mxList = new MxList();
    protected Predicate<ObSimpleInstruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSimpleInstruction)en)) {
            return false;
        }
        if (!en.getId().contains(text) && !en.getSecurityCode().contains(text)) {
            return false;
        }
        if (this.extend((ObSimpleInstruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.getModel().getList().getList();
        synchronized (observableList) {
            newList.addAll(this.getModel().getList().getList());
        }
        this.mxList.update(newList, this.pd);
        this.handleCheckBox();
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getId().compareTo(o1.getId()));
        this.tableNewInstruction.refresh();
        this.tableNewInstruction.sort();
    });
    protected InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.getModel().getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.getModel().getList().getList(), this.pd);
        }
        this.tableNewInstruction.refresh();
        this.tableNewInstruction.sort();
    });
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isIsApproveStep()) {
                    e.setSelected(now.booleanValue());
                }
            });
        }
    };
    @Inject
    private LoadPartModel load;

    public boolean premise(ObSimpleInstruction order) {
        return order.getMarketIndicate().isEmpty();
    }

    public boolean extend(ObSimpleInstruction order) {
        return false;
    }

    protected void handleCheckBox() {
        boolean hasSelectedItem = false;
        boolean hasCanHotApprove = false;
        for (ObSimpleInstruction instruction : this.mxList.getList()) {
            if (instruction.isSelected()) {
                hasSelectedItem = true;
            }
            if (!instruction.isIsApproveStep()) continue;
            hasCanHotApprove = true;
        }
        if (hasSelectedItem) {
            this.checkBox.setSelected(true);
            this.checkBox.setDisable(false);
        } else if (hasCanHotApprove) {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(false);
        } else {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(true);
        }
    }

    @Focus
    public void onFocus() {
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    @PreDestroy
    private void close() {
        this.getModel().changedProperty().removeListener(this.getLstnModel());
        this.searchText.textProperty().removeListener(this.getLstnSearch());
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
        this.lstnSearch.invalidated(null);
    }

    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableNewInstruction);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableNewInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createTable() {
        this.colInsId.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).idProperty());
        this.colLevelInfo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).levelInfoProperty());
        this.colInsType.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).typeNameProperty());
        this.colInsStatus.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).statusNameProperty());
        this.colSide.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).sideNameProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colSecId.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securityCodeProperty());
        this.colSecName.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securityNameProperty());
        this.colBeginTime.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).endTimeProperty());
        this.colInsOption.setCellValueFactory(data -> this.setOperate((ObSimpleInstruction)data.getValue()));
        this.colInsDetail.setCellValueFactory(data -> this.setDetail((ObSimpleInstruction)data.getValue()));
        this.colInsInfo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).errInfoProperty());
        this.colInsInfo.setCellFactory(data -> new TooltipTableCell<ObSimpleInstruction, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSimpleInstruction)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colBelongTo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<ObSimpleInstruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : (String)((ObSimpleInstruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colInsProgress.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colQty.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colInsPrice.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).insPriceStrProperty());
        this.colOrderAmount.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colCumAmount.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).cumAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colSecuritySubType.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securitySubTypeProperty());
        this.colMarket.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).marketProperty());
        this.tableNewInstruction.setItems(this.mxList.getList());
        this.colCumQty.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(cell -> new NumberTableCell());
        this.tableNewInstruction.getColumns().remove(this.colCumQty);
        this.tableNewInstruction.getColumns().remove(this.colTif);
        this.tableNewInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableNewInstruction);
        this.tableDoubleClickHandler();
    }

    protected void tableDoubleClickHandler() {
        this.tableNewInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                ObSimpleInstruction instruction = (ObSimpleInstruction)this.tableNewInstruction.getSelectionModel().getSelectedItem();
                this.sendEvent(instruction);
            }
        });
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableNewInstruction.getSortOrder().add(this.colInsId);
        this.tableNewInstruction.sort();
    }

    /*
     * Unable to fully structure code
     */
    protected ReadOnlyObjectWrapper<Object> setOperate(ObSimpleInstruction instruction) {
        block32: {
            opStr = new String[]{""};
            box = new HBox(){

                public String toString() {
                    return opStr[0];
                }
            };
            if (instruction.getId().contains("08")) {
                System.err.println();
            }
            box.setSpacing(10.0);
            box.setAlignment(Pos.CENTER);
            if (instruction.isCanCancel()) {
                btn = new Button("\u64a4\u9500");
                btn.setMinWidth(100.0);
                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$36(cms.tmx.entity.trade.instruction.ObSimpleInstruction javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction));
                opStr[0] = String.valueOf(opStr[0]) + "\u64a4\u9500  ";
                btn.getStyleClass().add((Object)"btnOperation");
                box.getChildren().add((Object)btn);
            }
            if (instruction.getWorkflowTasks() == null) break block32;
            for (WorkflowTask task : instruction.getWorkflowTasks()) {
                var9_9 = task.getPermissibleList().split(",");
                var8_8 = var9_9.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    block33: {
                        action = var9_9[var7_7];
                        actionName = WorkflowOptEnum.getById((String)action).actionName;
                        if (StringUtils.isEmpty((String)actionName)) break block33;
                        btn = new Button(actionName);
                        btn.setMinWidth(100.0);
                        btn.getStyleClass().add((Object)"btnOperation");
                        opStr[0] = String.valueOf(opStr[0]) + actionName + "  ";
                        var12_12 = action;
                        tmp = -1;
                        switch (var12_12.hashCode()) {
                            case 50: {
                                if (var12_12.equals("2")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 53: {
                                if (var12_12.equals("5")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 54: {
                                if (var12_12.equals("6")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 55: {
                                if (var12_12.equals("7")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 56: {
                                if (var12_12.equals("8")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 57: {
                                if (var12_12.equals("9")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 1567: {
                                if (var12_12.equals("10")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case 1568: {
                                if (var12_12.equals("11")) {
                                    tmp = 6;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$37(cms.tmx.entity.trade.instruction.ObSimpleInstruction javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction));
                                ** GOTO lbl98
                            }
                            case 3: {
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$38(cms.tmx.entity.trade.instruction.ObSimpleInstruction java.lang.String cms.tmx.entity.web.workflow.WorkflowTask javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction, (String)action, (WorkflowTask)task));
                                ** GOTO lbl98
                            }
                            case 4: {
                                if (!"kStatusApproved".equals(instruction.getStatus()) && !"kStatusExecuting".equals(instruction.getStatus())) {
                                    btn = null;
                                    break;
                                }
                                if (instruction.getJobs() != null && !instruction.getJobs().isEmpty() && (availOrderQty = ((ExecJob)instruction.getJobs().get(0)).getAvailOrderQty()) == 0.0) {
                                    btn = null;
                                    break;
                                }
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$39(cms.tmx.entity.trade.instruction.ObSimpleInstruction javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction));
                            }
                            case 2: {
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$40(cms.tmx.entity.trade.instruction.ObSimpleInstruction javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction));
                                ** GOTO lbl98
                            }
                            case 5: {
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$41(cms.tmx.entity.trade.instruction.ObSimpleInstruction java.lang.String cms.tmx.entity.web.workflow.WorkflowTask javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction, (String)action, (WorkflowTask)task));
                                ** GOTO lbl98
                            }
                            case 6: {
                                btn.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$42(cms.tmx.entity.trade.instruction.ObSimpleInstruction java.lang.String cms.tmx.entity.web.workflow.WorkflowTask javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((NeeqInstructionQueryPart)this, (ObSimpleInstruction)instruction, (String)action, (WorkflowTask)task));
                            }
lbl98:
                            // 6 sources

                            default: {
                                if (btn == null) break;
                                box.getChildren().add((Object)btn);
                            }
                        }
                    }
                    ++var7_7;
                }
            }
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void cancel(ObSimpleInstruction instruction) {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500")) {
            try {
                this.getModel().cancel(instruction);
            }
            catch (MException e) {
                this.logger.error("\u6307\u4ee4\u64a4\u9500\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25 " + e.getMessage());
                return;
            }
            this.logger.info("\u6307\u4ee4\u64a4\u9500\u6210\u529f,id:" + instruction.getId());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u64a4\u9500\u6210\u529f");
        }
    }

    private void reject(ObSimpleInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u6307\u4ee4\u9a73\u56de")) {
            return;
        }
        try {
            this.getModel().reject(instruction, action, task, null);
        }
        catch (MException e) {
            this.logger.error("\u6307\u4ee4\u5ba1\u6279\u62d2\u7edd\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u9a73\u56de\u5931\u8d25 " + e.getMessage());
            return;
        }
        this.logger.info("\u6307\u4ee4\u5ba1\u6279\u62d2\u7edd\u6210\u529f,id:" + instruction.getId());
        this.alert.alert(Alert.AlertType.INFORMATION, "\u9a73\u56de\u6210\u529f");
    }

    private void applyCancel(ObSimpleInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u7533\u8bf7\u64a4\u9500\u8be5\u6307\u4ee4")) {
            return;
        }
        try {
            this.getModel().reject(instruction, action, task, null);
        }
        catch (MException e) {
            this.logger.error("\u6307\u4ee4\u7533\u8bf7\u64a4\u9500\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u7533\u8bf7\u64a4\u9500\u5931\u8d25 " + e.getMessage());
            return;
        }
        this.logger.info("\u6307\u4ee4\u7533\u8bf7\u64a4\u9500\u6210\u529f,id:" + instruction.getId());
        this.alert.alert(Alert.AlertType.INFORMATION, "\u7533\u8bf7\u64a4\u9500\u6210\u529f");
    }

    private void approveCancel(ObSimpleInstruction instruction, String action, WorkflowTask task) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5ba1\u6279\u64a4\u9500\u8be5\u6307\u4ee4")) {
            return;
        }
        try {
            this.getModel().reject(instruction, action, task, null);
        }
        catch (MException e) {
            this.logger.error("\u6307\u4ee4\u5ba1\u6279\u64a4\u9500\u5931\u8d25,id:" + instruction.getId(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u5ba1\u6279\u5ba1\u6279\u64a4\u9500\u5931\u8d25 " + e.getMessage());
            return;
        }
        this.logger.info("\u6307\u4ee4\u5ba1\u6279\u64a4\u9500\u6210\u529f,id:" + instruction.getId());
        this.alert.alert(Alert.AlertType.INFORMATION, "\u5ba1\u6279\u64a4\u9500\u6210\u529f");
    }

    protected void sendEvent(ObSimpleInstruction instruction) {
        if (instruction == null || !"NEEQ".equals(instruction.getSecMarket())) {
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001");
            return;
        }
        if (instruction.getIsOrderStep() || instruction.isIsApproveStep()) {
            try {
                this.getModel().udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        MEvent eCall = new MEvent();
        if ("SimpleDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.neeq.part.cp.neeq.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.neeq.part.cp.neeq.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    protected void selectRow(ObSimpleInstruction instruction) {
        this.tableNewInstruction.getSelectionModel().select((Object)instruction);
    }

    protected ReadOnlyObjectWrapper<Object> setDetail(ObSimpleInstruction instruction) {
        HBox box = new HBox(){

            public String toString() {
                return "\u8be6\u60c5";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button detail = new Button("\u8be6\u60c5");
        detail.getStyleClass().add((Object)"btnOperation");
        detail.setOnAction(event -> this.showDetail(instruction));
        box.getChildren().addAll((Object[])new Node[]{detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    protected void showDetail(ObSimpleInstruction instruction) {
        this.selectRow(instruction);
        InstructionNeeqDialog obj = (InstructionNeeqDialog)((Object)this.of.create(InstructionNeeqDialog.class));
        obj.setInstruction(instruction);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    public void setLstnCheckbox(ChangeListener<? super Boolean> lstnCheckbox) {
        this.lstnCheckbox = lstnCheckbox;
    }

    public NeeqInstructionModel getModel() {
        return this.model;
    }

    private /* synthetic */ void lambda$36(ObSimpleInstruction obSimpleInstruction, ActionEvent event) {
        this.cancel(obSimpleInstruction);
    }

    private /* synthetic */ void lambda$37(ObSimpleInstruction obSimpleInstruction, ActionEvent event) {
        this.sendEvent(obSimpleInstruction);
    }

    private /* synthetic */ void lambda$38(ObSimpleInstruction obSimpleInstruction, String string, WorkflowTask workflowTask, ActionEvent event) {
        this.reject(obSimpleInstruction, string, workflowTask);
    }

    private /* synthetic */ void lambda$39(ObSimpleInstruction obSimpleInstruction, ActionEvent event) {
        this.sendEvent(obSimpleInstruction);
    }

    private /* synthetic */ void lambda$40(ObSimpleInstruction obSimpleInstruction, ActionEvent event) {
        this.sendEvent(obSimpleInstruction);
    }

    private /* synthetic */ void lambda$41(ObSimpleInstruction obSimpleInstruction, String string, WorkflowTask workflowTask, ActionEvent event) {
        this.applyCancel(obSimpleInstruction, string, workflowTask);
    }

    private /* synthetic */ void lambda$42(ObSimpleInstruction obSimpleInstruction, String string, WorkflowTask workflowTask, ActionEvent event) {
        this.approveCancel(obSimpleInstruction, string, workflowTask);
    }
}

