/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxFileChooser;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.web.api.core.HttpClientService;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import okhttp3.Response;

public class InstructionUploadDialog
extends DialogObj {
    @FXML
    private TableView<WorkflowAttachment> tableAttachment;
    @FXML
    protected TableColumn<WorkflowAttachment, String> colFileName;
    @FXML
    protected TableColumn<WorkflowAttachment, String> colType;
    @FXML
    protected TableColumn<WorkflowAttachment, Object> colOperat;
    @FXML
    protected Button btnUploadOA;
    @FXML
    protected Button btnUploadContract;
    @FXML
    protected Button btnUploadConfirmation;
    private ObInstruction instruction;
    @Inject
    private WorkflowTemplateApi workflowTemplateApi;
    @Inject
    protected InstructionModel model;
    @Inject
    private MxFileChooser fileChooser;
    @Inject
    protected MxAlert alert;
    @Inject
    private HttpClientService https;
    private String uploadType = "";
    private ObservableList<WorkflowAttachment> attachmentList = FxUtils.newList();

    @FXML
    public void initialize() {
        this.createTable();
        this.btnUploadConfirmation.setVisible(false);
        if ("oa".equals(this.uploadType)) {
            this.btnUploadContract.setDisable(true);
        } else if ("contract".equals(this.uploadType)) {
            this.btnUploadOA.setDisable(true);
        }
    }

    @FXML
    protected void fileUpladOA() {
        this.chooserFile("oa");
    }

    @FXML
    protected void fileUploadContract() {
        this.chooserFile("contract");
    }

    @FXML
    protected void fileUploadConfirmation() {
        this.chooserFile("confirmation");
    }

    private void chooserFile(String type) {
        WorkflowAttachment attachment = null;
        File file = this.fileChooser.get();
        if (file == null) {
            return;
        }
        if (file.getName().length() > 150) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u540d\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\u9650\u5236\uff1a150");
            return;
        }
        if (file.length() > 65535000L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u8d85\u8fc7\u5927\u5c0f\u9650\u5236\uff1a64M");
            return;
        }
        try {
            attachment = this.workflowTemplateApi.uploadAttachment(file);
            attachment.setType(type);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25," + e.getMessage());
            return;
        }
        attachment.setNew(true);
        this.attachmentList.add((Object)attachment);
    }

    private void createTable() {
        this.colFileName.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getFileName()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getType()));
        this.colType.setCellFactory(cell -> new AttachTypeTableCell());
        this.colOperat.setCellValueFactory(data -> this.setOperation((WorkflowAttachment)data.getValue()));
        this.tableAttachment.setItems(this.attachmentList);
        this.tableAttachment.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAttachment);
    }

    protected ReadOnlyObjectWrapper<Object> setOperation(WorkflowAttachment attachment) {
        final String[] opStr = new String[]{""};
        HBox box = new HBox(){

            public String toString() {
                return opStr[0];
            }
        };
        if (attachment.isNew()) {
            Button btnDelete = new Button("\u5220\u9664");
            btnDelete.getStyleClass().add((Object)"btnOperation");
            box.setSpacing(10.0);
            box.setAlignment(Pos.CENTER);
            btnDelete.setOnAction(event -> this.delete(attachment));
            opStr[0] = "\u5220\u9664";
            box.getChildren().add((Object)btnDelete);
        }
        Button btnDown = new Button("\u4e0b\u8f7d");
        btnDown.getStyleClass().add((Object)"btnOperation");
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        btnDown.setOnAction(event -> this.download(attachment));
        opStr[0] = "\u5220\u9664";
        box.getChildren().add((Object)btnDown);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void download(WorkflowAttachment attachment) {
        try {
            Response response = this.https.doGet("/workflow/file/download?fileName=" + attachment.getId());
            InputStream body = response.body().byteStream();
            if (body != null) {
                ExcelUtils.saveFile((InputStream)body, (String)attachment.getFileName());
            }
        }
        catch (MException | Exception e2) {
            e2.printStackTrace();
        }
    }

    private void delete(WorkflowAttachment attachment) {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u8ba4\u5220\u9664")) {
            this.attachmentList.remove((Object)attachment);
        }
    }

    protected boolean isOK(ButtonType bt) {
        for (WorkflowAttachment workflowAttachment : this.attachmentList) {
            if (!workflowAttachment.isNew()) continue;
            return true;
        }
        this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u81f3\u5c11\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6");
        return false;
    }

    public void initialValues() {
        this.attachmentList.addAll((Collection)this.instruction.getAttachments());
    }

    public ObInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObInstruction instruction) {
        this.instruction = instruction;
    }

    public ObservableList<WorkflowAttachment> getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(ObservableList<WorkflowAttachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    class AttachTypeTableCell<S>
    extends TableCell<S, String> {
        AttachTypeTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if ("oa".equals(item)) {
                    this.setText("OA");
                } else if ("contract".equals(item)) {
                    this.setText("\u5408\u540c");
                } else if ("confirmation".equals(item)) {
                    this.setText("\u4efd\u989d\u786e\u8ba4\u4e66");
                } else {
                    this.setText("");
                }
            } else {
                this.setText(null);
            }
        }
    }
}

