/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.Result;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CcsTradeSettings;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.query.current.views.FairTradeDialog;
import cms.tmx.query.current.views.HotkeyApproveDialog;
import cms.tmx.query.current.views.InstructDialog;
import cms.tmx.query.current.views.InstructionAuditDialog;
import cms.tmx.query.current.views.InstructionPostilDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.history.views.InstructionSideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class InstructionQueryPart
extends MxPart {
    @FXML
    protected TableView<Instruction> tableInstruction;
    @FXML
    protected TableColumn<Instruction, Boolean> colSelected;
    @FXML
    protected TableColumn<Instruction, String> colInsId;
    @FXML
    protected TableColumn<Instruction, String> colBelongTo;
    @FXML
    protected TableColumn<Instruction, String> colInsType;
    @FXML
    protected TableColumn<Instruction, String> colInsStatus;
    @FXML
    protected TableColumn<Instruction, Number> colInsProgress;
    @FXML
    protected TableColumn<Instruction, Number> colOrdRatio;
    @FXML
    protected TableColumn<Instruction, List<ActionInfo>> colInsOption;
    @FXML
    protected TableColumn<Instruction, Object> colInsDetail;
    @FXML
    protected TableColumn<Instruction, String> colInsBeginTime;
    @FXML
    protected TableColumn<Instruction, String> colInsEndTime;
    @FXML
    private TableColumn<Instruction, String> colSecId;
    @FXML
    protected TableColumn<Instruction, String> colInsObj;
    @FXML
    private TableColumn<Instruction, String> colMarket;
    @FXML
    protected TableColumn<Instruction, Number> colQty;
    @FXML
    protected TableColumn<Instruction, Number> colCumAmount;
    @FXML
    protected TableColumn<Instruction, Number> colAvgPx;
    @FXML
    protected TableColumn<Instruction, String> colSide;
    @FXML
    protected TableColumn<Instruction, String> colInsInfo;
    @FXML
    protected TableColumn<Instruction, String> colInsPrice;
    @FXML
    protected TableColumn<Instruction, String> colExpiredDate;
    @FXML
    protected TableColumn<Instruction, Number> colOrderAmount;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAmt;
    @FXML
    protected CheckBox checkboxFinished;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MxAlert alert;
    @FXML
    protected TextField searchText;
    @FXML
    protected Button btnHotApprove;
    @FXML
    protected Label lbApprHotkey;
    @Inject
    protected InstructionModel model;
    @Inject
    protected ResourceModel resourceModel;
    @Inject
    protected InstructionExecMng resourceDetailMng;
    @Inject
    protected IUiRightService rightsModel;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private IUserSettingsService usMng;
    protected volatile boolean cancelAllOrder = false;
    protected CheckBox checkBox = new CheckBox();
    protected static final int DOUBLE_CLICK_COUNT = 2;
    @Inject
    protected ExecutorService exe;
    @Inject
    protected MEventService es;
    @Inject
    protected EPartService eps;
    @Inject
    private AlgoQueryModel algoTradeModel;
    @Inject
    private IFundAccountService fundService;
    @FXML
    private ComboBox<String> cmbAccnt;
    protected MxList<Instruction> mxList = new MxList();
    private String funcPanelType = "6";
    private String menuId = "200052";
    private boolean fairStatus = false;
    private static final String ALL = "\u5168\u90e8";
    protected Predicate<Instruction> pd = en -> {
        String text = this.searchText.getText().trim();
        String status = en.getStatus().getRaw();
        if (!this.checkboxFinished.isSelected() && ("6".equals(status) || "7".equals(status) || "4".equals(status) || "59".equals(status) || "61".equals(status) || "19".equals(status) || "20".equals(status))) {
            return false;
        }
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (!(en.getId().contains(text) || en.getBelongTo() == null || en.getBelongTo().contains(text) || en.getSecurityCode().contains(text))) {
            return false;
        }
        return !this.extend((Instruction)en);
    };
    private InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        Platform.runLater(() -> {
            List newList = Collections.synchronizedList(new ArrayList());
            ObservableList observableList = this.model.getList().getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList().getList());
            }
            this.mxList.update(newList, this.pd);
            this.handleCheckBox();
            this.tableInstruction.sort();
            this.getLstnSearch().invalidated(null);
        });
    };
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.model.getList().getList(), this.pd);
        }
        this.tableInstruction.sort();
    });
    private EventHandler<KeyEvent> handlerHotkeyTrigger = event -> {
        KeyCode code = event.getCode();
        if ("F2".equals(code.getName())) {
            List<Instruction> instructions = this.model.getList().getList().stream().filter(item -> item.isIsApproveStep() && item.isCanHotApprove() && item.isSelected()).collect(Collectors.toList());
            this.hotkeyApprove(instructions);
        }
    };
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isIsApproveStep()) {
                    e.setSelected(now.booleanValue());
                    e.setApprManualSelected(true);
                } else {
                    e.setSelected(false);
                }
            });
        }
    };
    protected Callback<TableColumn<Instruction, List<ActionInfo>>, TableCell<Instruction, List<ActionInfo>>> cellFactory = new Callback<TableColumn<Instruction, List<ActionInfo>>, TableCell<Instruction, List<ActionInfo>>>(){

        public TableCell<Instruction, List<ActionInfo>> call(TableColumn<Instruction, List<ActionInfo>> arg0) {
            TableCell<Instruction, List<ActionInfo>> cell = new TableCell<Instruction, List<ActionInfo>>(){
                final HBox hbox = new HBox();

                public void updateItem(List<ActionInfo> actions, boolean empty) {
                    super.updateItem(actions, empty);
                    if (empty || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        this.setGraphic(null);
                        this.setText(null);
                        return;
                    }
                    this.hbox.getChildren().clear();
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.hbox.getChildren().setAll(InstructionQueryPart.this.getActions(ins));
                    this.setGraphic((Node)this.hbox);
                    this.setText(null);
                }
            };
            return cell;
        }
    };
    protected Callback<TableColumn<Instruction, Object>, TableCell<Instruction, Object>> detailCellFactory = new Callback<TableColumn<Instruction, Object>, TableCell<Instruction, Object>>(){

        public TableCell<Instruction, Object> call(TableColumn<Instruction, Object> arg0) {
            TableCell<Instruction, Object> cell = new TableCell<Instruction, Object>(){
                final Button btn = new Button("\u8be6\u60c5");

                public void updateItem(Object obj, boolean empty) {
                    super.updateItem(obj, empty);
                    if (empty || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        this.setGraphic(null);
                        this.setText(null);
                        return;
                    }
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.btn.setOnAction(event -> InstructionQueryPart.this.showDetail(ins));
                    this.btn.getStyleClass().add((Object)"btnOperation");
                    this.setGraphic((Node)this.btn);
                    this.setText(null);
                }
            };
            return cell;
        }
    };
    @Inject
    private AlgoMiseMng miseMng;
    @Inject
    private LoadPartModel load;
    private MEventHandler reload = event -> this.doSet();

    public boolean premise(Instruction ins) {
        return ins.getDescId() != 8;
    }

    public boolean extend(Instruction order) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return false;
        }
        String[] split = accntNow.split("__");
        return !ALL.equals(accntNow) && !order.getInvestId().contains(split[0]);
    }

    public void onVisit() {
        this.getLstnModel().invalidated(null);
    }

    protected void handleCheckBox() {
        boolean hasSelectedItem = false;
        boolean hasCanHotApprove = false;
        for (Instruction instruction : this.mxList.getList()) {
            if (instruction.isSelected()) {
                hasSelectedItem = true;
            }
            if (!instruction.isIsApproveStep()) continue;
            hasCanHotApprove = true;
        }
        if (hasSelectedItem) {
            this.checkBox.setSelected(true);
            this.checkBox.setDisable(false);
            this.btnHotApprove.setDisable(false);
        } else if (hasCanHotApprove) {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(false);
            this.btnHotApprove.setDisable(false);
        } else {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(true);
            this.btnHotApprove.setDisable(true);
        }
    }

    @FXML
    private void hotkeyApprove() {
        this.hotkeyApprove(this.getApproveList());
    }

    protected List<Instruction> getApproveList() {
        return this.model.getList().getList().stream().filter(item -> item.isIsApproveStep() && item.isSelected() && !item.isMail()).collect(Collectors.toList());
    }

    protected void hotkeyApprove(List<Instruction> instructions) {
        if (instructions.isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6ca1\u6709\u53ef\u4ee5\u6279\u91cf\u5ba1\u6279\u7684\u6307\u4ee4");
            return;
        }
        HotkeyApproveDialog obj = (HotkeyApproveDialog)((Object)this.of.create(HotkeyApproveDialog.class));
        obj.getInstructions().addAll(instructions);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u5feb\u6377\u5ba1\u6279");
        dialog.getButton(ButtonType.OK).setText("\u5ba1\u6279\u901a\u8fc7");
        dialog.getButton(ButtonType.NO).setText("\u9a73\u56de");
        ButtonType bt = dialog.launch();
        if (bt.equals(ButtonType.OK)) {
            this.batchApprove(instructions);
        } else if (bt.equals(ButtonType.NO)) {
            this.batchReject(instructions);
        }
    }

    private void batchReject(List<Instruction> instructionsCanBeApproved) {
        Result res = this.model.batchReject(instructionsCanBeApproved);
        if (res.failed > 0) {
            this.alert.alert(Alert.AlertType.ERROR, res.getDesc("\u9a73\u56de"));
        } else {
            this.alert.alert(Alert.AlertType.INFORMATION, res.getDesc("\u9a73\u56de"));
        }
    }

    private void batchApprove(List<Instruction> instructionsCanBeApproved) {
        Result res = this.model.batchApprove(instructionsCanBeApproved);
        if (res.failed > 0) {
            this.alert.alert(Alert.AlertType.ERROR, res.getDesc("\u5ba1\u6279"));
        } else {
            this.alert.alert(Alert.AlertType.INFORMATION, res.getDesc("\u5ba1\u6279"));
        }
    }

    @Focus
    public void onFocus() {
    }

    @FXML
    public void initialize() {
        this.doSet();
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.checkAuth();
        this.initCmbAccnt();
        this.getLstnSearch().invalidated(null);
        this.es.subscribe("settingsRefresh", this.reload);
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.fundService.getAllFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
    }

    @PreDestroy
    protected void close() {
        this.model.changedProperty().removeListener(this.getLstnModel());
        this.searchText.textProperty().removeListener(this.getLstnSearch());
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
        this.checkboxFinished.selectedProperty().addListener(this.getLstnSearch());
    }

    protected void initHotkey() {
        this.tableInstruction.setOnKeyPressed(this.handlerHotkeyTrigger);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableInstruction);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u5bfc\u51faEXCEL\u5f02\u5e38" + e);
        }
    }

    protected void createTable() {
        this.colSelected.setGraphic((Node)this.checkBox);
        this.colSelected.setCellValueFactory(data -> ((Instruction)data.getValue()).selectedProperty());
        this.colSelected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colInsId.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colInsType.setCellValueFactory(data -> ((Instruction)data.getValue()).exTypeProperty());
        this.colInsStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).oprAndStatusProperty());
        this.colInsProgress.setCellValueFactory(data -> ((Instruction)data.getValue()).ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colOrdRatio.setCellValueFactory(data -> ((Instruction)data.getValue()).ordRatioProperty());
        this.colOrdRatio.setCellFactory(p -> new DoubleTableCell());
        this.colInsPrice.setCellValueFactory(data -> ((Instruction)data.getValue()).insPriceProperty());
        this.colInsOption.setCellValueFactory(data -> ((Instruction)data.getValue()).actionListProperty());
        this.colInsOption.setCellFactory(this.cellFactory);
        this.colInsDetail.setCellFactory(this.detailCellFactory);
        this.colInsBeginTime.setCellValueFactory(data -> ((Instruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((Instruction)data.getValue()).insEndTimeProperty());
        this.colSecId.setCellValueFactory(data -> ((Instruction)data.getValue()).securityCodeProperty());
        this.colInsObj.setCellValueFactory(data -> ((Instruction)data.getValue()).orderObjProperty());
        this.colMarket.setCellValueFactory(data -> ((Instruction)data.getValue()).marketNameProperty());
        this.colQty.setCellValueFactory(data -> ((Instruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ordAmtProperty());
        this.colOrdAmt.setCellFactory(p -> new PriceCell());
        this.colSide.setCellValueFactory(data -> ((Instruction)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colInsInfo.setCellValueFactory(data -> ((Instruction)data.getValue()).errInfoProperty());
        this.colInsInfo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((Instruction)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colCumAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).tradeAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colOrderAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> ((Instruction)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(cell -> new AvgPriceCell());
        this.colExpiredDate.setCellValueFactory(data -> ((Instruction)data.getValue()).expireDateProperty());
        this.tableInstruction.setItems(this.mxList.getList());
        this.tableInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableInstruction);
        this.tableDoubleClickHandler();
    }

    private boolean fairTradeEvent(Instruction instruction) {
        ArrayList<Instruction> fairTradeList = new ArrayList<Instruction>();
        String portfName = instruction.getPortfolioName();
        boolean isDiffPortf = false;
        for (Instruction inst : this.mxList.getList()) {
            try {
                this.model.udpateAvailableOrderQty(inst);
            }
            catch (MException ex) {
                this.logger.error("\u6307\u4ee4\u66f4\u65b0\u8d44\u6e90\u5931\u8d25", (Throwable)ex);
            }
            if (!"\u6295\u7ec4\u6307\u4ee4".equals(inst.getExType()) || !inst.getSecurityCode().equals(instruction.getSecurityCode()) || !inst.getOrderObj().equals(instruction.getOrderObj()) || !inst.getMarket().equals(instruction.getMarket()) || !inst.getSide().equals(instruction.getSide()) || !"\u5f85\u6267\u884c".equals(inst.getStatus().getValue()) && !"\u6267\u884c\u4e2d".equals(inst.getStatus().getValue()) || !inst.getIsOrderStep() || inst.getResource().getAvailOrderQty() <= 0L) continue;
            inst.setOrderQty(inst.getTotalExpectationQty());
            inst.setOrderPrice(inst.getOrderAdvice().getPrice());
            fairTradeList.add(inst);
        }
        for (Instruction fairInst : fairTradeList) {
            if (portfName.equals(fairInst.getPortfolioName())) continue;
            isDiffPortf = true;
        }
        if (fairTradeList.size() > 1 && this.isFairStatus() && fairTradeList.contains(instruction) && isDiffPortf && instruction.getIsOrderStep()) {
            FairTradeDialog obj = (FairTradeDialog)((Object)this.of.create(FairTradeDialog.class));
            obj.setDataList(fairTradeList);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u516c\u5e73\u4ea4\u6613");
            dialog.setBtnText(ButtonType.OK, "\u6267\u884c\u6307\u4ee4");
            ButtonType bt = dialog.launch();
            if (bt.equals(ButtonType.OK)) {
                for (Instruction inst : obj.getInstList()) {
                    try {
                        this.model.fairTradeOrderSingle(inst);
                        this.model.execute(inst, MxDict.WORKFLOW_EXECUTE, inst.getPostil());
                    }
                    catch (MException e) {
                        this.logger.error((Object)e, (Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void tableDoubleClickHandler() {
        this.tableInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Instruction instruction;
            if (event.getClickCount() == 2 && !this.fairTradeEvent(instruction = (Instruction)this.tableInstruction.getSelectionModel().getSelectedItem())) {
                this.sendEvent(instruction);
            }
            if (!this.p.isFocused() && !this.tableInstruction.isFocused()) {
                Platform.runLater(() -> this.p.requestFocus());
            }
        });
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableInstruction.getSortOrder().add(this.colInsId);
        this.tableInstruction.sort();
    }

    protected List<Button> getActions(Instruction instruction) {
        ArrayList<Button> actions = new ArrayList<Button>();
        if (instruction.getTransferInfo() != null) {
            ArrayList arrayList = new ArrayList();
            instruction.getLock().lock();
            try {
                arrayList.addAll(instruction.getTransferInfo().getActionInfoList());
            }
            finally {
                instruction.getLock().unlock();
            }
            block16: for (ActionInfo action : arrayList) {
                Button btn = new Button(action.getActionName());
                btn.setMinWidth(100.0);
                btn.getStyleClass().add((Object)"btnOperation");
                switch (action.getActionId()) {
                    case 2: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        break;
                    }
                    case 3: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        break;
                    }
                    case 4: {
                        btn.setOnAction(event -> this.reject(instruction, action.getActionId()));
                        break;
                    }
                    case 5: {
                        btn.setOnAction(event -> this.entrust(instruction, action.getActionId()));
                        break;
                    }
                    case 6: {
                        btn.setOnAction(event -> this.cancel(instruction, action.getActionId()));
                        break;
                    }
                    case 9: {
                        btn.setOnAction(event -> this.tradeExecute(instruction, action.getActionId()));
                        break;
                    }
                    case 8: {
                        btn.setOnAction(event -> this.tradeCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 10: {
                        btn.setOnAction(event -> this.reviewed(instruction, action.getActionId()));
                        break;
                    }
                    case 13: {
                        btn.setOnAction(event -> this.applyCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 22: {
                        btn.setOnAction(event -> this.orderCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 14: {
                        btn.setOnAction(event -> this.approveCancel(instruction, action.getActionId()));
                        break;
                    }
                    default: {
                        continue block16;
                    }
                }
                if (!this.cancelAllOrder && 22 == action.getActionId()) continue;
                actions.add(btn);
            }
        }
        return actions;
    }

    protected void orderCancel(Instruction instruction, Integer actionId) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u53d1\u8d77\u6307\u4ee4\u7f16\u53f7" + instruction.getId() + " " + instruction.getOrderObj() + "\u7684\u59d4\u6258\u5168\u90e8\u64a4\u5355", "\u5168\u90e8\u64a4\u5355")) {
            return;
        }
        this.cancelResourceAndOrder(instruction, actionId, false);
    }

    protected void applyCancel(Instruction instruction, int actionId) {
        this.logger.info("\u6307\u4ee4\u7533\u8bf7\u64a4\u9500|" + instruction.getId());
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u7533\u8bf7\u64a4\u9500\u6307\u4ee4")) {
            return;
        }
        try {
            this.model.applyCancel(instruction, actionId, "");
        }
        catch (MException e) {
            this.logger.error("instruction applyCancel failed " + instruction.getId(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u7533\u8bf7\u64a4\u9500\u51fa\u9519\uff0c" + (Object)((Object)e));
        }
    }

    protected void approveCancel(Instruction instruction, int actionId) {
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500", "\u6307\u4ee4\u64a4\u9500")) {
            return;
        }
        this.logger.info("\u6307\u4ee4\u5ba1\u6279\u64a4\u9500|" + instruction.getId());
        try {
            this.model.cancel(instruction, actionId, "");
        }
        catch (MException | Exception e) {
            this.logger.error("\u7ba1\u7406\u7aef\u6307\u4ee4\u64a4\u9500\u5931\u8d25", e);
        }
        this.cancelResourceAndOrder(instruction, actionId, false);
    }

    protected void reviewed(Instruction instruction, int actionId) {
        try {
            InstructionPostilDialog obj = (InstructionPostilDialog)((Object)this.of.create(InstructionPostilDialog.class));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u9605\u77e5");
            ButtonType bt = dialog.launch();
            if (bt.equals(ButtonType.OK)) {
                this.model.reviewed(instruction, actionId, obj.getPostil());
            }
        }
        catch (MException e) {
            this.logger.error("instruction review failed " + instruction.getId(), (Throwable)e);
        }
    }

    protected void tradeExecute(Instruction instruction, int actionId) {
        this.entrust(instruction, actionId);
    }

    protected void tradeCancel(Instruction instruction, int actionId) {
        this.selectRow(instruction);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500", "\u6307\u4ee4\u64a4\u9500")) {
            return;
        }
        this.cancelResourceAndOrder(instruction, actionId, true);
    }

    private void cancelResourceAndOrder(Instruction instruction, int actionId, boolean cancelResource) {
        switch (instruction.getType().getRaw()) {
            case "4": 
            case "5": {
                if (instruction.isCanModify()) {
                    this.cancelAlgo(instruction);
                }
                this.basketCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "8": 
            case "9": {
                this.cancelAlgo(instruction);
                this.orderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "12": 
            case "13": 
            case "16": 
            case "17": {
                this.cancelBasketAlgo(instruction.getId());
                this.orderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "2": 
            case "3": {
                if (instruction.getSecurityType().equals("OIS")) {
                    if (cancelResource) {
                        this.resourceCancel(instruction);
                    }
                    this.model.addToDirty(instruction);
                    break;
                }
                if (instruction.isCanModify()) {
                    this.cancelAlgo(instruction);
                }
                this.orderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "32": {
                this.blockOrderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "34": {
                this.blockOrderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
            case "64": {
                this.futuresOrderCancel(instruction, cancelResource);
                this.model.addToDirty(instruction);
                break;
            }
        }
    }

    private void cancelBasketAlgo(String instructionId) {
        this.algoTradeModel.miseModel.query();
        ArrayList<AlgoBaseOrder> algoList = new ArrayList<AlgoBaseOrder>();
        algoList.addAll(this.algoTradeModel.getMiseList());
        for (AlgoBaseOrder baseOrder : algoList) {
            if (!baseOrder.getAlgoParam().getReference().equals(instructionId) || !baseOrder.getStatus().getRaw().equals("0") && !baseOrder.getStatus().getRaw().equals("1")) continue;
            try {
                this.miseMng.miseCancelOrder(baseOrder.getSubAcct(), baseOrder.getBaseId());
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void cancelAlgo(Instruction instruction) {
        switch (instruction.getStatus().getRaw()) {
            case "5": 
            case "6": 
            case "8": {
                return;
            }
        }
        this.algoTradeModel.query();
        ArrayList<AlgoBaseOrder> listApama = new ArrayList<AlgoBaseOrder>();
        listApama.addAll((Collection<AlgoBaseOrder>)this.algoTradeModel.getOrderList());
        for (AlgoBaseOrder baseOrder : listApama) {
            if (!baseOrder.getAlgoParam().getReference().equals(instruction.getId()) || !baseOrder.getStatus().getRaw().equals("0") && !baseOrder.getStatus().getRaw().equals("1")) continue;
            try {
                this.algoTradeModel.cancelOrder(baseOrder);
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
        LinkedList<AlgoBaseOrder> listMise = new LinkedList<AlgoBaseOrder>();
        try {
            listMise.addAll(this.algoTradeModel.queryBaseOrder(instruction));
            for (AlgoBaseOrder baseOrder : listMise) {
                if (!baseOrder.getInstructionId().equals(instruction.getId()) || !baseOrder.getStatus().getRaw().equals("0") && !baseOrder.getStatus().getRaw().equals("1")) continue;
                try {
                    this.miseMng.miseCancelOrder(baseOrder.getSubAcct(), baseOrder.getBaseId());
                }
                catch (MException e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
        }
        catch (MException e1) {
            this.logger.error((Object)e1, (Throwable)e1);
        }
    }

    private void resourceCancel(Instruction instruction) {
        try {
            this.model.cancelResource(instruction);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    private void orderCancel(Instruction instruction, boolean cancelResource) {
        try {
            MEvent event = this.model.orderCancel(instruction, cancelResource);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
            if (event.getInt("suc.count") == 0) {
                this.model.addToDirty(instruction);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    private void blockOrderCancel(Instruction instruction, boolean cancelResource) {
        try {
            this.model.blockOrderCancel(instruction, cancelResource);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
            this.model.addToDirty(instruction);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    private void futuresOrderCancel(Instruction instruction, boolean cancelResource) {
        try {
            MEvent event = this.model.futuresOrderCancel(instruction, cancelResource);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
            if (event.getInt("suc.count") == 0) {
                this.model.addToDirty(instruction);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    private void basketCancel(Instruction instruction, boolean cancelResource) {
        try {
            this.model.basketCancel(instruction, cancelResource);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u7bee\u5b50\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            this.logger.error(String.valueOf(instruction.getId()) + "\u7bee\u5b50\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    private void adjustCancel(Instruction instruction) {
        try {
            this.model.adjustCancel(instruction);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u5df2\u63d0\u4ea4");
            this.model.addToDirty(instruction);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25:" + e.getMessage());
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
        }
    }

    protected void entrust(Instruction instruction, int actionId) {
        if (!this.fairTradeEvent(instruction)) {
            this.selectRow(instruction);
            this.sendEvent(instruction);
        }
    }

    protected void entrustBasket(Instruction instruction, int actionId) {
        this.selectRow(instruction);
        if ("4".equals(instruction.getType().getRaw())) {
            this.sendBasketEvent(instruction);
        } else {
            this.sendEvent(instruction);
        }
    }

    protected void sendBasketEvent(Instruction instruction) {
        if (instruction == null) {
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001\u6216\u6307\u4ee4\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
            return;
        }
        MEvent eCall = new MEvent();
        if (instruction.getIsOrderStep() && (instruction.isRegular() || instruction.isAlgo() || instruction.isBlock() || instruction.isFutures())) {
            try {
                this.model.udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        if (StringUtils.belongto((String)instruction.getType().getRaw(), (String[])new String[]{"4", "12"})) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.shortcut.basketorder.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.basket.approve");
            } else {
                return;
            }
            if (instruction.getBasketOrderAdvice() == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u7bee\u5b50\u6307\u4ee4\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            this.queryBasketItems(instruction);
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    protected void sendEvent(Instruction instruction) {
        MPart newPart;
        String partId;
        if (instruction == null) {
            return;
        }
        if ("CMS-TMX-INSTRUCTIONS-PART-REGULAR-INSTRUCTION-CREATER-QUERY-ZY".equals(this.p.getParent().getParent().getId().toUpperCase())) {
            MPart newPart2 = this.eps.findPart("cms.tmx.instructions.part.regular.instruct.autotrophy.zy");
            this.eps.showPart(newPart2, EPartService.PartState.ACTIVATE);
            MEvent eCall = new MEvent();
            eCall.setObj((Object)instruction);
            this.es.sendEvent("instruction.set.on.panel.zy", eCall);
            return;
        }
        this.model.updateResource(instruction);
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001\u6216\u6307\u4ee4\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
            return;
        }
        MEvent eCall = new MEvent();
        if (instruction.getIsOrderStep() && (instruction.isRegular() || instruction.isAlgo() || instruction.isBlock() || instruction.isFutures())) {
            try {
                this.model.udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        if ("2".equals(instruction.getType().getRaw()) && instruction.getSecurityType().equals("OIS")) {
            MPart newPart3 = null;
            if (instruction.getIsOrderStep()) {
                newPart3 = this.eps.findPart("cms.tmx.newstock.part.instruction.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart3 = this.eps.findPart("cms.tmx.newstock.part.instruction.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart3, EPartService.PartState.ACTIVATE);
        } else if ("2".equals(instruction.getType().getRaw()) && instruction.getOrderAdvice().getSide() == 84) {
            MPart newPart4 = null;
            if (instruction.getIsOrderStep()) {
                newPart4 = this.eps.findPart("cms.tmx.newstock.part.instruction.rationed.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart4 = this.eps.findPart("cms.tmx.newstock.part.instruction.rationed.execution");
            } else {
                return;
            }
            this.eps.showPart(newPart4, EPartService.PartState.ACTIVATE);
        } else if ("2".equals(instruction.getType().getRaw())) {
            boolean isHk = StringUtils.belongto((String)instruction.getMarket(), (String[])new String[]{"SHSC", "SZSC"});
            partId = null;
            if (instruction.getIsOrderStep()) {
                partId = isHk ? "cms.tmx.instructions.part.hkwolun.execution" : "cms.tmx.instructions.part.regular.execution";
            } else if (instruction.isIsApproveStep()) {
                partId = isHk ? "cms.tmx.instructions.part.hkwolun.approve" : "cms.tmx.instructions.part.regular.approve";
            } else {
                return;
            }
            newPart = this.eps.findPart(partId);
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        if ("8".equals(instruction.getType().getRaw())) {
            boolean isHk = StringUtils.belongto((String)instruction.getMarket(), (String[])new String[]{"SHSC", "SZSC"});
            partId = null;
            if (instruction.getIsOrderStep()) {
                partId = isHk ? "cms.tmx.instructions.part.hkwolun.execution" : "cms.tmx.instructions.part.regular.execution";
            } else if (instruction.isIsApproveStep()) {
                partId = isHk ? "cms.tmx.instructions.part.hkwolun.approve" : "cms.tmx.instructions.part.regular.approve";
            } else {
                return;
            }
            newPart = this.eps.findPart(partId);
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        if ("3".equals(instruction.getType().getRaw()) && 200 == instruction.getOrderAdvice().getSide()) {
            String partId2 = null;
            if (instruction.getIsOrderStep()) {
                partId2 = "cms.tmx.instructions.cp.portfolio.convertible.exec";
            } else if (instruction.isIsApproveStep()) {
                partId2 = "cms.tmx.instructions.cp.portfolio.convertible.pass";
            } else {
                return;
            }
            MPart newPart5 = this.eps.findPart(partId2);
            this.eps.showPart(newPart5, EPartService.PartState.ACTIVATE);
        } else if ("3".equals(instruction.getType().getRaw()) && instruction.getSecurityType().equals("OIS")) {
            MPart newPart6 = null;
            if (instruction.getIsOrderStep()) {
                newPart6 = this.eps.findPart("cms.tmx.portfolio.newstock.part.instruction.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart6 = this.eps.findPart("cms.tmx.portfolio.newstock.part.instruction.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart6, EPartService.PartState.ACTIVATE);
        } else if ("3".equals(instruction.getType().getRaw())) {
            boolean isHk = StringUtils.belongto((String)instruction.getMarket(), (String[])new String[]{"SHSC", "SZSC"});
            boolean isMail = instruction.getDescId() == WorkflowTemplete.MAIL.getId();
            String partId3 = null;
            if (isMail && !isHk) {
                partId3 = "cms.tmx.instructions.part.portfolio.approve.mail";
            } else if (isMail && isHk) {
                partId3 = "cms.tmx.instructions.part.portfolio.hkwolun.approve.mail";
            } else if (instruction.getIsOrderStep()) {
                partId3 = isHk ? "cms.tmx.instructions.part.portfolio.hkwolun.execution" : "cms.tmx.instructions.part.portfolio.execution";
            } else if (instruction.isIsApproveStep()) {
                partId3 = isHk ? "cms.tmx.instructions.part.portfolio.hkwolun.approve" : "cms.tmx.instructions.part.portfolio.approve";
            } else {
                return;
            }
            MPart newPart7 = this.eps.findPart(partId3);
            this.eps.showPart(newPart7, EPartService.PartState.ACTIVATE);
        }
        if (StringUtils.belongto((String)instruction.getType().getRaw(), (String[])new String[]{"5", "13"})) {
            MPart newPart8 = null;
            if (instruction.isMail() && instruction.isIsApproveStep()) {
                newPart8 = this.eps.findPart("cms.tmx.instructions.part.portfolio.basket.approve.mail");
            } else if (instruction.getIsOrderStep()) {
                newPart8 = this.eps.findPart("cms.tmx.instructions.part.portfolio.basket.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart8 = this.eps.findPart("cms.tmx.instructions.part.portfolio.basket.approve");
            } else {
                return;
            }
            if (instruction.getBasketOrderAdvice() == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u7bee\u5b50\u6307\u4ee4\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            this.queryBasketItems(instruction);
            this.eps.showPart(newPart8, EPartService.PartState.ACTIVATE);
        }
        if (StringUtils.belongto((String)instruction.getType().getRaw(), (String[])new String[]{"4", "12"})) {
            MPart newPart9 = null;
            if (instruction.getIsOrderStep()) {
                newPart9 = this.eps.findPart("cms.tmx.instructions.part.basket.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart9 = this.eps.findPart("cms.tmx.instructions.part.basket.approve");
            } else {
                return;
            }
            if (instruction.getBasketOrderAdvice() == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u7bee\u5b50\u6307\u4ee4\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            this.queryBasketItems(instruction);
            this.eps.showPart(newPart9, EPartService.PartState.ACTIVATE);
        }
        if ("9".equals(instruction.getType().getRaw())) {
            boolean isHk = StringUtils.belongto((String)instruction.getMarket(), (String[])new String[]{"SHSC", "SZSC"});
            String partId4 = null;
            if (instruction.getIsOrderStep()) {
                partId4 = isHk ? "cms.tmx.instructions.part.portfolio.hkwolun.execution" : "cms.tmx.instructions.part.portfolio.execution";
            } else if (instruction.isIsApproveStep()) {
                partId4 = isHk ? "cms.tmx.instructions.part.portfolio.hkwolun.approve" : "cms.tmx.instructions.part.portfolio.approve";
            } else {
                return;
            }
            newPart = this.eps.findPart(partId4);
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        if ("16".equals(instruction.getType().getRaw())) {
            MPart newPart10 = null;
            if (instruction.getIsOrderStep()) {
                newPart10 = this.eps.findPart("cms.tmx.instructions.part.ccs.adj.execute");
            } else if (instruction.isIsApproveStep()) {
                newPart10 = this.eps.findPart("cms.tmx.instructions.part.ccs.adj.approve");
            } else {
                return;
            }
            if (instruction.getAdjustPosAdvice() == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8c03\u4ed3\u6307\u4ee4\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            this.queryAdjItems(instruction);
            this.eps.showPart(newPart10, EPartService.PartState.ACTIVATE);
        }
        if ("17".equals(instruction.getType().getRaw())) {
            MPart newPart11 = null;
            if (instruction.getIsOrderStep()) {
                newPart11 = this.eps.findPart("cms.tmx.instructions.part.port.adj.execute");
            } else if (instruction.isIsApproveStep()) {
                newPart11 = this.eps.findPart("cms.tmx.instructions.part.port.adj.approve");
            } else {
                return;
            }
            if (instruction.getAdjustPosAdvice() == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8c03\u4ed3\u6307\u4ee4\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            this.queryAdjItems(instruction);
            this.eps.showPart(newPart11, EPartService.PartState.ACTIVATE);
        }
        if ("32".equals(instruction.getType().getRaw())) {
            MPart newPart12 = null;
            if (instruction.getIsOrderStep()) {
                newPart12 = this.eps.findPart("cms.tmx.block.cp.up.left.part.execute");
            } else if (instruction.isIsApproveStep()) {
                newPart12 = this.eps.findPart("cms.tmx.block.cp.up.left.part.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart12, EPartService.PartState.ACTIVATE);
        }
        if ("34".equals(instruction.getType().getRaw())) {
            MPart newPart13 = null;
            if (instruction.getIsOrderStep()) {
                newPart13 = this.eps.findPart("cms.tmx.block.cp.fixedIncome.up.left.part.execute");
            } else if (instruction.isIsApproveStep()) {
                newPart13 = this.eps.findPart("cms.tmx.block.cp.fixedIncome.up.left.part.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart13, EPartService.PartState.ACTIVATE);
        }
        if ("64".equals(instruction.getType().getRaw())) {
            MPart newPart14 = null;
            if (instruction.getIsOrderStep()) {
                newPart14 = this.eps.findPart("cms.tmx.future.instructions.part.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart14 = this.eps.findPart("cms.tmx.future.instructions.part.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart14, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    protected boolean isBasket(Instruction instruction) {
        String type;
        switch (type = instruction.getType().getRaw()) {
            case "4": 
            case "5": 
            case "12": 
            case "13": {
                return true;
            }
        }
        return false;
    }

    protected void queryBasketItems(Instruction instruction) {
        try {
            this.model.queryBasketItems(instruction);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                this.logger.error("\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            });
        }
    }

    protected void queryAdjItems(Instruction instruction) {
        try {
            this.model.queryAdjItems(instruction);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u8c03\u4ed3\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                this.logger.error("\u67e5\u8be2\u8c03\u4ed3\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            });
        }
    }

    protected void reject(Instruction instruction, int actionId) {
        this.selectRow(instruction);
        try {
            InstructionPostilDialog obj = (InstructionPostilDialog)((Object)this.of.create(InstructionPostilDialog.class));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u9a73\u56de");
            ButtonType bt = dialog.launch();
            if (bt.equals(ButtonType.OK)) {
                this.model.reject(instruction, actionId, obj.getPostil());
            }
        }
        catch (MException e) {
            this.logger.error(String.valueOf(instruction.getId()) + "\u9a73\u56de\u5931\u8d25", (Throwable)e);
        }
    }

    protected void audit(Instruction instruction, int actionId) {
        this.selectRow(instruction);
        InstructionAuditDialog obj = (InstructionAuditDialog)((Object)this.of.create(InstructionAuditDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u5ba1\u6279");
        dialog.getButton(ButtonType.OK).setVisible(false);
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        obj.setOk(dialog.getButton(ButtonType.OK));
        obj.setCancel(dialog.getButton(ButtonType.CANCEL));
        obj.setInstruction(instruction);
        ButtonType bt = dialog.launch();
        if (bt.equals(ButtonType.OK)) {
            try {
                this.model.approve(instruction, actionId, obj.getPostil());
            }
            catch (MException mException) {
                this.alert.alert(Alert.AlertType.ERROR, "\u5ba1\u6279\u5931\u8d25");
            }
        }
    }

    protected void selectRow(Instruction instruction) {
        this.tableInstruction.getSelectionModel().select((Object)instruction);
    }

    protected void cancel(Instruction instruction, int actionId) {
        this.selectRow(instruction);
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500", "\u6307\u4ee4\u64a4\u9500")) {
                this.model.cancel(instruction, actionId, "");
            }
        }
        catch (MException e) {
            this.logger.error(String.valueOf(instruction.getId()) + "\u6307\u4ee4\u64a4\u9500\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
        }
    }

    protected ReadOnlyObjectWrapper<Object> setDetail(Instruction instruction) {
        HBox box = new HBox(){

            public String toString() {
                return "\u8be6\u60c5";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button detail = new Button("\u8be6\u60c5");
        detail.getStyleClass().add((Object)"btnOperation");
        detail.setOnAction(event -> this.showDetail(instruction));
        box.getChildren().addAll((Object[])new Node[]{detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    protected void showDetail(Instruction instruction) {
        this.selectRow(instruction);
        this.logger.info("instruction showDetail\u6307\u4ee4\u8be6\u60c5" + instruction.getId() + "|" + instruction.getStatus() + "|" + instruction.getResource().getId());
        if (this.isBasket(instruction) && instruction.getBasketOrderAdvice() != null) {
            this.queryBasketItems(instruction);
        }
        InstructDialog obj = (InstructDialog)((Object)this.of.create(InstructDialog.class));
        obj.setInstruction(instruction);
        obj.setInstructionPartId(this.p.getParent().getParent().getId().toUpperCase());
        obj.setType(1);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected void checkAuth() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String hotkeyLabel = "";
        String cancelAllOrd = "";
        switch (parentId) {
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-INSTRUCT-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.regular.instruct.query_hotkey_approve";
                cancelAllOrd = "cms.tmx.instructions.part.regular.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-INSTRUCT-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.portfolio.instruct.query.hotkey.approve";
                cancelAllOrd = "cms.tmx.instructions.part.portfolio.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-BASKET-INSTRUCTION-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.basket.instruction.query_hotkey_approve";
                cancelAllOrd = "cms.tmx.instructions.part.basket.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-INSTRUCTION-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.portfolio.basket.instruction.query_hotkey_approve";
                cancelAllOrd = "cms.tmx.instructions.part.portfolio.basket.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-CCS-ADJ-INSTRUCTION-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.ccs.adj.instruction.query_hotkey_approve";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORT-ADJ-INSTRUCTION-QUERY": {
                hotkeyLabel = "cms.tmx.instructions.part.port.adj.instruction.query_hotkey_approve";
                break;
            }
            case "CMS-TMX-BLOCK-PART-INSTRUCT-QUERY": {
                hotkeyLabel = "cms.tmx.block.part.instruct.query_hotkey_approve";
                break;
            }
            case "CMS-TMX-FUTURE-INSTRUCTIONS-PART-INSTRUCT-QUERY": {
                hotkeyLabel = "cms.tmx.future.instructions.part.instruct.query_hotkey_approve";
                break;
            }
        }
        if (hotkeyLabel != null && this.rightsModel.registerCheck((Control)this.lbApprHotkey, new String[]{hotkeyLabel})) {
            this.initHotkey();
        }
        if (cancelAllOrd != null) {
            this.cancelAllOrder = this.rightsModel.registerCheck(new String[]{cancelAllOrd});
        }
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    public void setLstnCheckbox(ChangeListener<? super Boolean> lstnCheckbox) {
        this.lstnCheckbox = lstnCheckbox;
    }

    public void doSet() {
        if (this.funcPanelType == null || this.menuId == null) {
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CcsTradeSettings) {
                this.setFairStatus(((CcsTradeSettings)CcsTradeSettings.class.cast(settings)).getEventBargain().equals("1"));
            }
        }
        catch (MException e) {
            this.logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25,\u8bbe\u7f6e\u516c\u5e73\u4ea4\u6613\u5f00\u5173\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean isFairStatus() {
        return this.fairStatus;
    }

    public void setFairStatus(boolean fairStatus) {
        this.fairStatus = fairStatus;
    }

    private class AvgPriceCell
    extends DoubleTableCell<Instruction> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<Instruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        Instruction inst = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                        inst.setApprManualSelected(true);
                    });
                    this.disableProperty().bind((ObservableValue)ins.isApproveStepProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = new RefItem();
                refItem = "SHSC".equals(posi.getMarket()) || "SZSC".equals(posi.getMarket()) ? InstructionQueryPart.this.refMng.getItem(String.valueOf(posi.getSecurityType()) + posi.getMarket(), posi.getMarket(), posi.getSecurityCode()) : InstructionQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

