/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.OtcOrderDetail;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.InstructionOtcFundBaseClass;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionOtcFundDialog
extends DialogObj {
    @FXML
    private TableView<InstructionOtcFundBaseClass> tableItems;
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colPortfolio;
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colCode;
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colCounterParty;
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colSide;
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, Number> colRedeemQty = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colContractId = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colTradeDate = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, Number> colConfirmBonusAmt = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colBonusDate = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colType = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, Number> colAppliedBuyAmt = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colRedeemDate = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colBuyTradeDate = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, Number> colConfirmProvistonAmt = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colProvistonDate = new TableColumn();
    @FXML
    private TableColumn<InstructionOtcFundBaseClass, String> colProvistonType = new TableColumn();
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @FXML
    private HBox hboxPostil;
    @FXML
    private TextArea txtaPostil;
    @Inject
    private MObjFactory of;
    private ObservableList<InstructionOtcFundBaseClass> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    private InstructionOtcFundBaseClass fundBaseClass = new InstructionOtcFundBaseClass();

    @FXML
    public void initialize() {
        this.createTable();
    }

    protected void createTable() {
        MxNodeFactory.create((String)"market_code", (String)"");
        this.colCode.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getCode()));
        this.colCounterParty.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getCounterParty()));
        this.colPortfolio.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getPortfolio()));
        this.colSide.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getSide()));
        this.colRedeemQty.setCellValueFactory(data -> new SimpleDoubleProperty(((InstructionOtcFundBaseClass)data.getValue()).getRedeemQty()));
        this.colRedeemQty.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colContractId.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getContractId()));
        this.colTradeDate.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getRedeemDate()));
        this.colConfirmBonusAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((InstructionOtcFundBaseClass)data.getValue()).getConfirmedBuyAmt()));
        this.colConfirmBonusAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colBonusDate.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getBonusDate()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getBonusType()));
        this.colAppliedBuyAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((InstructionOtcFundBaseClass)data.getValue()).getAppliedBuyAmt()));
        this.colAppliedBuyAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
        this.colBuyTradeDate.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getTradeDate()));
        this.colRedeemDate.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getRedeemDate()));
        this.colConfirmProvistonAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((InstructionOtcFundBaseClass)data.getValue()).getConfirmedBuyAmt()));
        this.colProvistonDate.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getBonusDate()));
        this.colProvistonType.setCellValueFactory(data -> new SimpleStringProperty(((InstructionOtcFundBaseClass)data.getValue()).getBonusType()));
        switch (this.fundBaseClass.getSide()) {
            case "73": {
                this.colConfirmBonusAmt.setVisible(true);
                this.colBonusDate.setVisible(true);
                this.colType.setVisible(true);
                this.colConfirmBonusAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
                this.fundBaseClass.setSide("\u5206\u7d05");
                break;
            }
            case "74": {
                this.colConfirmBonusAmt.setVisible(true);
                this.colBonusDate.setVisible(true);
                this.colType.setVisible(true);
                this.colConfirmBonusAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
                this.fundBaseClass.setSide("\u5206\u7d05");
                break;
            }
            case "69": {
                this.colContractId.setVisible(true);
                this.colRedeemQty.setVisible(true);
                this.colTradeDate.setVisible(true);
                this.fundBaseClass.setSide("\u8d4e\u56de");
                break;
            }
            case "72": {
                this.colAppliedBuyAmt.setVisible(true);
                this.colBuyTradeDate.setVisible(true);
                this.colRedeemDate.setVisible(true);
                this.fundBaseClass.setSide("\u7533\u8d2d");
                break;
            }
            case "68": {
                this.colAppliedBuyAmt.setVisible(true);
                this.colBuyTradeDate.setVisible(true);
                this.colRedeemDate.setVisible(true);
                this.fundBaseClass.setSide("\u8ba4\u8d2d");
                break;
            }
            case "136": {
                this.colContractId.setVisible(true);
                this.colContractId.setText("\u8f6c\u6362\u5408\u7ea6");
                this.colRedeemQty.setVisible(true);
                this.colRedeemQty.setText("\u8f6c\u6362\u4efd\u989d");
                this.colTradeDate.setVisible(true);
                this.fundBaseClass.setSide("\u8f6c\u6362");
                break;
            }
            case "141": {
                this.colConfirmProvistonAmt.setVisible(true);
                this.colProvistonDate.setVisible(true);
                this.colProvistonType.setVisible(true);
                this.colCounterParty.setVisible(false);
                this.colConfirmProvistonAmt.setCellFactory(cell -> new ZeroDoubleTableCell(2));
                this.fundBaseClass.setSide("\u4e1a\u7ee9\u8ba1\u63d0");
                break;
            }
        }
        this.tableItems.setItems(this.list);
        this.tableItems.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableItems);
    }

    public void setDialog(NewInstructionReq newInsReq) {
        Instruction instruction = newInsReq.getInstruction();
        OtcOrderDetail detail = (OtcOrderDetail)instruction.getDetail();
        Instrument instrument = detail.getInstrument();
        double orderAmount = ((AccntSecInfo)detail.getAccntSecInfo().get(0)).getOrderAmount();
        double orderQty = ((AccntSecInfo)detail.getAccntSecInfo().get(0)).getOrderQty();
        switch (detail.getSide()) {
            case "73": 
            case "SIDE_CASH_DIVIDEND": {
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("73");
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setTradeDate(detail.getTradeDate());
                this.fundBaseClass.setConfirmedBuyAmt(orderAmount);
                this.fundBaseClass.setBonusType("\u73b0\u91d1\u5206\u7ea2");
                this.fundBaseClass.setBonusDate(detail.getTradeDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "74": 
            case "SIDE_DIVIDEND_REINVEST": {
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("74");
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setConfirmedBuyAmt(orderQty);
                this.fundBaseClass.setBonusType("\u7ea2\u5229\u518d\u6295\u8d44");
                this.fundBaseClass.setBonusDate(detail.getTradeDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "SIDE_REDEEM": 
            case "69": {
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("69");
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setRedeemQty(orderQty);
                this.fundBaseClass.setTradeDate(detail.getTradeDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "SIDE_CREATION": 
            case "72": {
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("72");
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setAppliedBuyAmt(orderAmount);
                this.fundBaseClass.setTradeDate(detail.getTradeDate());
                this.fundBaseClass.setRedeemDate(detail.getContractExpireDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "SIDE_SUBSCRIBE": 
            case "68": {
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("68");
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setAppliedBuyAmt(orderAmount);
                this.fundBaseClass.setTradeDate(detail.getTradeDate());
                this.fundBaseClass.setRedeemDate(detail.getContractExpireDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "136": 
            case "SIDE_TRANSFER": {
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("136");
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setCounterParty(detail.getCounterPartyName());
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setRedeemQty(orderQty);
                this.fundBaseClass.setTradeDate(detail.getTradeDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
            case "SIDE_PROVISTON": 
            case "141": {
                this.fundBaseClass.setPortfolio(instruction.getPortfolioName());
                this.fundBaseClass.setCode(instrument.getSecurityId());
                this.fundBaseClass.setSide("141");
                this.fundBaseClass.setAccount(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                this.fundBaseClass.setSecAcct(((AccntSecInfo)detail.getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
                this.fundBaseClass.setBonusType("\u63d0\u53d6\u4efd\u989d");
                this.fundBaseClass.setConfirmedBuyAmt(orderQty);
                this.fundBaseClass.setBonusDate(detail.getTradeDate());
                this.list.add((Object)this.fundBaseClass);
                break;
            }
        }
    }

    public InstructionOtcFundBaseClass getFundBaseClass() {
        return this.fundBaseClass;
    }

    public void setFundBaseClass(InstructionOtcFundBaseClass fundBaseClass) {
        this.fundBaseClass = fundBaseClass;
    }
}

