/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.InstructionNeeqOrderModel;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionNeeqOrderPart
extends MxPart {
    @FXML
    protected TableView<ObSingleOrderNeeq> tableOrder;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloSecId;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloSecName;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> coloSide;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloOrdTime;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloOrdDate;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloOrdStatus;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloMarket;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloUnit;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloOrderId;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloAccId;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloSecAcc;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloPrice;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloOrderQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> colFrozenAmt;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloOrderAmt;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloDoneVol;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloPercent;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> coloAvgPrice;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloInfo;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> coloUser;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> colPortfolioId;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> colPortfolioName;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> colReference;
    @FXML
    protected Label labCount;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected InstructionNeeqOrderModel orderModel;
    @Inject
    private MxAlert alert;
    protected int count;
    protected MxList<ObSingleOrderNeeq> orderMxList = new MxList();
    protected ObSimpleInstruction instruction;
    private InvalidationListener lstnOrderModel = ob -> this.lstnOrder();

    @FXML
    public void initialize() {
        this.listener();
        this.createOrderTable();
        this.refreshOrder();
        this.initValue();
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    protected void initValue() {
        this.labCount.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labCount);
    }

    @PreDestroy
    public void close() {
        this.orderModel.changedProperty().removeListener(this.lstnOrderModel);
    }

    protected void listener() {
        this.orderModel.changedProperty().addListener(this.lstnOrderModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lstnOrder() {
        List<ObSingleOrderNeeq> newList = Collections.synchronizedList(new ArrayList());
        List<ObSingleOrderNeeq> list = this.orderModel.getList();
        synchronized (list) {
            newList.addAll(this.orderModel.getList());
        }
        Platform.runLater(() -> {
            this.count = 0;
            for (ObSingleOrderNeeq order : newList) {
                if (!order.isCanCancel()) continue;
                ++this.count;
            }
            StringBuilder string = new StringBuilder();
            if ("kStatusCanceled".equals(this.instruction.getStatus()) && this.count != 0) {
                string.append("\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u8fd8\u6709").append(this.count).append("\u7b14\u9700\u8981\u624b\u5de5\u64a4\u5355\u3002");
            }
            this.labCount.setText(string.toString());
            this.orderMxList.update(newList);
            Collections.sort(this.orderMxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.sort();
            this.tableOrder.refresh();
        });
    }

    @FXML
    public void copyOrder() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void refreshOrder() {
        if (this.instruction == null) {
            return;
        }
        this.orderModel.setInstruction(this.instruction);
        try {
            if ("".equals(this.instruction.getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u6307\u4ee4ID\u4e3a\u7a7a");
            }
            this.orderModel.query(this.instruction);
        }
        catch (MException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportOrder() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u660e\u7ec6");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createOrderTable() {
        this.coloSecId.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).securityIdProperty());
        this.coloSecName.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).securityNameProperty());
        this.coloSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObSingleOrderNeeq)data.getValue()).getSide()));
        this.coloSide.setCellFactory(data -> new SideCell());
        this.coloPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getPrice()));
        this.coloPrice.setCellFactory(p -> new PriceCell());
        this.coloOrderQty.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getOrderQty()));
        this.coloOrderQty.setCellFactory(cell -> new DoubleTableCell());
        this.coloOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getOrderAmount()));
        this.coloOrderAmt.setCellFactory(p -> new DoubleTableCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new DoubleTableCell());
        this.coloDoneVol.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getCumQty()));
        this.coloDoneVol.setCellFactory(cell -> new DoubleTableCell());
        this.coloPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getDonePercent()));
        this.coloPercent.setCellFactory(data -> new DoubleTableCell());
        this.coloAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((ObSingleOrderNeeq)data.getValue()).getAvgPx()));
        this.coloAvgPrice.setCellFactory(p -> new DoubleTableCell());
        this.coloOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getOrdTime()));
        this.coloOrdDate.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getOrdDate()));
        this.coloOrdStatus.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getStatus()));
        this.coloMarket.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).marketProperty());
        this.coloUnit.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getUnit()));
        this.coloOrderId.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getExtOrderId()));
        this.coloAccId.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getInvestorId()));
        this.coloSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getInvestorSecId()));
        this.coloInfo.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getErrInfo()));
        this.coloInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.coloUser.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getUserId()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getReference()));
        this.tableOrder.setItems(this.orderMxList.getList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        this.coloOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.coloOrdTime);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    private class AvgPriceCell
    extends DoubleTableCell<ObSingleOrderNeeq> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderNeeq order = (ObSingleOrderNeeq)ObSingleOrderNeeq.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionNeeqOrderPart.this.refMng.getItem(order.getSecType(), order.getMarket(), order.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                if (item.doubleValue() != 0.0) {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                } else {
                    this.setText(null);
                }
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<ObSingleOrderNeeq> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderNeeq order = (ObSingleOrderNeeq)ObSingleOrderNeeq.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionNeeqOrderPart.this.refMng.getItem(order.getSecType(), order.getMarket(), order.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() != 0.0) {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                } else {
                    this.setText(null);
                }
            }
        }
    }
}

