/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.ObWorkflowLog;
import cms.tmx.entity.web.workflow.Result;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.otc.models.OtcFundWorkflowLogModel;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionNeeqLogPart
extends MxPart {
    protected ObSimpleInstruction instruction;
    @FXML
    private TableView<ObWorkflowLog> tableLog;
    @FXML
    private TableColumn<ObWorkflowLog, String> colWorkflowId;
    @FXML
    private TableColumn<ObWorkflowLog, String> colStartTime;
    @FXML
    private TableColumn<ObWorkflowLog, String> colNodeName;
    @FXML
    private TableColumn<ObWorkflowLog, Result> colOpReault;
    @FXML
    private TableColumn<ObWorkflowLog, String> colOpUser;
    @FXML
    private TableColumn<ObWorkflowLog, String> colOpTime;
    @Inject
    private OtcFundWorkflowLogModel logModel;
    private MxList<ObWorkflowLog> logMxList = new MxList();
    private static final Logger logger = LogManager.getLogger(InstructionNeeqLogPart.class);
    @Inject
    protected MxAlert alert;
    private InvalidationListener lstnLogModel = ob -> Platform.runLater(() -> {
        this.logMxList.update(this.logModel.getList());
        this.tableLog.sort();
    });

    @FXML
    public void initialize() {
        this.listener();
        this.createLogTable();
        this.refreshLog();
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    protected void listener() {
        this.logModel.changedProperty().addListener(this.lstnLogModel);
    }

    @PreDestroy
    public void close() {
        this.logModel.changedProperty().removeListener(this.lstnLogModel);
    }

    @FXML
    public void copyLog() {
        TableUtils.copyContentWithHead(this.tableLog);
    }

    @FXML
    public void refreshLog() {
        if (this.instruction == null) {
            return;
        }
        this.logModel.setEntryId(this.instruction.getEntryId());
        try {
            if (StringUtils.isEmpty((String)this.instruction.getEntryId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u6307\u4ee4\u6d41\u7a0bID\u4e3a\u7a7a");
            }
            this.logModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportLog() {
        try {
            ExcelUtils.writeExcel(this.tableLog, (String)"\u5ba1\u6279\u65e5\u5fd7");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createLogTable() {
        this.colWorkflowId.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).workflowIdProperty());
        this.colStartTime.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).startTimeProperty());
        this.colNodeName.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).nodeNameProperty());
        this.colOpReault.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).resultProperty());
        this.colOpUser.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).opUserProperty());
        this.colOpTime.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).opTimeProperty());
        this.tableLog.setItems(this.logMxList.getList());
        this.tableLog.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableLog);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }
}

