/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.instruction.dto.ObLegDetail;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.InstructionNeeqDealModel;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionNeeqDealPart
extends MxPart {
    protected ObSimpleInstruction instruction;
    @FXML
    protected TableView<ObLegDetail> tableExecution;
    @FXML
    private TableColumn<ObLegDetail, String> coleInstructId;
    @FXML
    private TableColumn<ObLegDetail, String> coleSecId;
    @FXML
    private TableColumn<ObLegDetail, String> coleSecName;
    @FXML
    private TableColumn<ObLegDetail, MxNode> coleMarket;
    @FXML
    private TableColumn<ObLegDetail, String> coleType;
    @FXML
    private TableColumn<ObLegDetail, MxNode> coleSide;
    @FXML
    private TableColumn<ObLegDetail, Number> coleOrderAmount;
    @FXML
    private TableColumn<ObLegDetail, Number> coleExpectQty;
    @FXML
    private TableColumn<ObLegDetail, Number> colePriceLmt;
    @FXML
    private TableColumn<ObLegDetail, Number> coleDoneQty;
    @FXML
    private TableColumn<ObLegDetail, Number> colePercent;
    @FXML
    private TableColumn<ObLegDetail, String> coleRiskInfo;
    @FXML
    private TableColumn<ObLegDetail, String> coleFrozenInfo;
    @FXML
    private TableColumn<ObLegDetail, Number> coleCumAmount;
    @FXML
    private TableColumn<ObLegDetail, Number> coleAvgPx;
    @FXML
    private Label labExecution;
    @Inject
    protected InstructionNeeqDealModel executionModel;
    private double qty;
    private double amount;
    private MxList<ObLegDetail> execuMxList = new MxList();
    protected static final Logger logger = LogManager.getLogger(InstructionNeeqDealPart.class);
    @Inject
    protected MxAlert alert;
    private InvalidationListener lstnProgressModel = ob -> {
        ArrayList<ObLegDetail> list = new ArrayList<ObLegDetail>();
        List<ObLegDetail> list2 = this.executionModel.getList();
        synchronized (list2) {
            list.addAll(this.executionModel.getList());
        }
        Platform.runLater(() -> {
            int size = list.size();
            this.qty = 0.0;
            this.amount = 0.0;
            list.forEach(each -> {
                this.qty += each.getOrderQty();
                this.amount += each.getOrderAmount();
            });
            StringBuilder string = new StringBuilder();
            if (size > 0) {
                string.append("\u5171\u8ba1").append(size).append("\u53ea\u6210\u5206\u80a1\uff0c\u603b\u59d4\u6258\u6570\u91cf").append(StringUtils.toThousands((Number)this.qty, (int)2)).append("\uff0c\u603b\u9884\u4f30\u59d4\u6258\u91d1\u989d\u4e3a").append(StringUtils.toThousands((Number)this.amount, (int)2));
            }
            this.labExecution.setText(string.toString());
            this.execuMxList.update(list);
            this.tableExecution.sort();
        });
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createExecutionTable();
        this.refreshExecution();
        this.initValue();
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    protected void initValue() {
        this.labExecution.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labExecution);
    }

    protected void listener() {
        this.executionModel.changedProperty().addListener(this.lstnProgressModel);
    }

    @PreDestroy
    public void close() {
        this.executionModel.changedProperty().removeListener(this.lstnProgressModel);
    }

    @FXML
    public void copyExecution() {
        TableUtils.copyContentWithHead(this.tableExecution);
    }

    @FXML
    public void refreshExecution() {
        if (this.instruction == null) {
            return;
        }
        this.executionModel.setInstruction(this.instruction);
        try {
            if (StringUtils.isEmpty((String)this.instruction.getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u6307\u4ee4ID\u4e3a\u7a7a");
            }
            this.executionModel.query();
        }
        catch (MException mException) {
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportExecution() {
        try {
            ExcelUtils.writeExcel(this.tableExecution, (String)"\u6267\u884c\u8fdb\u5ea6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createExecutionTable() {
        this.coleInstructId.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).instructionIdProperty());
        this.coleSecId.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).secIdProperty());
        this.coleSecName.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).secNameProperty());
        this.coleMarket.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).marketProperty());
        this.coleType.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).instructionTypeProperty());
        this.coleSide.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).sideProperty());
        this.coleSide.setCellFactory(data -> new SideCell());
        this.coleExpectQty.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).targetQtyProperty());
        this.coleExpectQty.setCellFactory(cell -> new DoubleTableCell());
        this.colePriceLmt.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).priceProperty());
        this.colePriceLmt.setCellFactory(cell -> new DoubleTableCell());
        this.coleDoneQty.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).cumQtyProperty());
        this.coleDoneQty.setCellFactory(cell -> new DoubleTableCell());
        this.colePercent.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).progressProperty());
        this.colePercent.setCellFactory(data -> new DoubleTableCell());
        this.coleOrderAmount.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).orderAmountProperty());
        this.coleOrderAmount.setCellFactory(data -> new DoubleTableCell());
        this.coleCumAmount.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).tradeAmountProperty());
        this.coleCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.coleAvgPx.setCellValueFactory(data -> ((ObLegDetail)data.getValue()).avgPxProperty());
        this.coleAvgPx.setCellFactory(cell -> new ExecAvgPriceCell());
        this.coleInstructId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableExecution.getSortOrder().add(this.coleInstructId);
        this.tableExecution.sort();
        this.tableExecution.setPlaceholder((Node)new Label());
        this.tableExecution.setItems(this.execuMxList.getList());
        TableUtils.orgnizeClmWidth(this.tableExecution);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    private class ExecAvgPriceCell
    extends DoubleTableCell<ObLegDetail> {
        int scale = 4;

        private ExecAvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

