/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.MailPosition;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.current.models.InstructionMailPositionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;

public class InstructionMailPositionPart
extends MxPagePart<MailPosition, MailPosition> {
    @FXML
    private TableView<MailPosition> tableView;
    @FXML
    private TableColumn<MailPosition, Number> marginRateFund;
    @FXML
    private TableColumn<MailPosition, Number> marginRateSec;
    @FXML
    protected TextField searchText;
    @Inject
    protected InstructionMailPositionModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;

    @FXML
    public void refresh() {
        this.exe.execute(() -> this.model.query());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listOrder, (String)"\u90ae\u4ef6\u6307\u4ee4\u6301\u4ed3\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected boolean predicate(MailPosition data) {
        String text = this.searchText.getText().trim();
        return data.getSecurityId().contains(text);
    }

    protected List<MailPosition> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getPageList());
    }

    public void defaultSort() {
    }
}

