/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class InstructionAuditDialog
extends DialogObj {
    @FXML
    private Button passBtn;
    @FXML
    private Button detailBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private TextArea textPostil;
    @Inject
    private EPartService eps;
    @Inject
    private MEventService es;
    private Instruction instruction;
    @Inject
    protected InstructionModel model;
    private Button ok;
    private Button cancel;

    @FXML
    public void initialize() {
        this.initialValues();
    }

    protected boolean isOK(ButtonType bt) {
        return true;
    }

    private void initialValues() {
        this.passBtn.setOnAction(e -> this.pass());
        this.detailBtn.setOnAction(e -> this.detail());
        this.cancelBtn.setOnAction(e -> this.cancel());
        Platform.runLater(() -> this.passBtn.requestFocus());
    }

    private void cancel() {
        this.cancel.fire();
    }

    private void detail() {
        this.sendEvent(this.instruction);
        this.cancel.fire();
    }

    private void pass() {
        this.ok.fire();
    }

    private void sendEvent(Instruction instruction) {
        MEvent eCall = new MEvent();
        if (instruction.isFinished()) {
            return;
        }
        MPart newPart = null;
        String type = instruction.getType().getRaw();
        if ("3".equals(type)) {
            boolean isHk = "SHSC".equals(instruction.getOrderAdvice().getMarket());
            boolean isOIS = "OIS".equals(instruction.getSecurityType());
            boolean isMail = instruction.getDescId() == WorkflowTemplete.MAIL.getId();
            String partId = "cms.tmx.instructions.part.portfolio.approve";
            if (isMail && !(isHk |= "SZSC".equals(instruction.getOrderAdvice().getMarket()))) {
                partId = "cms.tmx.instructions.part.portfolio.approve.mail";
            } else if (isMail && isHk) {
                partId = "cms.tmx.instructions.part.portfolio.hkwolun.approve.mail";
            } else if (isHk) {
                partId = "cms.tmx.instructions.part.portfolio.hkwolun.approve";
            } else if (isOIS) {
                partId = "cms.tmx.portfolio.newstock.part.instruction.approve";
            }
            newPart = this.eps.findPart(partId);
        } else if ("2".equals(type)) {
            if (instruction.getSecurityType().equals("OIS")) {
                newPart = this.eps.findPart("cms.tmx.newstock.part.instruction.approve");
            } else {
                boolean isHk = "SHSC".equals(instruction.getOrderAdvice().getMarket());
                String partId = "cms.tmx.instructions.part.regular.approve";
                if (isHk |= "SZSC".equals(instruction.getOrderAdvice().getMarket())) {
                    partId = "cms.tmx.instructions.part.hkwolun.approve";
                }
                newPart = this.eps.findPart(partId);
            }
        } else if (StringUtils.belongto((String)type, (String[])new String[]{"5", "13"})) {
            boolean isMail = instruction.getDescId() == WorkflowTemplete.MAIL.getId();
            newPart = isMail ? this.eps.findPart("cms.tmx.instructions.part.portfolio.basket.approve.mail") : this.eps.findPart("cms.tmx.instructions.part.portfolio.basket.approve");
            instruction.getBasketOrderAdvice().setItemList(this.model.getInsBasketItems(instruction.getId()));
        } else if (StringUtils.belongto((String)type, (String[])new String[]{"4", "12"})) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.basket.approve");
            instruction.getBasketOrderAdvice().setItemList(this.model.getInsBasketItems(instruction.getId()));
        } else if ("9".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.portfolio.approve");
        } else if ("8".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.regular.approve");
        } else if ("16".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.ccs.adj.approve");
            instruction.getAdjustPosAdvice().setItems(this.model.getInsAdjItems(instruction.getId()));
        } else if ("17".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.instructions.part.port.adj.approve");
            instruction.getAdjustPosAdvice().setItems(this.model.getInsAdjItems(instruction.getId()));
        } else if ("32".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.block.cp.up.left.part.approve");
        } else if ("34".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.block.cp.fixedIncome.up.left.part.approve");
        } else if ("64".equals(type)) {
            newPart = this.eps.findPart("cms.tmx.future.instructions.part.approve");
        }
        if (newPart != null) {
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    public Button getOk() {
        return this.ok;
    }

    public void setOk(Button ok) {
        this.ok = ok;
    }

    public Button getCancel() {
        return this.cancel;
    }

    public String getPostil() {
        return this.textPostil.getText();
    }

    public void setCancel(Button cancel) {
        this.cancel = cancel;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }
}

