/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.table.NumberTableCell;
import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.views.InstructDialog;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;

public class InstructShortDialog
extends InstructDialog {
    @FXML
    private Button cancel;
    private boolean showCancel;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbInsAmt;
    @FXML
    private Label lbInsBuyAmt;
    @FXML
    private Label lbInsSellAmt;
    @FXML
    private Label lbCumAmt;
    @FXML
    private Label lbCumBuyAmt;
    @FXML
    private Label lbCumSellAmt;
    @FXML
    private Label txtInstQty;
    @FXML
    private Label txtRate;
    @FXML
    private HBox hBoxVisible;
    @FXML
    private HBox hBoxCumVisible;
    @FXML
    protected Tab tabUnfinished;
    @FXML
    private TableColumn<InstructionExec, Number> coleOrderQty;
    @FXML
    private TableColumn<InstructionExec, MxNode> coleSide;
    private ChangeListener<Order> selectTable = (ob, old, now) -> {
        if (1 == this.type && now != null && now.isCanCancel()) {
            this.cancel.setDisable(false);
        } else {
            this.cancel.setDisable(true);
        }
    };
    private InvalidationListener lstnProgressModel = ob -> {
        ArrayList<InstructionExec> list = new ArrayList<InstructionExec>();
        ObservableList<InstructionExec> observableList = this.executionModel.getList();
        synchronized (observableList) {
            list.addAll((Collection<InstructionExec>)this.executionModel.getList());
        }
        Platform.runLater(() -> {
            int size = list.size();
            this.qty = 0L;
            this.amount = 0.0;
            list.forEach(each -> {
                this.qty += each.getExpectQty();
                this.amount += each.getOrderAmount();
            });
            StringBuilder string = new StringBuilder();
            if (size > 0) {
                string.append("\u5171\u8ba1").append(size).append("\u53ea\u6210\u5206\u80a1\uff0c\u603b\u59d4\u6258\u6570\u91cf").append(StringUtils.toThousands((Number)this.qty)).append("\uff0c\u603b\u9884\u4f30\u59d4\u6258\u91d1\u989d\u4e3a").append(StringUtils.toThousands((Number)this.amount, (int)2));
            }
            this.labExecution.setText(string.toString());
            this.execuMxList.update(list);
            this.sumNum((MxList<InstructionExec>)this.execuMxList);
            this.tableExecution.sort();
        });
    };

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.cancel.setDisable(true);
        this.refreshExec();
        this.executionModel.changedProperty().addListener(this.lstnProgressModel);
        this.createExecutionTable();
        this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
    }

    @Override
    protected void initValue() {
        super.initValue();
        if (this.showCancel) {
            this.tabOrder.setText("\u672a\u5b8c\u6210\u59d4\u6258\u660e\u7ec6");
        }
    }

    @Override
    public void onDlgClosed() {
        super.onDlgClosed();
        this.tableOrder.getSelectionModel().selectedItemProperty().addListener(this.selectTable);
    }

    @Override
    protected void listener() {
        super.listener();
        this.tableOrder.getSelectionModel().selectedItemProperty().addListener(this.selectTable);
        this.tableOrder.setOnKeyPressed(event -> {
            Order order = (Order)this.tableOrder.getSelectionModel().getSelectedItem();
            KeyCode code = event.getCode();
            if (KeyCode.W == code && 1 == this.type && order != null && order.isCanCancel() && this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u5355")) {
                this.orderCancel();
            }
        });
        this.cancel.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.W == event.getCode() || KeyCode.ENTER == event.getCode()) {
                this.orderCancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lstnOrder() {
        List<Order> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<Order> observableList = this.orderModel.getList();
        synchronized (observableList) {
            if (this.showCancel) {
                for (Order order : this.orderModel.getList()) {
                    if (!order.isCanCancel()) continue;
                    newList.add(order);
                }
            } else {
                newList.addAll((Collection<Order>)this.orderModel.getList());
            }
        }
        Platform.runLater(() -> {
            this.count = 0;
            for (Order order : newList) {
                if (!order.isCanCancel()) continue;
                ++this.count;
            }
            StringBuilder string = new StringBuilder();
            if (1 == this.type && "61".equals(this.instruction.getResource().getStatus()) && this.count != 0) {
                string.append("\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u8fd8\u6709").append(this.count).append("\u7b14\u9700\u8981\u624b\u5de5\u64a4\u5355\u3002");
            }
            this.labCount.setText(string.toString());
            this.orderMxList.update(newList);
            Collections.sort(this.orderMxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.sort();
            this.tableOrder.refresh();
            Order order = (Order)this.tableOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                this.tableOrder.requestFocus();
                this.tableOrder.getSelectionModel().selectFirst();
                order = (Order)this.tableOrder.getSelectionModel().getSelectedItem();
            }
            if (1 == this.type && order != null && order.isCanCancel()) {
                this.cancel.setDisable(false);
            } else {
                this.cancel.setDisable(true);
            }
        });
    }

    @FXML
    public void orderCancel() {
        if (2 == this.type) {
            return;
        }
        Order order = (Order)this.tableOrder.getSelectionModel().getSelectedItem();
        MEvent event = null;
        if (order instanceof CcsOrder) {
            List<CcsOrder> list = Arrays.asList((CcsOrder)CcsOrder.class.cast(order));
            event = this.ccsUnfinishedOodel.cancel(list);
        } else if (order instanceof CtpOrder) {
            List<CtpOrder> list = Arrays.asList((CtpOrder)CtpOrder.class.cast(order));
            event = this.ctpUnfinishedOodel.cancel(list);
        }
        if (event != null) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
        }
    }

    @Override
    public void createExecutionTable() {
        super.createExecutionTable();
        this.coleOrderQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).orderQtyProperty());
        this.coleOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.coleSide.setCellValueFactory(data -> ((InstructionExec)data.getValue()).sideProperty());
        this.tableExecution.getColumns().remove((Object)this.coleOrdAmount);
        this.tableExecution.getColumns().remove((Object)this.coleOrdRate);
    }

    @Override
    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CLOSE};
    }

    InstructShortDialog() {
        this.fxml = String.valueOf(InstructShortDialog.class.getSimpleName()) + ".fxml";
    }

    public boolean isShowCancel() {
        return this.showCancel;
    }

    public void setShowCancel(boolean showCancel) {
        this.showCancel = showCancel;
    }

    public void refreshExec() {
        if ("".equals(this.instruction.getResource().getId())) {
            return;
        }
        this.executionModel.query();
    }

    public void sumNum(MxList<InstructionExec> execuMxList) {
        double insAmt = 0.0;
        double insBuyAmt = 0.0;
        double insSellAmt = 0.0;
        double cumAmt = 0.0;
        double cumBuyAmt = 0.0;
        double cumSellAmt = 0.0;
        if (!("4".equals(((InstructionExec)execuMxList.getList().get(0)).getInstructionType().getRaw()) || "5".equals(((InstructionExec)execuMxList.getList().get(0)).getInstructionType().getRaw()) || "12".equals(((InstructionExec)execuMxList.getList().get(0)).getInstructionType().getRaw()) || "13".equals(((InstructionExec)execuMxList.getList().get(0)).getInstructionType().getRaw()))) {
            this.lbNum.setVisible(false);
            this.lbInsAmt.setVisible(false);
            this.lbCumAmt.setVisible(false);
            this.lbInsBuyAmt.setVisible(false);
            this.lbInsSellAmt.setVisible(false);
            this.lbCumBuyAmt.setVisible(false);
            this.lbCumSellAmt.setVisible(false);
            this.lbRate.setVisible(false);
            this.hBoxVisible.setVisible(false);
            this.hBoxCumVisible.setVisible(false);
            this.txtRate.setVisible(false);
            this.txtInstQty.setVisible(false);
            return;
        }
        for (InstructionExec exec : execuMxList.getList()) {
            insAmt += exec.getOrderAmount();
            cumAmt += exec.getCumAmount();
            if ("49".equals(exec.getSide().getRaw())) {
                insBuyAmt += exec.getOrderAmount();
                cumBuyAmt += exec.getCumAmount();
            }
            if (!"50".equals(exec.getSide().getRaw())) continue;
            insSellAmt += exec.getOrderAmount();
            cumSellAmt += exec.getCumAmount();
        }
        this.lbNum.setText(StringUtils.toThousands((Number)execuMxList.getList().size()));
        this.lbInsAmt.setText(StringUtils.toThousands((Number)insAmt, (int)2));
        this.lbCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbInsBuyAmt.setText(StringUtils.toThousands((Number)insBuyAmt, (int)2));
        this.lbInsSellAmt.setText(StringUtils.toThousands((Number)insSellAmt, (int)2));
        this.lbCumBuyAmt.setText(StringUtils.toThousands((Number)cumBuyAmt, (int)2));
        this.lbCumSellAmt.setText(StringUtils.toThousands((Number)cumSellAmt, (int)2));
        this.lbRate.setText(StringUtils.toThousands((Number)(insAmt == 0.0 ? 0.0 : cumAmt / insAmt * 100.0)));
    }
}

