/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.entity.trade.instruction.InstructionLog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.query.current.models.InstructExecModel;
import cms.tmx.query.current.models.InstructLogModel;
import cms.tmx.query.current.models.InstructionBlockOrderModel;
import cms.tmx.query.current.models.InstructionOrderModel;
import cms.tmx.query.current.views.InstructionUnfinishedOrderPart;
import cms.tmx.query.current.views.portfolio.InstructionAlgoQueryPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructDialog
extends DialogObj {
    protected Instruction instruction;
    private String instructionPartId = "";
    protected int type;
    private String marketGrp;
    @FXML
    protected TabPane tabPaneIns;
    @FXML
    private Tab tabBlockOrder;
    @FXML
    protected Tab tabOrder;
    @FXML
    protected Tab tabUnfinished;
    @FXML
    protected Tab tabExecution;
    @FXML
    protected Tab tabAlgo;
    @FXML
    protected TableView<Order> tableOrder;
    @FXML
    private TableColumn<Order, String> coloSecId;
    @FXML
    private TableColumn<Order, String> coloSecName;
    @FXML
    private TableColumn<Order, MxNode> coloSide;
    @FXML
    private TableColumn<CtpOrder, MxNode> coloOcFlag;
    @FXML
    private TableColumn<Order, String> coloOrdTime;
    @FXML
    private TableColumn<Order, String> coloOrdDate;
    @FXML
    private TableColumn<Order, MxNode> coloOrdStatus;
    @FXML
    private TableColumn<Order, MxNode> coloMarket;
    @FXML
    private TableColumn<Order, String> coloUnit;
    @FXML
    private TableColumn<Order, String> coloOrderId;
    @FXML
    private TableColumn<Order, String> coloAccId;
    @FXML
    private TableColumn<Order, String> coloSecAcc;
    @FXML
    private TableColumn<Order, Number> coloPrice;
    @FXML
    private TableColumn<Order, Number> coloOrderQty;
    @FXML
    private TableColumn<Order, Number> colFrozenAmt;
    @FXML
    private TableColumn<Order, Number> coloOrderAmt;
    @FXML
    private TableColumn<Order, Number> coloDoneVol;
    @FXML
    private TableColumn<Order, Number> coloPercent;
    @FXML
    private TableColumn<Order, Number> coloAvgPrice;
    @FXML
    private TableColumn<Order, String> coloInfo;
    @FXML
    private TableColumn<Order, String> coloUser;
    @FXML
    private TableColumn<Order, String> colPortfolioId;
    @FXML
    private TableColumn<Order, String> colPortfolioName;
    @FXML
    private TableColumn<Order, String> colReference;
    @FXML
    protected TableView<InstructionExec> tableExecution;
    @FXML
    private TableColumn<InstructionExec, String> coleInstructNo;
    @FXML
    private TableColumn<InstructionExec, String> coleSecId;
    @FXML
    private TableColumn<InstructionExec, String> coleSecName;
    @FXML
    private TableColumn<InstructionExec, MxNode> coleMarket;
    @FXML
    private TableColumn<InstructionExec, MxNode> coleType;
    @FXML
    private TableColumn<InstructionExec, MxNode> coleSide;
    @FXML
    private TableColumn<InstructionExec, Number> coleOrderAmount;
    @FXML
    protected TableColumn<InstructionExec, Number> coleOrdAmount;
    @FXML
    protected TableColumn<InstructionExec, Number> coleOrdRate;
    @FXML
    private TableColumn<InstructionExec, Number> coleExpectQty;
    @FXML
    private TableColumn<InstructionExec, Number> colePriceLmt;
    @FXML
    private TableColumn<InstructionExec, Number> coleDoneQty;
    @FXML
    private TableColumn<InstructionExec, Number> colePercent;
    @FXML
    private TableColumn<InstructionExec, String> coleRiskInfo;
    @FXML
    private TableColumn<InstructionExec, String> coleFrozenInfo;
    @FXML
    private TableColumn<InstructionExec, Number> coleCumAmount;
    @FXML
    private TableColumn<InstructionExec, Number> coleAvgPx;
    @FXML
    private TableView<InstructionLog> tableLog;
    @FXML
    private TableColumn<InstructionLog, String> colgInstructNo;
    @FXML
    private TableColumn<InstructionLog, String> colDescName;
    @FXML
    private TableColumn<InstructionLog, String> colRole;
    @FXML
    private TableColumn<InstructionLog, String> colUserName;
    @FXML
    private TableColumn<InstructionLog, String> colOperateType;
    @FXML
    private TableColumn<InstructionLog, String> colTime;
    @FXML
    private TableColumn<InstructionLog, String> colIp;
    @FXML
    private TableColumn<InstructionLog, String> colMac;
    @FXML
    private TableColumn<InstructionLog, String> colgInfo;
    @FXML
    protected TableView<BlockOrder> tableBlockOrder;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockSecId;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockSecName;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colBlockSide;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colBlockType;
    @FXML
    protected TableColumn<BlockOrder, Number> colBlockPrice;
    @FXML
    protected TableColumn<BlockOrder, Number> colBlockOrderQty;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockUnit;
    @FXML
    protected TableColumn<BlockOrder, Number> colBlockDoneVol;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colBlockOrdStatus;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockOrderId;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockOrdTime;
    @FXML
    protected TableColumn<BlockOrder, MxNode> colBlockMarket;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockAccId;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockSecAcc;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockSysTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockOurTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockContractNo;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockOppositeTradingUnit;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockOppositeTrader;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockContact;
    @FXML
    protected TableColumn<BlockOrder, String> colBlockRemark;
    @Inject
    private InstructionBlockOrderModel blockModel;
    @FXML
    protected Label labCount;
    @FXML
    protected Label labExecution;
    @FXML
    private Label labBlockCount;
    @Inject
    protected CcsUnfinishedOrderModel ccsUnfinishedOodel;
    @Inject
    protected CtpUnfinishedOrderModel ctpUnfinishedOodel;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected InstructionOrderModel orderModel;
    @Inject
    protected InstructExecModel executionModel;
    @Inject
    private InstructLogModel logModel;
    protected int count;
    private int blockCount;
    protected long qty;
    protected double amount;
    protected MxList<Order> orderMxList = new MxList();
    private MxList<BlockOrder> blockOrderMxList = new MxList();
    protected MxList<InstructionExec> execuMxList = new MxList();
    private MxList<InstructionLog> logMxList = new MxList();
    private boolean selectTabOrder = false;
    private boolean mail = false;
    private boolean isRS = false;
    private static final Logger logger = LogManager.getLogger(InstructDialog.class);
    @FXML
    protected AnchorPane paneAlgo;
    @FXML
    protected AnchorPane paneUnfinished;
    @Inject
    private InstructionUnfinishedOrderPart unfinishedPart;
    @Inject
    protected MxAlert alert;
    @Inject
    private InstructionAlgoQueryPart algoQueryPart;
    private static final double WIDTH = 1000.0;
    private InvalidationListener lstnOrderModel = ob -> this.lstnOrder();
    private InvalidationListener lstnBlockModel = ob -> {
        ArrayList<BlockOrder> newList = new ArrayList<BlockOrder>();
        List<BlockOrder> list = this.blockModel.getList();
        synchronized (list) {
            newList.addAll(this.blockModel.getList());
        }
        Platform.runLater(() -> {
            this.blockCount = 0;
            for (BlockOrder order : newList) {
                if (!order.isCanCancel()) continue;
                ++this.blockCount;
            }
            StringBuilder string = new StringBuilder();
            if (1 == this.type && "61".equals(this.instruction.getResource().getStatus()) && this.blockCount != 0) {
                string.append("\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u8fd8\u6709").append(this.blockCount).append("\u7b14\u9700\u8981\u624b\u5de5\u64a4\u5355\u3002");
            }
            this.labBlockCount.setText(string.toString());
            this.blockOrderMxList.update(newList);
            Collections.sort(this.blockOrderMxList.getList(), (o1, o2) -> o2.getTime().compareTo(o1.getTime()));
            this.tableBlockOrder.sort();
        });
    };
    private InvalidationListener lstnProgressModel = ob -> {
        ArrayList<InstructionExec> list = new ArrayList<InstructionExec>();
        ObservableList<InstructionExec> observableList = this.executionModel.getList();
        synchronized (observableList) {
            list.addAll((Collection<InstructionExec>)this.executionModel.getList());
        }
        Platform.runLater(() -> {
            int size = list.size();
            this.qty = 0L;
            this.amount = 0.0;
            list.forEach(each -> {
                this.qty += each.getExpectQty();
                this.amount += each.getOrderAmount();
            });
            this.setExecOrdAmt(list);
            StringBuilder string = new StringBuilder();
            if (size > 0) {
                string.append("\u5171\u8ba1").append(size).append("\u53ea\u6210\u5206\u80a1\uff0c\u603b\u59d4\u6258\u6570\u91cf").append(StringUtils.toThousands((Number)this.qty)).append("\uff0c\u603b\u9884\u4f30\u59d4\u6258\u91d1\u989d\u4e3a").append(StringUtils.toThousands((Number)this.amount, (int)2));
            }
            this.labExecution.setText(string.toString());
            this.execuMxList.update(list);
            this.tableExecution.sort();
        });
    };
    private static final String FORMAT_HOUR = "yyyyMMdd";
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd");
    private InvalidationListener lstnLogModel = ob -> Platform.runLater(() -> {
        this.logMxList.update(this.logModel.getList());
        this.tableLog.sort();
    });

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    public void onFinished(ButtonType bt) {
        this.algoQueryPart.close();
        this.unfinishedPart.close();
    }

    @FXML
    public void initialize() {
        this.orderModel.setInstruction(this.instruction, this.type, this.instruction.getMarketGrp());
        this.blockModel.setInstruction(this.instruction, this.type, this.instruction.getMarketGrp());
        this.executionModel.setInstruction(this.instruction, this.type);
        this.logModel.setInstruction(this.instruction, this.type);
        this.coloOcFlag.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.instruction.getType().is("64"), (Observable[])new Observable[]{this.instruction.typeProperty()}));
        this.checkTab();
        this.listener();
        this.setRS(this.instruction.getSide().equals("\u914d\u80a1\u914d\u503a\u7533\u8d2d"));
        this.createOrderTable();
        this.createBlockOrderTable();
        this.createExecutionTable();
        this.createLogTable();
        this.refreshOrder();
        this.refreshBlockOrder();
        this.refreshExecution();
        this.refreshLog();
        this.initValue();
        this.initAlgo();
        this.initUnfinished();
        this.checkBasketPriceLmt(this.instruction);
    }

    private void checkBasketPriceLmt(Instruction ins) {
        block19: {
            if (!ins.isBasketOrAlgoBasket()) break block19;
            this.colePriceLmt.setVisible(true);
            switch (ins.getBasketOrderAdvice().getFixedPriceLimit()) {
                case "2": {
                    this.colePriceLmt.setText("\u4ef7\u683c");
                    break;
                }
                case "3": {
                    this.colePriceLmt.setVisible(false);
                    this.colePriceLmt.setText("\u4ef7\u683c");
                    break;
                }
                case "1": {
                    this.colePriceLmt.setText("\u4e0a\u9650\u4ef7");
                    break;
                }
                case "4": {
                    this.colePriceLmt.setText("\u4e0b\u9650\u4ef7");
                    break;
                }
                case "5": {
                    this.colePriceLmt.setText("\u4e0a/\u4e0b\u9650\u4ef7");
                    break;
                }
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private void checkTab() {
        if ("32".equals(this.instruction.getType().getRaw()) || "34".equals(this.instruction.getType().getRaw())) {
            this.tabPaneIns.getTabs().remove((Object)this.tabOrder);
        } else {
            this.tabPaneIns.getTabs().remove((Object)this.tabBlockOrder);
            if (this.selectTabOrder) {
                this.tabPaneIns.getSelectionModel().select((Object)this.tabOrder);
            }
        }
        if (this.instructionPartId == null) {
            this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
            return;
        }
        switch (this.instructionPartId) {
            default: {
                this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-BASKET-INSTRUCTION-QUERY": 
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-INSTRUCT-QUERY": 
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-INSTRUCTION-QUERY": 
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-INSTRUCT-QUERY": 
        }
        switch (this.instruction.getType().getRaw()) {
            default: {
                this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
                break;
            }
            case "2": 
            case "3": 
            case "4": 
            case "5": 
            case "8": 
            case "9": 
            case "12": 
            case "13": 
        }
        if (this.instruction.getDescId() == 8) {
            this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
            this.tabPaneIns.getTabs().remove((Object)this.tabOrder);
            this.tabPaneIns.getTabs().remove((Object)this.tabBlockOrder);
            this.tabPaneIns.getTabs().remove((Object)this.tabAlgo);
            this.tableExecution.getColumns().remove(this.coleOrderAmount);
            this.tableExecution.getColumns().remove(this.coleOrdAmount);
            this.tableExecution.getColumns().remove(this.coleType);
            this.tableExecution.getColumns().remove(this.coleOrdRate);
            this.tableExecution.getColumns().remove(this.coleDoneQty);
            this.tableExecution.getColumns().remove(this.colePercent);
            this.tableExecution.getColumns().remove(this.coleCumAmount);
            this.tableExecution.getColumns().remove(this.coleAvgPx);
            this.tableExecution.getColumns().remove(this.colePriceLmt);
        }
    }

    private void createBlockOrderTable() {
        this.colBlockSecId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().secIdProperty());
        this.colBlockSecName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().symbolProperty());
        this.colBlockSide.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sideProperty());
        this.colBlockSide.setCellFactory(data -> new SideCell());
        this.colBlockType.setCellValueFactory(data -> ((BlockOrder)data.getValue()).typeProperty());
        this.colBlockPrice.setCellValueFactory(data -> ((BlockOrder)data.getValue()).priceProperty());
        this.colBlockPrice.setCellFactory(data -> new BlockPriceCell());
        this.colBlockOrderQty.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderQtyProperty());
        this.colBlockOrderQty.setCellFactory(data -> new NumberTableCell());
        this.colBlockUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).unitProperty());
        this.colBlockDoneVol.setCellValueFactory(data -> ((BlockOrder)data.getValue()).dealQtyProperty());
        this.colBlockDoneVol.setCellFactory(data -> new NumberTableCell());
        this.colBlockOrdStatus.setCellValueFactory(data -> ((BlockOrder)data.getValue()).statusProperty());
        this.colBlockOrderId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderIdProperty());
        this.colBlockOrdTime.setCellValueFactory(data -> ((BlockOrder)data.getValue()).timeProperty());
        this.colBlockMarket.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().marketProperty());
        this.colBlockAccId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorIdProperty());
        this.colBlockSecAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).inverstorSecIdProperty());
        this.colBlockSysTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sysTraderProperty());
        this.colBlockContractNo.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contractNoProperty());
        this.colBlockOppositeTradingUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTradingUnitProperty());
        this.colBlockOppositeTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTraderProperty());
        this.colBlockContact.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contactProperty());
        this.colBlockRemark.setCellValueFactory(data -> ((BlockOrder)data.getValue()).remarkProperty());
        this.colBlockRemark.setCellFactory(data -> new TooltipTableCell<BlockOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((BlockOrder)this.getValue()).getRemark();
            }
        });
        this.tableBlockOrder.setItems(this.blockOrderMxList.getList());
        this.tableBlockOrder.refresh();
    }

    protected void initAlgo() {
        this.algoQueryPart.instruction = this.instruction;
        this.paneAlgo.getChildren().add((Object)this.limitWidth(this.algoQueryPart.getContent()));
        this.algoQueryPart.refresh();
    }

    private void initUnfinished() {
        if (this.instructionPartId == null) {
            this.tabPaneIns.getTabs().remove((Object)this.tabUnfinished);
            return;
        }
        if (this.tabPaneIns.getTabs().contains((Object)this.tabUnfinished)) {
            this.unfinishedPart.setInstruction(this.instruction);
            this.unfinishedPart.setInstructionPartId(this.instructionPartId);
            this.paneUnfinished.getChildren().add((Object)this.limitWidth(this.unfinishedPart.getContent()));
            this.unfinishedPart.checkRights();
            this.unfinishedPart.isPop();
            this.unfinishedPart.refresh();
        }
    }

    protected void initValue() {
        this.labCount.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labCount);
        this.labExecution.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labExecution);
        this.labBlockCount.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labBlockCount);
    }

    protected Parent limitWidth(Parent content) {
        ((AnchorPane)content).setPrefWidth(1000.0);
        return content;
    }

    public void onDlgClosed() {
        super.onDlgClosed();
        this.orderModel.changedProperty().addListener(this.lstnOrderModel);
        this.blockModel.changedProperty().addListener(this.lstnBlockModel);
        this.executionModel.changedProperty().addListener(this.lstnProgressModel);
        this.logModel.changedProperty().addListener(this.lstnLogModel);
    }

    protected void listener() {
        this.orderModel.changedProperty().addListener(this.lstnOrderModel);
        this.blockModel.changedProperty().addListener(this.lstnBlockModel);
        this.executionModel.changedProperty().addListener(this.lstnProgressModel);
        this.logModel.changedProperty().addListener(this.lstnLogModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lstnOrder() {
        List<Order> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<Order> observableList = this.orderModel.getList();
        synchronized (observableList) {
            newList.addAll((Collection<Order>)this.orderModel.getList());
        }
        Platform.runLater(() -> {
            this.count = 0;
            for (Order order : newList) {
                if (!order.isCanCancel()) continue;
                ++this.count;
            }
            StringBuilder string = new StringBuilder();
            if (1 == this.type && "61".equals(this.instruction.getResource().getStatus()) && this.count != 0) {
                string.append("\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u8fd8\u6709").append(this.count).append("\u7b14\u9700\u8981\u624b\u5de5\u64a4\u5355\u3002");
            }
            this.labCount.setText(string.toString());
            this.orderMxList.update(newList);
            Collections.sort(this.orderMxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.refresh();
            this.tableOrder.sort();
        });
    }

    public void setExecOrdAmt(List<InstructionExec> list) {
        LocalDate now = LocalDate.now();
        LocalDate begin = LocalDate.now();
        for (InstructionExec exec : list) {
            double amt = 0.0;
            double qty = 0.0;
            if ("32".equals(exec.getInstructionType().getRaw()) || "34".equals(exec.getInstructionType().getRaw())) {
                for (BlockOrder ord : this.blockModel.getList()) {
                    if ("3".equals(ord.getStatus().getRaw()) || "5".equals(ord.getStatus().getRaw()) || "6".equals(ord.getStatus().getRaw()) || !ord.getSecId().equals(exec.getSecId())) continue;
                    if (ord.getInstrument() != null && !"7".equals(ord.getStatus().getRaw())) {
                        amt += InstructDialog.calAmountByMarketAndSecType(ord.getInstrument().getMarket().getRaw(), ord.getInstrument().getSecType(), ord.getOrderQty(), ord.getPrice());
                    }
                    qty += (double)ord.getOrderQty();
                }
                qty -= exec.getCxlQty();
            } else {
                for (BlockOrder ord : this.orderModel.getList()) {
                    if ("56".equals(ord.getOrdStatus().getRaw()) || !ord.getSecId().equals(exec.getSecId())) continue;
                    begin = LocalDate.parse(ord.getOrdDate(), this.formatHour);
                    if (begin.isEqual(now)) {
                        amt += ord.getFrozenMargin();
                        if ("90".equals(ord.getOrdStatus().getRaw()) || "48".equals(ord.getOrdStatus().getRaw()) || "49".equals(ord.getOrdStatus().getRaw()) || "54".equals(ord.getOrdStatus().getRaw())) {
                            qty += (double)ord.getOrderQty();
                        }
                        if (!"50".equals(ord.getOrdStatus().getRaw()) && !"70".equals(ord.getOrdStatus().getRaw())) continue;
                        qty += (double)ord.getCumQty();
                        continue;
                    }
                    if (!"50".equals(ord.getOrdStatus().getRaw()) && !"49".equals(ord.getOrdStatus().getRaw()) && !"70".equals(ord.getOrdStatus().getRaw())) continue;
                    qty += (double)ord.getCumQty();
                }
            }
            exec.setOrdAmount(amt + exec.getCumAmount());
            if ("64".equals(this.getInstruction().getType().getRaw())) {
                exec.setOrdAmount(0.0);
                exec.setCumAmount(0.0);
            }
            exec.setOrdRate(qty / (double)exec.getExpectQty() * 100.0);
        }
    }

    public static double calAmountByMarketAndSecType(String market, String secType, double qty, double price) {
        double amount = 0.0;
        switch (secType) {
            case "STD_BOND": {
                amount = qty * (double)("XSHG".equals(market) ? 1000 : 100);
                break;
            }
            case "BOND": {
                amount = qty * price * (double)("XSHG".equals(market) ? 10 : 1);
                break;
            }
            default: {
                amount = qty * price;
            }
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lstnProgress() {
        ArrayList<InstructionExec> list = new ArrayList<InstructionExec>();
        ObservableList<InstructionExec> observableList = this.executionModel.getList();
        synchronized (observableList) {
            list.addAll((Collection<InstructionExec>)this.executionModel.getList());
        }
        Platform.runLater(() -> {
            int size = list.size();
            this.qty = 0L;
            this.amount = 0.0;
            list.forEach(each -> {
                this.qty += each.getExpectQty();
                this.amount += each.getOrderAmount();
            });
            StringBuilder string = new StringBuilder();
            if (size > 0) {
                string.append("\u5171\u8ba1").append(size).append("\u53ea\u6210\u5206\u80a1\uff0c\u603b\u59d4\u6258\u6570\u91cf").append(StringUtils.toThousands((Number)this.qty)).append("\uff0c\u603b\u9884\u4f30\u59d4\u6258\u91d1\u989d\u4e3a").append(StringUtils.toThousands((Number)this.amount, (int)2));
            }
            this.labExecution.setText(string.toString());
            this.execuMxList.update(list);
            this.tableExecution.sort();
        });
    }

    @FXML
    public void copyExecution() {
        TableUtils.copyContentWithHead(this.tableExecution);
    }

    @FXML
    public void refreshExecution() {
        try {
            if ("".equals(this.instruction.getResource().getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u8d44\u6e90ID\u4e3a\u7a7a");
            }
            this.executionModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportExecution() {
        try {
            ExcelUtils.writeExcel(this.tableExecution, (String)"\u6267\u884c\u8fdb\u5ea6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyLog() {
        TableUtils.copyContentWithHead(this.tableLog);
    }

    @FXML
    public void refreshLog() {
        this.logModel.query();
    }

    @FXML
    public void exportLog() {
        try {
            ExcelUtils.writeExcel(this.tableLog, (String)"\u5ba1\u6279\u65e5\u5fd7");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyOrder() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void refreshOrder() {
        try {
            if ("".equals(this.instruction.getResource().getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u8d44\u6e90ID\u4e3a\u7a7a");
            }
            this.orderModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportOrder() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyBlockOrder() {
        TableUtils.copyContentWithHead(this.tableBlockOrder);
    }

    @FXML
    public void refreshBlockOrder() {
        try {
            if ("".equals(this.instruction.getResource().getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u8d44\u6e90ID\u4e3a\u7a7a");
            }
            this.blockModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportBlockOrder() {
        try {
            ExcelUtils.writeExcel(this.tableBlockOrder, (String)"\u59d4\u6258\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createOrderTable() {
        this.coloSecId.setCellValueFactory(data -> ((Order)data.getValue()).getInstrument().secIdProperty());
        this.coloSecName.setCellValueFactory(data -> ((Order)data.getValue()).getInstrument().symbolProperty());
        this.coloSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((Order)data.getValue()).getSide()));
        this.coloSide.setCellFactory(data -> new SideCell());
        this.coloOcFlag.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOcFlag()));
        this.coloPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((Order)data.getValue()).getPrice()));
        this.coloPrice.setCellFactory(p -> new PriceCell());
        this.coloOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((Order)data.getValue()).getOrderQty()));
        this.coloOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.coloOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((Order)data.getValue()).getOrderAmt()));
        this.coloOrderAmt.setCellFactory(p -> new PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((Order)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new PriceCell());
        this.coloDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((Order)data.getValue()).getCumQty()));
        this.coloDoneVol.setCellFactory(cell -> new NumberTableCell());
        this.coloPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((Order)data.getValue()).getDonePercent()));
        this.coloPercent.setCellFactory(data -> new DoubleTableCell());
        this.coloAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((Order)data.getValue()).getAvgPx()));
        this.coloAvgPrice.setCellFactory(p -> new AvgPriceCell());
        this.coloOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getOrdTime()));
        this.coloOrdDate.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getOrdDate()));
        this.coloOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((Order)data.getValue()).getOrdStatus()));
        this.coloMarket.setCellValueFactory(data -> ((Order)data.getValue()).getInstrument().marketProperty());
        this.coloUnit.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getUnit()));
        this.coloOrderId.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getOrderId()));
        this.coloAccId.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getInvestorId()));
        this.coloSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getInverstorSecId()));
        this.coloInfo.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getErrInfo()));
        this.coloInfo.setCellFactory(data -> new TooltipTableCell<Order, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((Order)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.coloUser.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getUserId()));
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getPortfolioName()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((Order)data.getValue()).getReference()));
        if (this.isHkwolun()) {
            this.coloPrice.setText(String.valueOf(this.coloPrice.getText()) + "(HKD)");
            this.coloOrderAmt.setText(String.valueOf(this.coloOrderAmt.getText()) + "(HKD)");
            this.colFrozenAmt.setText(String.valueOf(this.colFrozenAmt.getText()) + "(HKD)");
            this.coloAvgPrice.setText(String.valueOf(this.coloAvgPrice.getText()) + "(HKD)");
        }
        if (this.isRS) {
            this.tableOrder.getColumns().remove(this.coloOrderAmt);
            this.tableOrder.getColumns().remove(this.colFrozenAmt);
            this.tableOrder.getColumns().remove(this.coloPercent);
            this.tableOrder.getColumns().remove(this.coloDoneVol);
        }
        this.tableOrder.setItems(this.orderMxList.getList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        this.coloOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.coloOrdTime);
    }

    public void createExecutionTable() {
        this.coleInstructNo.setCellValueFactory(data -> ((InstructionExec)data.getValue()).instructIdProperty());
        this.coleSecId.setCellValueFactory(data -> ((InstructionExec)data.getValue()).getInstrument().secIdProperty());
        this.coleSecName.setCellValueFactory(data -> ((InstructionExec)data.getValue()).getInstrument().symbolProperty());
        this.coleMarket.setCellValueFactory(data -> ((InstructionExec)data.getValue()).getInstrument().marketProperty());
        this.coleType.setCellValueFactory(data -> ((InstructionExec)data.getValue()).instructionTypeProperty());
        this.coleSide.setCellValueFactory(data -> ((InstructionExec)data.getValue()).sideProperty());
        this.coleSide.setCellFactory(data -> new SideCell());
        this.coleExpectQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).expectQtyProperty());
        this.coleExpectQty.setCellFactory(cell -> new NumberTableCell());
        this.colePriceLmt.setCellValueFactory(data -> ((InstructionExec)data.getValue()).priceLmtProperty());
        this.colePriceLmt.setCellFactory(cell -> new DoubleTableCell());
        this.coleDoneQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).cumQtyProperty());
        this.coleDoneQty.setCellFactory(cell -> new NumberTableCell());
        this.colePercent.setCellValueFactory(data -> ((InstructionExec)data.getValue()).executePercentProperty());
        this.colePercent.setCellFactory(data -> new DoubleTableCell());
        this.coleOrderAmount.setCellValueFactory(data -> ((InstructionExec)data.getValue()).orderAmountProperty());
        this.coleOrderAmount.setCellFactory(data -> new DoubleTableCell());
        this.coleOrdAmount.setCellValueFactory(data -> ((InstructionExec)data.getValue()).ordAmountProperty());
        this.coleOrdAmount.setCellFactory(data -> new DoubleTableCell());
        this.coleOrdRate.setCellValueFactory(data -> ((InstructionExec)data.getValue()).ordRateProperty());
        this.coleOrdRate.setCellFactory(data -> new DoubleTableCell());
        this.coleRiskInfo.setCellValueFactory(data -> ((InstructionExec)data.getValue()).riskInfoProperty());
        this.coleFrozenInfo.setCellValueFactory(data -> ((InstructionExec)data.getValue()).frozenInfoProperty());
        this.coleRiskInfo.setCellFactory(data -> new TooltipTableCell<InstructionExec, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((InstructionExec)this.getValue()).getRiskInfo();
                }
                return null;
            }
        });
        this.coleFrozenInfo.setCellFactory(data -> new TooltipTableCell<InstructionExec, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((InstructionExec)this.getValue()).getFrozenInfo();
                }
                return null;
            }
        });
        this.coleCumAmount.setCellValueFactory(data -> ((InstructionExec)data.getValue()).cumAmountProperty());
        this.coleCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.coleAvgPx.setCellValueFactory(data -> ((InstructionExec)data.getValue()).avgPxProperty());
        this.coleAvgPx.setCellFactory(cell -> new ExecAvgPriceCell());
        if (this.isHkwolun()) {
            this.coleOrderAmount.setText(String.valueOf(this.coleOrderAmount.getText()) + "(HKD)");
            this.coleCumAmount.setText(String.valueOf(this.coleCumAmount.getText()) + "(HKD)");
            this.coleAvgPx.setText(String.valueOf(this.coleAvgPx.getText()) + "(HKD)");
        }
        if (this.isRS) {
            this.tableExecution.getColumns().remove(this.coleOrdAmount);
            this.tableExecution.getColumns().remove(this.coleCumAmount);
            this.tableExecution.getColumns().remove(this.coleAvgPx);
        }
        this.tableExecution.setItems(this.execuMxList.getList());
        this.tableExecution.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableExecution);
    }

    private void createLogTable() {
        this.colgInstructNo.setCellValueFactory(data -> ((InstructionLog)data.getValue()).instructIdProperty());
        this.colDescName.setCellValueFactory(data -> ((InstructionLog)data.getValue()).workflowDescProperty());
        this.colRole.setCellValueFactory(data -> ((InstructionLog)data.getValue()).postProperty());
        this.colUserName.setCellValueFactory(data -> ((InstructionLog)data.getValue()).userNameProperty());
        this.colOperateType.setCellValueFactory(data -> ((InstructionLog)data.getValue()).stepDescProperty());
        this.colTime.setCellValueFactory(data -> ((InstructionLog)data.getValue()).timeProperty());
        this.colIp.setCellValueFactory(data -> ((InstructionLog)data.getValue()).ipProperty());
        this.colMac.setCellValueFactory(data -> ((InstructionLog)data.getValue()).macProperty());
        this.colgInfo.setCellValueFactory(data -> ((InstructionLog)data.getValue()).infoProperty());
        this.colgInfo.setCellFactory(data -> new TooltipTableCell<InstructionLog, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((InstructionLog)this.getValue()).getInfo();
                }
                return null;
            }
        });
        this.tableLog.setItems(this.logMxList.getList());
        this.tableLog.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableLog);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public String getInstructionPartId() {
        return this.instructionPartId;
    }

    public void setInstructionPartId(String instructionPartId) {
        this.instructionPartId = instructionPartId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public void setSelectedTabOrder(boolean selected) {
        this.selectTabOrder = selected;
    }

    public boolean isHkwolun() {
        String market = this.instruction.getMarket();
        return "SHSC".equals(market) || "SZSC".equals(market);
    }

    public void setRS(boolean b) {
        this.isRS = b;
    }

    public boolean isMail() {
        return this.mail;
    }

    public void setMail(boolean mail) {
        this.mail = mail;
    }

    private class AvgPriceCell
    extends DoubleTableCell<Order> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Order order = (Order)Order.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructDialog.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class BlockPriceCell
    extends DoubleTableCell<BlockOrder> {
        int scale = 3;

        private BlockPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class ExecAvgPriceCell
    extends DoubleTableCell<InstructionExec> {
        int scale = 4;

        private ExecAvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<Order> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Order order = (Order)Order.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructDialog.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

