/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.HkwolunPositionModel;
import cms.tmx.query.current.views.CcsPositionPart;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class HkwolunPositionQueryPart
extends MxPart {
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    private Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    private Label lbMarket;
    @FXML
    protected CheckComboBox<String> ccmbSecAcc;
    protected String filterType = "";
    @FXML
    private Label lbSecAcc;
    @FXML
    protected TableView<CcsPosition> tablePosition;
    @FXML
    protected TableColumn<CcsPosition, String> colSecId;
    @FXML
    protected TableColumn<CcsPosition, String> colSecName;
    @FXML
    protected TableColumn<CcsPosition, Number> colTotalVol;
    @FXML
    protected TableColumn<CcsPosition, String> colUnit;
    @FXML
    protected TableColumn<CcsPosition, Number> colCanVol;
    @FXML
    protected TableColumn<CcsPosition, Number> colCost;
    @FXML
    protected TableColumn<CcsPosition, Number> colCostAmt;
    @FXML
    private TableColumn<CcsPosition, Number> colCapital;
    @FXML
    protected TableColumn<CcsPosition, Number> colBuyCost;
    @FXML
    protected TableColumn<CcsPosition, Number> colTotalProfit;
    @FXML
    protected TableColumn<CcsPosition, Number> colProfit;
    @FXML
    protected TableColumn<CcsPosition, Number> colRealizedPl;
    @FXML
    protected TableColumn<CcsPosition, Number> colTodayRealizedPl;
    @FXML
    protected TableColumn<CcsPosition, Number> colYield;
    @FXML
    protected TableColumn<CcsPosition, Number> colPercent;
    @FXML
    protected TableColumn<CcsPosition, Number> colNewPrice;
    @FXML
    protected TableColumn<CcsPosition, MxNode> colMarket;
    @FXML
    protected TableColumn<CcsPosition, String> colAcc;
    @FXML
    protected TableColumn<CcsPosition, String> colSecAcc;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected HkwolunPositionModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    private IFundAccountService fundService;
    @Inject
    private MObjFactory of;
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    protected MxList<CcsPosition> mxList = new MxList();
    protected boolean accFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    private static final Logger logger = LogManager.getLogger(CcsPositionPart.class);
    protected String exportName = "\u6e2f\u80a1\u901a\u6301\u4ed3\u67e5\u8be2";
    protected Predicate<CcsPosition> pd = p -> {
        String txt = this.searchText.getText().trim();
        if (!this.premise((CcsPosition)p)) {
            return false;
        }
        if (p.getSecId().contains(txt)) {
            return true;
        }
        return p.getSecName().contains(txt);
    };
    protected InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        Platform.runLater(() -> {
            ArrayList newList = new ArrayList();
            ObservableList observableList = this.model.getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList());
            }
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> {
                if (o1 == null || o2 == null || "".equals(o1) || "".equals(o2)) {
                    return 0;
                }
                return o1.getSecId().compareTo(o2.getSecId());
            });
            this.tablePosition.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getList(), this.pd);

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.initCheckComboBox();
        this.refresh();
    }

    private void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    private void initCheckComboBox() {
        this.initPosFilterAcc();
        this.initPosFilterSecAcc();
        this.initPosFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
            this.lstnSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.lstnSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
    }

    private void initPosFilterAcc() {
        LinkedList<String> listAccnt = new LinkedList<String>();
        listAccnt.add("\u5168\u90e8");
        this.fundService.getAllFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName());
        });
        this.ccmbAccnt.getItems().addAll(listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id.split("__")[0]);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initPosFilterSecAcc() {
        LinkedList<String> listSecAccnt = new LinkedList<String>();
        listSecAccnt.add("\u5168\u90e8");
        listSecAccnt.addAll(this.model.getInvestorSecIds());
        this.ccmbSecAcc.getItems().addAll(listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        int i = 1;
        while (i < listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            this.secIds.addAll((Collection<String>)this.ccmbSecAcc.getCheckModel().getCheckedItems());
        });
        this.ccmbSecAcc.getCheckModel().checkAll();
    }

    private void initPosFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"hkwolun_market_query_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    public boolean premise(CcsPosition order) {
        System.currentTimeMillis();
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(order.getInvestorId());
            }
            case "2": {
                return this.secIds.contains("\u5168\u90e8") || this.secIds.contains(order.getInverstorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(order.getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void createTable() {
        int doubleClickCount = 2;
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPosition pos;
            if (event.getClickCount() == doubleClickCount && (pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                String code = pos.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)pos.getSecType());
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"count", (Object)pos.getCanVol());
                eCall.put((Object)"side_sell", (Object)(pos.getCanVol() >= 0L ? 1 : 0));
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.code", eCall);
            }
        });
        this.colSecId.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolProperty());
        this.colTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).unitProperty());
        this.colCanVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).canVolProperty());
        this.colCanVol.setCellFactory(cell -> new NumberTableCell());
        this.colCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).costProperty());
        this.colCost.setCellFactory(p -> new PriceCell());
        this.colCostAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).costAmtProperty());
        this.colCostAmt.setCellFactory(p -> new PriceCell());
        this.colProfit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).profitProperty());
        this.colProfit.setCellFactory(p -> new PriceCell());
        this.colTotalProfit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalProfitProperty());
        this.colTotalProfit.setCellFactory(p -> new PriceCell());
        this.colCapital.setCellValueFactory(data -> ((CcsPosition)data.getValue()).capitalizationProperty());
        this.colCapital.setCellFactory(p -> new PriceCell());
        this.colBuyCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).buyCostProperty());
        this.colBuyCost.setCellFactory(data -> new BuyCostCell());
        this.colRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).realizedPlProperty());
        this.colRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colTodayRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).todayRealizedPlProperty());
        this.colTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colYield.setCellValueFactory(data -> ((CcsPosition)data.getValue()).yieldProperty());
        this.colYield.setCellFactory(data -> new YieldTableCell());
        this.colPercent.setCellValueFactory(data -> ((CcsPosition)data.getValue()).percentProperty());
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.colNewPrice.setCellValueFactory(data -> ((CcsPosition)data.getValue()).nowPriceProperty());
        this.colNewPrice.setCellFactory(data -> new DoubleTableCell());
        this.colMarket.setCellValueFactory(data -> ((CcsPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).inverstorSecIdProperty());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)this.exportName);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void closePosi() {
        CcsPosition position = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem();
        if (position == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5e73\u4ed3");
            return;
        }
        if (position.getCanVol() == 0L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ef\u5356\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u5e73\u4ed3");
            return;
        }
        if (this.model.getPledgeCode().contains(position.getSecId())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u65b0\u6807\u51c6\u5238" + position.getSecId() + "\u65e0\u6cd5\u5e73\u4ed3\uff01");
            return;
        }
        LinkedList<CcsPosition> posList = new LinkedList<CcsPosition>();
        posList.add(position);
        if (this.createDialog(posList)) {
            return;
        }
        MEvent event = this.model.close(position);
        int countSuc = event.getInt("suc.count");
        if (countSuc == 1) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5e73\u4ed3\u63d0\u4ea4\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
        }
    }

    @FXML
    public void clearPosi() {
        if (this.tablePosition.getItems().size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u8868\u683c\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
            return;
        }
        FilteredList posList = this.tablePosition.getItems().filtered(pos -> !this.model.getPledgeCode().contains(pos.getSecId()) && pos.getCanVol() > 0L);
        if (posList.size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u65e0\u53ef\u6e05\u4ed3\u6570\u636e");
            return;
        }
        if (this.createDialog((List<CcsPosition>)posList)) {
            return;
        }
        this.exe.execute(() -> this.lambda$48((ObservableList)posList));
    }

    private boolean createDialog(List<CcsPosition> posList) {
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        this.model.queryMarketItem(posList);
        for (CcsPosition po : posList) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(po.getExtAccId(), po.getExtSecAccId());
            en.setSec(po.getSecId());
            en.setSecName(po.getSecName());
            en.setAcc(po.getInvestorId());
            en.setSecAcc(po.getInverstorSecId());
            en.setSecType(po.getSecType());
            en.setMarket(po.getMarket().getRaw());
            en.setOrderType(50);
            en.setQuantity(po.getCanVol());
            en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(50)));
            try {
                en.setPrice(this.model.getNewPrice(String.valueOf(po.getSecType()) + po.getMarket().getRaw(), po.getMarket().getRaw(), po.getSecId()));
                po.setNewPrice(en.getPrice());
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            catch (MException e) {
                en.setTip("\u884c\u60c5\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u4e0b\u5355");
                logger.error("\u5e73\u4ed3\u83b7\u53d6\u884c\u60c5\u5931\u8d25", (Throwable)e);
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u5e73\u4ed3");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private void clear(List<CcsPosition> list) {
        MEvent event = this.model.clear(list);
        Platform.runLater(() -> this.alert.alert(Alert.AlertType.INFORMATION, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14"));
    }

    private /* synthetic */ void lambda$48(ObservableList observableList) {
        this.clear((List<CcsPosition>)observableList);
    }

    protected class BuyCostCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 3;

        protected BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsPosition posi = (CcsPosition)CcsPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = HkwolunPositionQueryPart.this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    public class YieldTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");
        private Label label = new Label();

        private YieldTableCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (item != null) {
                    double value = item.doubleValue();
                    this.label.setText(this.sDFPrice.format(item));
                    if (value > 0.0) {
                        CssUtils.makeRise((Control)this.label);
                    } else if (value < 0.0) {
                        CssUtils.makeFall((Control)this.label);
                    } else if (value == 0.0) {
                        CssUtils.makeEven((Control)this.label);
                    }
                } else {
                    this.label.setText("");
                    this.setGraphic(null);
                    this.setText(null);
                }
            } else {
                this.label.setText("");
                this.setGraphic(null);
                this.setText(null);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

