/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.data.HkwolunPriceUnit;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.HkwolunOrderModel;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;

public class HkwolunOrderPagePart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    @FXML
    protected TableView<ObCcsOrder> tableOrder;
    @FXML
    private TableColumn<ObCcsOrder, String> baseId;
    @FXML
    private TableColumn<ObCcsOrder, String> secId;
    @FXML
    private TableColumn<ObCcsOrder, String> secName;
    @FXML
    private TableColumn<ObCcsOrder, String> side;
    @FXML
    private TableColumn<ObCcsOrder, String> ordTime;
    @FXML
    private TableColumn<ObCcsOrder, String> ordStatus;
    @FXML
    private TableColumn<ObCcsOrder, String> market;
    @FXML
    private TableColumn<ObCcsOrder, String> unit;
    @FXML
    private TableColumn<ObCcsOrder, String> orderId;
    @FXML
    private TableColumn<ObCcsOrder, String> investorId;
    @FXML
    private TableColumn<ObCcsOrder, String> inverstorSecId;
    @FXML
    private TableColumn<ObCcsOrder, Number> price;
    @FXML
    private TableColumn<ObCcsOrder, Number> orderQty;
    @FXML
    private TableColumn<ObCcsOrder, String> ordTypeDesc;
    @FXML
    private TableColumn<ObCcsOrder, Number> orderAmt;
    @FXML
    private TableColumn<ObCcsOrder, Number> frozenMargin;
    @FXML
    private TableColumn<ObCcsOrder, Number> cumQty;
    @FXML
    private TableColumn<ObCcsOrder, Number> donePercent;
    @FXML
    private TableColumn<ObCcsOrder, Number> avgPx;
    @FXML
    private TableColumn<ObCcsOrder, String> errInfo;
    @FXML
    private TableColumn<ObCcsOrder, String> userId;
    @FXML
    private TableColumn<ObCcsOrder, String> userName;
    @FXML
    protected TableColumn<ObCcsOrder, String> reference;
    @FXML
    protected TableColumn<ObCcsOrder, Number> rate;
    @FXML
    protected TextField searchText;
    @Inject
    protected HkwolunOrderModel model;
    @Inject
    protected IRefDataMng refMng;
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbCountSeparator;
    @FXML
    protected Label lbQuerying;
    @Inject
    protected MxAlert alert;
    protected MxPageList<CcsOrder, ObCcsOrder> mxList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getUserId().contains(text)) {
            return true;
        }
        if (en.getUserName().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
        }
        this.sort();
        this.mxList.updatePageList();
        this.tableOrder.refresh();
        this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
        this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
    };
    public Callback<TableView<ObCcsOrder>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<ObCcsOrder>(){

        @Override
        public void afterSort() {
            HkwolunOrderPagePart.this.lstnModel.invalidated(null);
        }
    };
    private ScrollBar bar;
    private double lastPosition = 0.0;
    private boolean dragFlag = false;
    private long lastDragTime = 0L;
    @Inject
    private LoadPartModel load;

    public boolean premise(CcsOrder order) {
        return true;
    }

    public boolean extend(CcsOrder order) {
        return false;
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Focus
    public void onFocus() {
        this.tableOrder.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        if (!this.isVisible()) {
            return;
        }
        ArrayList<CcsOrder> newList = new ArrayList<CcsOrder>();
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsOrder>)this.getModel().getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.sort();
            this.mxList.updatePageList();
            if (this.lbCurrentCount != null && this.lbTotalCount != null) {
                this.lbCurrentCount.setText(String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            }
        });
    }

    protected void sort() {
        try {
            this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            ObservableList sortOrder = this.tableOrder.getSortOrder();
            for (TableColumn column : sortOrder) {
                this.mxList.getList().sort((o1, o2) -> {
                    try {
                        Method method = CcsOrder.class.getMethod("get" + HkwolunOrderPagePart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return QueryUtils.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return QueryUtils.compareMxNode(column, s1, s2);
                        }
                        return QueryUtils.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    private void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    private void loadPrevPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() == 0) {
            return;
        }
        if (this.mxList.getBeginIndex() - PAGE_SIZE < 0) {
            this.mxList.setBeginIndex(0);
        } else {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() - PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    @FXML
    public void initialize() {
        this.tableOrder.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableOrder.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 200L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() == this.bar.getMax() * 0.0) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() == this.bar.getMax()) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.queryingProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (newV.booleanValue()) {
                this.lbQuerying.setVisible(true);
            } else {
                this.lbQuerying.setVisible(false);
            }
        }));
    }

    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.getModel().query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableOrder, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableOrder, (List)listOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTable() {
        this.secId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secNameProperty());
        this.side.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).sideProperty());
        this.side.setCellFactory(cell -> new SideCell());
        this.price.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).priceProperty());
        this.price.setCellFactory(p -> new PriceCell());
        this.orderQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderQtyProperty());
        this.orderQty.setCellFactory(p -> new NumberTableCell());
        this.orderAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderAmtProperty());
        this.orderAmt.setCellFactory(p -> new PriceCell());
        this.frozenMargin.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).frozenMarginProperty());
        this.frozenMargin.setCellFactory(p -> new PriceCell());
        this.cumQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).cumQtyProperty());
        this.cumQty.setCellFactory(p -> new NumberTableCell());
        this.donePercent.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).donePercentProperty());
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).avgPxProperty());
        this.avgPx.setCellFactory(p -> new AvgPriceCell());
        this.ordTypeDesc.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordTypeDescProperty());
        this.baseId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).baseIdProperty());
        this.ordTime.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordTimeProperty());
        this.ordStatus.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordStatusProperty());
        this.market.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).marketProperty());
        this.unit.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).unitProperty());
        this.orderId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderIdProperty());
        this.investorId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).investorIdProperty());
        this.inverstorSecId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).inverstorSecIdProperty());
        this.errInfo.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).errInfoProperty());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObCcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObCcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.userId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).userIdProperty());
        this.userName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).userNameProperty());
        this.reference.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).referenceProperty());
        this.rate.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).rateProperty());
        this.rate.setCellFactory(column -> new RateCell());
        this.tableOrder.setItems(this.mxList.getPageList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        this.ordTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.ordTime);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }

    private class AvgPriceCell
    extends DoubleTableCell<ObCcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
                this.scale = HkwolunPriceUnit.getScale((double)order.getPrice()) + 1;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<ObCcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
                this.scale = HkwolunPriceUnit.getScale((double)order.getPrice());
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class RateCell
    extends DoubleTableCell<ObCcsOrder> {
        int scale = 4;

        private RateCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObCcsOrder, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
            int side = StringUtils.parseInt((String)order.getSideRaw());
            this.label.setText(value);
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

