/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.query.current.models.HedgeUnfinishedOrderModel;
import cms.tmx.query.current.views.HedgeOrderConfirmDialog;
import cms.tmx.query.history.views.TypeCell;
import cms.tmx.query.utils.SideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IContractService;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HedgeUnfinishedOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(HedgeUnfinishedOrderPart.class);
    public static String parentID = "";
    @FXML
    protected TableView<CtpOrder> tableCtpUnOrder;
    @FXML
    private TableColumn<CtpOrder, Boolean> selected;
    @FXML
    private TableColumn<CtpOrder, String> colParentId;
    @FXML
    private TableColumn<CtpOrder, String> colSource;
    @FXML
    private TableColumn<CtpOrder, String> colContId;
    @FXML
    private TableColumn<CtpOrder, String> colContName;
    @FXML
    private TableColumn<CtpOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CtpOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CtpOrder, MxNode> colOC;
    @FXML
    private TableColumn<CtpOrder, MxNode> colSH;
    @FXML
    private TableColumn<CtpOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<CtpOrder, String> colAccId;
    @FXML
    private TableColumn<CtpOrder, String> colSecAcc;
    @FXML
    private TableColumn<CtpOrder, Number> colUnfinishedQty;
    @FXML
    private TableColumn<CtpOrder, String> colInfo;
    @FXML
    private TableColumn<CtpOrder, String> colType;
    @FXML
    private TextField searchText;
    @FXML
    private ComboBox<MxNode> cmbPriceTp;
    @FXML
    private Spinner<Double> spnPriceFlP;
    @FXML
    private Spinner<Double> spnPriceFlU;
    @FXML
    private Label labFloatU;
    @FXML
    private Button btnOrder;
    @Inject
    private HedgeUnfinishedOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IUiRightService rightsModel;
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    @Inject
    private IContractService contractService;
    private MxGroup group = new MxGroup();
    private ObservableList<CtpOrder> obList = FxUtils.newList();
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    public static final String CONFIRM_CANCEL = "\u786e\u8ba4\u64a4\u6389\u6307\u5b9a\u59d4\u6258\uff1f\u59d4\u6258\u7f16\u53f7 ";
    public static final String CANCEL_SELECTED = "\u786e\u8ba4\u64a4\u6389\u5df2\u52fe\u9009\u59d4\u6258\uff1f";
    public static final String REPLACE_SELECTED = "\u662f\u5426\u64a4\u5355\u91cd\u4e0b\uff1f";
    @Inject
    private FutureCancelFactory cf;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    protected MEventHandler handler = event -> {
        if (parentID.isEmpty()) {
            return;
        }
        this.tableCtpUnOrder.getSelectionModel().clearSelection();
        this.tableCtpUnOrder.getItems().forEach(item -> {
            if (item.getParentId().equals(parentID)) {
                this.tableCtpUnOrder.getSelectionModel().select(item);
            }
        });
    };
    private Predicate<CtpOrder> pd = en -> {
        if (en.getCumQty() <= 0) {
            return false;
        }
        String text = this.searchText.getText().toUpperCase().trim();
        return en.getInstrument().getSecId().toUpperCase().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getUserName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.obList.clear();
        for (CtpOrder order : this.model.getList()) {
            if (!this.pd.test(order)) continue;
            this.obList.add((Object)order);
        }
        Collections.sort(this.obList, (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableCtpUnOrder.sort();
    });
    protected InvalidationListener lstnSearch = ob -> {
        this.obList.clear();
        for (CtpOrder order : this.model.getList()) {
            if (!this.pd.test(order)) continue;
            this.obList.add((Object)order);
        }
    };

    @FXML
    public void initialize() {
        this.initValues();
        this.createTableView();
        this.bind();
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList<CtpOrder> observableList = this.obList;
            synchronized (observableList) {
                this.obList.forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        this.refresh();
        this.checkRights();
        this.isPop();
        this.tableCtpUnOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.es.subscribe("future.cross.order.select.changed", this.handler);
        this.handler.onEvent(null);
        this.tableCtpUnOrder.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.unorder")) {
                MEvent event = new MEvent();
                event.put((Object)"code", (Object)now.getSecId());
                this.es.postEvent("input.ctp.future.trade", event);
            }
        });
        this.tableCtpUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpOrder order = (CtpOrder)this.tableCtpUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"sec_code", (Object)order.getInstrument().getSecId());
            e.put((Object)"side_sell", (Object)order.getSide().getRaw());
            this.es.postEvent("input_futures_trade_market", e);
        });
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("future.cross.order.select.changed", this.handler);
    }

    private void checkRights() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String order = "";
        switch (parentId) {
            case "CMS-TMX-FUTURES-PART-STRATEGY-UNFINISHED-HEDGE": {
                order = "cms.tmx.futures.part.strategy.unfinished.hedge_order";
            }
        }
        this.rightsModel.registerCheck((Control)this.btnOrder, new String[]{order});
    }

    protected void isPop() {
        String parentId;
        switch (parentId = this.p.getParent().getParent().getId().toUpperCase()) {
            case "CMS-TMX-FUTURE-PART-UNORDER": {
                this.model.setType("5", "200005002");
                break;
            }
        }
        this.model.doSet();
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"price_adjust_unit", (String)"1");
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
    }

    private void bind() {
        this.cmbPriceTp.setItems(this.model.getPriceType().getNodes());
        this.model.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.model.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.model.priceTypeProperty());
    }

    private void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }

    private void createTableView() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((CtpOrder)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getAttachment()));
        this.colSource.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getSource()));
        this.colContId.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().secIdProperty());
        this.colContName.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().marketProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOcFlag()));
        this.colSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getShFlag()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOrdStatus()));
        this.colUnfinishedQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getCumQty()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CtpOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CtpOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getExecType()));
        this.colType.setCellFactory(cell -> new TypeCell());
        this.tableCtpUnOrder.setItems(this.obList);
        this.tableCtpUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableCtpUnOrder);
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpUnOrder, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpUnOrder, (String)"\u672a\u5b8c\u6210\u5bf9\u51b2\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void refresh() {
        try {
            this.model.query();
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    @FXML
    private void order() {
        FilteredList list = this.obList.filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        HedgeOrderConfirmDialog obj = (HedgeOrderConfirmDialog)((Object)this.of.create(HedgeOrderConfirmDialog.class));
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        this.model.queryMarketItem((List<CtpOrder>)list);
        for (CtpOrder or : list) {
            FutureCancelEntrust en = this.cf.createSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setOrderId(or.getOrderId());
            en.setQuantity(or.getCumQty());
            en.quantityCopy = or.getCumQty();
            en.setSide(or.getSide());
            en.setPrice(this.model.getNewPrice((Order)or));
            or.setNewPrice(en.getPrice());
            en.setAmt(this.getAmt((Order)or, or.getOcFlag().getRaw(), en.getPrice(), en.getQuantity()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setReference(or.getClOrdId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u4e0b\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        for (CtpOrder order : list) {
            for (FutureCancelEntrust entrust : enList) {
                if (!order.getClOrdId().equals(entrust.getReference())) continue;
                order.setOrderQty((int)entrust.getQuantity());
                order.setPrice(entrust.getPrice());
            }
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u4e0b\u5355\uff01");
            return;
        }
        int successed = 0;
        int failed = 0;
        for (CtpOrder o : list) {
            try {
                if (o.getNewPrice() <= 0.0) {
                    throw new MException(999997, String.valueOf(o.getSecId()) + "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a, \u5bf9\u51b2\u5931\u8d25");
                }
                this.model.order(o);
                ++successed;
            }
            catch (MException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                ++failed;
            }
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + successed + "\u7b14\n\u5931\u8d25\uff1a" + failed + "\u7b14");
    }

    private double getAmt(Order or, String offsetFlag, double price, long quantity) {
        CtpRefItem refItem = (CtpRefItem)this.refMng.getItem(or.getInstrument().getMarket().getRaw(), or.getInstrument().getSecId());
        CtpContract con = this.contractService.getContract("FUTURES", or.getInstrument().getMarket().getRaw(), or.getInstrument().getSecId(), or.getBrokerId(), or.getInvestorId());
        if (con == null) {
            return 0.0;
        }
        if ("79".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(con.getUnderlyingMultiple())).multiply(new BigDecimal(con.getLongMarginRatio())).multiply(new BigDecimal(con.getVolumeMultiple())).setScale(refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        if ("67".equals(offsetFlag) || "84".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(con.getUnderlyingMultiple())).multiply(new BigDecimal(con.getShortMarginRatio())).multiply(new BigDecimal(con.getVolumeMultiple())).setScale(refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        return 0.0;
    }
}

