/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.current.models.HKOrderModel;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class HKUnfinishOrderPart
extends MxPagePart<Order, ObSingleOrderNeeq> {
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Boolean> selected;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> source;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> side;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> errInfo;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderAmount;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> donePercent;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> avalQty;
    @Inject
    protected MxAlert alert;
    @Inject
    private HKOrderModel hkModel;
    protected CheckBox checkBox = new CheckBox();
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securitySubType;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securityGroup;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> matchType;
    private int i;
    protected MEventHandler rejected = event -> this.rejected(event);
    protected Gson gson = new Gson();

    protected void initialize() {
        this.hkModel.setUnfinishedOrder(true);
        super.initialize();
        this.initValue();
        this.es.subscribe("uap.push.OrderCancelReject", this.rejected);
    }

    private void initValue() {
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getPageList();
            synchronized (observableList) {
                this.mxList.getPageList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.source.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(false){

            public String tooltip() {
                if (this.getTableRow().getItem() != null && ((ObSingleOrderNeeq)this.getValue()).getAttachment() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getAttachment().getHkDesc();
                }
                return null;
            }
        });
        this.side.setCellFactory(cell -> new SideCell());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.avalQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell(4));
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    private void rejected(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(order.getOrderId()) + "\u59d4\u6258\u64a4\u5355\u88ab\u62d2");
        }
        this.logger.info("\u59d4\u6258\u64a4\u5355\u8ba2\u9605", (Object)"\u59d4\u6258\u64a4\u5355\u8ba2\u9605");
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.es.unSubscribe("uap.push.OrderCancelReject", this.rejected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getPageList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u672a\u5b8c\u6210\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    @FXML
    protected void aCancel() {
        ObSingleOrderNeeq selectedItem = (ObSingleOrderNeeq)this.tableView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        try {
            this.hkModel.cancelOrder(selectedItem);
        }
        catch (MException e) {
            this.logger.error("\u53f3\u952e\u64a4\u5355\u51fa\u9519", (Object)("\u53f3\u952e\u64a4\u5355\u51fa\u9519,\u539f\u56e0: " + (Object)((Object)e)));
        }
    }

    @FXML
    protected void cancel() {
        ObservableList selectedItem = this.mxList.getPageList();
        ArrayList<ObSingleOrderNeeq> accList = new ArrayList<ObSingleOrderNeeq>();
        for (ObSingleOrderNeeq item : selectedItem) {
            if (!item.isSelected()) continue;
            accList.add(item);
        }
        if (accList.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u59d4\u6258");
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5171\u64a4" + accList.size() + "\u7b14\u59d4\u6258")) {
            return;
        }
        for (ObSingleOrderNeeq item : accList) {
            try {
                this.hkModel.cancelOrder(item);
            }
            catch (MException e) {
                this.logger.error("\u6e2f\u80a1\u4ea4\u6613\u64a4\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }

    @FXML
    protected void refresh() {
        try {
            this.hkModel.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected List<Order> getList() {
        return this.hkModel.getList();
    }

    protected MxModel getModel() {
        return this.hkModel;
    }

    protected boolean predicate(Order data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getExtOrderId();
        return code.contains(text) || orderId.contains(text) || name.contains(text);
    }

    public class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private int scale = 3;

        public DoubleTableCell() {
        }

        public DoubleTableCell(int scale) {
            this.scale = scale;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(StringUtils.toThousands((String)String.valueOf(item), (int)this.scale));
                }
            } else {
                this.setText(null);
            }
        }
    }
}

