/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.http.api.core.ObPosDetailItem;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.otc.models.OtcFundPositionModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class HKPositionPart
extends MxPart {
    @FXML
    protected TableView<ObPosDetailItem> tablePositionDetail;
    @FXML
    private TableColumn<ObPosDetailItem, String> colExecId;
    @FXML
    private TableColumn<ObPosDetailItem, String> colPortfolioId;
    @FXML
    private TableColumn<ObPosDetailItem, String> colPortfolioName;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSecId;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSecName;
    @FXML
    private TableColumn<ObPosDetailItem, SecSubType> colSecType;
    @FXML
    private TableColumn<ObPosDetailItem, String> colOrdDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colPosition;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colAvailable;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colCostPrice;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colCost;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colNet;
    @FXML
    private TableColumn<ObPosDetailItem, String> colNetDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colCapital;
    @FXML
    private TableColumn<ObPosDetailItem, String> colExpectedRedemptionDate;
    @FXML
    private TableColumn<ObPosDetailItem, String> colNextOpenDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colDaysToRedemptionDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colDaysToOpenDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colFloatProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colRealProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colBonusCash;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colBonusSec;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colFee;
    @FXML
    protected TableView<ObPosDetailItem> tablePositionSum;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSumPortfolioId;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSumPortfolioName;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSumSecId;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSumSecName;
    @FXML
    private TableColumn<ObPosDetailItem, SecSubType> colSumSecType;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumCostPrice;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumPosition;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumAvailable;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumFee;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumCost;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumNet;
    @FXML
    private TableColumn<ObPosDetailItem, String> colSumNetDate;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumCapital;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumFloatProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumRealProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumBonusCash;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumBonusSec;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumProfit;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumScope;
    @FXML
    private TableColumn<ObPosDetailItem, Number> colSumDegree;
    @FXML
    protected TextField searchText;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton sumRadio;
    @FXML
    private CheckBox cbFilterZeroPos;
    @FXML
    protected Label lbPosition;
    @FXML
    protected Label lbCost;
    @FXML
    protected Label lbCapital;
    @FXML
    protected Label lbFloatProfit;
    @FXML
    protected Label lbRealProfit;
    @FXML
    protected Label lbBonusCash;
    @Inject
    private EPartService eps;
    @Inject
    protected OtcFundPositionModel model;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<ObPosDetailItem> mxDetailList = new MxList();
    protected MxList<ObPosDetailItem> mxSumList = new MxList();
    private static final Logger logger = LogManager.getLogger(HKPositionPart.class);
    @Inject
    private MxAlert alert;
    protected Predicate<ObPosDetailItem> pdDeatil = deal -> {
        String text = this.searchText.getText().trim();
        if (this.cbFilterZeroPos.isSelected() && deal.getBalance() == 0.0) {
            return false;
        }
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        return deal.getInstrument().getSymbol().contains(text);
    };
    protected Predicate<ObPosDetailItem> pdSum = deal -> {
        if (this.cbFilterZeroPos.isSelected() && deal.getBalance() == 0.0) {
            return false;
        }
        String text = this.searchText.getText().trim();
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        return deal.getInstrument().getSymbol().contains(text);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<ObPosDetailItem> detailList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObPosDetailItem> observableList = this.model.getDetailList();
        synchronized (observableList) {
            detailList.addAll((Collection<ObPosDetailItem>)this.model.getDetailList());
        }
        List<ObPosDetailItem> sumList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObPosDetailItem> observableList2 = this.model.getSumList();
        synchronized (observableList2) {
            sumList.addAll((Collection<ObPosDetailItem>)this.model.getSumList());
        }
        Platform.runLater(() -> {
            this.mxDetailList.update(detailList, this.pdDeatil);
            this.tablePositionDetail.sort();
            this.mxSumList.update(sumList, this.pdSum);
            this.tablePositionSum.sort();
            this.lstnExtendOperation();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<ObPosDetailItem> observableList = this.model.getDetailList();
        synchronized (observableList) {
            this.mxDetailList.filter(this.model.getDetailList(), this.pdDeatil);
            this.mxSumList.filter(this.model.getSumList(), this.pdSum);
            this.lstnExtendOperation();
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.setRadio();
        this.createDetailTable();
        this.createSumTable();
        this.refresh();
        this.onFocus();
        this.tableDoubleClickHandler();
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.sumRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tablePositionDetail.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        if (this.tablePositionSum != null) {
            this.tablePositionSum.visibleProperty().bind((ObservableValue)this.sumRadio.selectedProperty());
        }
        this.detailRadio.selectedProperty().addListener((ob, old, now) -> this.lstnExtendOperation());
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.cbFilterZeroPos.setSelected(true);
        this.cbFilterZeroPos.selectedProperty().addListener(this.lstnSearch);
    }

    @Focus
    public void onFocus() {
        this.tablePositionDetail.refresh();
        this.tablePositionSum.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePositionDetail);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePositionDetail, (String)"\u6301\u4ed3\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copySum() {
        TableUtils.copyContentWithHead(this.tablePositionSum);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tablePositionSum, (String)"\u6301\u4ed3\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public void lstnExtendOperation() {
        ObservableList list = this.detailRadio.isSelected() ? this.mxDetailList.getList() : this.mxSumList.getList();
        double position = 0.0;
        double cost = 0.0;
        double capital = 0.0;
        double floatProfit = 0.0;
        double realProfit = 0.0;
        double bonusCash = 0.0;
        for (ObPosDetailItem pos : list) {
            position += pos.getBalance();
            cost += pos.getBuyCostAmt();
            capital += pos.getCapitalization();
            floatProfit += pos.getFloatPnl();
            realProfit += pos.getRealPnl();
            bonusCash += pos.getCashDividend();
        }
        this.lbPosition.setText(StringUtils.toThousands((Number)position, (int)2));
        this.lbCost.setText(StringUtils.toThousands((Number)cost, (int)2));
        this.lbCapital.setText(StringUtils.toThousands((Number)capital, (int)2));
        this.lbFloatProfit.setText(StringUtils.toThousands((Number)floatProfit, (int)2));
        this.lbRealProfit.setText(StringUtils.toThousands((Number)realProfit, (int)2));
        this.lbBonusCash.setText(StringUtils.toThousands((Number)bonusCash, (int)2));
    }

    protected void tableDoubleClickHandler() {
        this.tablePositionDetail.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2 && this.tablePositionDetail.getItems().size() > 0) {
                ObPosDetailItem posDetail = (ObPosDetailItem)this.tablePositionDetail.getSelectionModel().getSelectedItem();
                this.sendEvent(posDetail);
            }
        });
    }

    private void sendEvent(ObPosDetailItem posDetail) {
        MEvent eCall = new MEvent();
        logger.info("\u573a\u5916\u57fa\u91d1\u6301\u4ed3\u56de\u586b" + posDetail.getInstrument().getSecId() + "|" + posDetail.getInstrument().getSecType() + "|" + posDetail.getInstrument().getMarket().getRaw() + "|" + posDetail.getCounterpartyId() + "|" + posDetail.getKey());
        eCall.putStr("posCode", (Object)posDetail.getInstrument().getSecId());
        eCall.putStr("posSecType", (Object)posDetail.getInstrument().getSecType());
        eCall.putStr("posSecMarket", (Object)posDetail.getInstrument().getMarket().getRaw());
        eCall.putStr("posCounterpartyId", (Object)posDetail.getCounterpartyId());
        eCall.putStr("posContract", (Object)posDetail.getKey());
        this.es.sendEvent("otc.panel.set.code", eCall);
    }

    protected void createDetailTable() {
        this.colExecId.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).execIdProperty());
        this.colPortfolioId.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).portfolioIdProperty());
        this.colPortfolioName.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).portfolioNameProperty());
        this.colSecId.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getInstrument().symbolProperty());
        this.colSecType.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).secSubTypeProperty());
        this.colOrdDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).orderDateProperty());
        this.colPosition.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).balanceProperty());
        this.colPosition.setCellFactory(data -> new DoubleTableCell());
        this.colAvailable.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).availableProperty());
        this.colAvailable.setCellFactory(data -> new DoubleTableCell());
        this.colCostPrice.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).buyCostProperty());
        this.colCostPrice.setCellFactory(data -> new DoubleTableCell(4));
        this.colCost.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).buyCostAmtProperty());
        this.colCost.setCellFactory(data -> new DoubleTableCell(2));
        this.colFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosDetailItem)data.getValue()).getFee()));
        this.colFee.setCellFactory(data -> new DoubleTableCell());
        this.colNet.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).lastPriceProperty());
        this.colNet.setCellFactory(data -> new DoubleTableCell(4));
        this.colNetDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject() == null ? new SimpleStringProperty("") : ((ObPosDetailItem)data.getValue()).getObject().netValueDateProperty());
        this.colCapital.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).capitalizationProperty());
        this.colCapital.setCellFactory(data -> new DoubleTableCell(2));
        this.colExpectedRedemptionDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).expectedRedemptionDateProperty());
        this.colNextOpenDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject() == null ? new SimpleStringProperty("") : ((ObPosDetailItem)data.getValue()).getObject().nextOpenDateProperty());
        this.colDaysToRedemptionDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject() == null ? new SimpleIntegerProperty(0) : ((ObPosDetailItem)data.getValue()).getObject().daysToRedemptionDateProperty());
        this.colDaysToOpenDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject() == null ? new SimpleIntegerProperty(0) : ((ObPosDetailItem)data.getValue()).getObject().daysToOpenDateProperty());
        this.colFloatProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).floatPnlProperty());
        this.colFloatProfit.setCellFactory(data -> new DoubleTableCell(2));
        this.colRealProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).realPnlProperty());
        this.colRealProfit.setCellFactory(data -> new DoubleTableCell(2));
        this.colBonusCash.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).cashDividendProperty());
        this.colBonusCash.setCellFactory(data -> new DoubleTableCell(2));
        this.colBonusSec.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).posDividendProperty());
        this.colBonusSec.setCellFactory(data -> new DoubleTableCell());
        this.colProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).yieldProperty());
        this.colProfit.setCellFactory(data -> new DoubleTableCell());
        this.tablePositionDetail.setPlaceholder((Node)new Label());
        this.tablePositionDetail.setItems(this.mxDetailList.getList());
        TableUtils.orgnizeClmWidth(this.tablePositionDetail);
    }

    protected void createSumTable() {
        this.colSumPortfolioId.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).portfolioIdProperty());
        this.colSumPortfolioName.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).portfolioNameProperty());
        this.colSumSecId.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getInstrument().secIdProperty());
        this.colSumSecName.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getInstrument().symbolProperty());
        this.colSumSecType.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).secSubTypeProperty());
        this.colSumCostPrice.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).buyCostProperty());
        this.colSumCostPrice.setCellFactory(data -> new DoubleTableCell(4));
        this.colSumPosition.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).balanceProperty());
        this.colSumPosition.setCellFactory(data -> new DoubleTableCell());
        this.colSumAvailable.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).availableProperty());
        this.colSumAvailable.setCellFactory(data -> new DoubleTableCell());
        this.colSumFee.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).feeProperty());
        this.colSumFee.setCellFactory(data -> new DoubleTableCell());
        this.colSumCost.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).buyCostAmtProperty());
        this.colSumCost.setCellFactory(data -> new DoubleTableCell());
        this.colSumNet.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).lastPriceProperty());
        this.colSumNet.setCellFactory(data -> new DoubleTableCell(4));
        this.colSumNetDate.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject().netValueDateProperty());
        this.colSumCapital.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).capitalizationProperty());
        this.colSumCapital.setCellFactory(data -> new DoubleTableCell());
        this.colSumFloatProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).floatPnlProperty());
        this.colSumFloatProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumRealProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).realPnlProperty());
        this.colSumRealProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumBonusCash.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).cashDividendProperty());
        this.colSumBonusCash.setCellFactory(data -> new DoubleTableCell());
        this.colSumBonusSec.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).posDividendProperty());
        this.colSumBonusSec.setCellFactory(data -> new DoubleTableCell());
        this.colSumProfit.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).yieldProperty());
        this.colSumProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumScope.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject().fundSizeProperty());
        this.colSumScope.setCellFactory(data -> new DoubleTableCell());
        this.colSumDegree.setCellValueFactory(data -> ((ObPosDetailItem)data.getValue()).getObject().concentrationProperty());
        this.colSumDegree.setCellFactory(data -> new DoubleTableCell());
        this.tablePositionSum.setPlaceholder((Node)new Label());
        this.tablePositionSum.setItems(this.mxSumList.getList());
        TableUtils.orgnizeClmWidth(this.tablePositionSum);
    }
}

