/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.query.current.models.HKInstructionModel;
import cms.tmx.query.current.views.NeeqInstructionQueryPart;
import cms.tmx.query.history.views.InstructionSideCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class HKInstructionQueryPart
extends NeeqInstructionQueryPart {
    @Inject
    public HKInstructionModel hkModel;
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.getModel().getList().getList();
        synchronized (observableList) {
            newList.addAll(this.getModel().getList().getList());
        }
        this.mxList.update(newList, this.pd);
        this.handleCheckBox();
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getId().compareTo(o1.getId()));
        this.lstnSearch.invalidated(null);
        this.tableNewInstruction.refresh();
        this.tableNewInstruction.sort();
    });

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    @Override
    protected void listener() {
        this.getModel().changedProperty().addListener(this.getLstnModel());
        this.lstnSearch.invalidated(null);
    }

    @PreDestroy
    private void close() {
        this.getModel().changedProperty().removeListener(this.getLstnModel());
    }

    @Override
    public HKInstructionModel getModel() {
        return this.hkModel;
    }

    @Override
    public void createTable() {
        this.colInsId.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).idProperty());
        this.colLevelInfo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).levelInfoProperty());
        this.colInsType.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).typeNameProperty());
        this.colInsStatus.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).statusNameProperty());
        this.colSide.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).sideNameProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colSecId.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securityCodeProperty());
        this.colSecName.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securityNameProperty());
        this.colBeginTime.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).endTimeProperty());
        this.colInsOption.setCellValueFactory(data -> this.setOperate((ObSimpleInstruction)data.getValue()));
        this.colInsDetail.setCellValueFactory(data -> this.setDetail((ObSimpleInstruction)data.getValue()));
        this.colInsInfo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).errInfoProperty());
        this.colInsInfo.setCellFactory(data -> new TooltipTableCell<ObSimpleInstruction, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSimpleInstruction)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colBelongTo.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<ObSimpleInstruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : (String)((ObSimpleInstruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colInsProgress.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colQty.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colInsPrice.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).insPriceStrProperty());
        this.colOrderAmount.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colCumAmount.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).cumAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colSecuritySubType.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).securitySubTypeProperty());
        this.colMarket.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).marketProperty());
        this.colCumQty.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colTif.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).tifProperty());
        this.tableNewInstruction.getColumns().remove((Object)this.colSecuritySubType);
        this.tableNewInstruction.getColumns().remove((Object)this.colLevelInfo);
        this.tableNewInstruction.getColumns().remove((Object)this.colOrderAmount);
        this.tableNewInstruction.getColumns().remove((Object)this.colBeginTime);
        this.tableNewInstruction.getColumns().remove((Object)this.colEndTime);
        this.tableNewInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth((TableView)this.tableNewInstruction);
        this.tableNewInstruction.setItems(this.mxList.getList());
        this.tableDoubleClickHandler();
    }

    @Override
    protected void sendEvent(ObSimpleInstruction instruction) {
        if (instruction == null || !"XHKG".equals(instruction.getSecMarket())) {
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001");
            return;
        }
        if (instruction.getIsOrderStep() || instruction.isIsApproveStep()) {
            try {
                this.getModel().udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        MEvent eCall = new MEvent();
        if ("SimpleDetail".equals(instruction.getType()) || "SimpleAlgoDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.stock.cp.hk.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.stock.cp.hk.execution");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    @Override
    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    @Override
    public boolean premise(ObSimpleInstruction order) {
        return order.getMarket().getRaw().equals("XHKG");
    }
}

