/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.HKExecutionModel;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.views.ExecutionDownDialog;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class HKExecutionPart
extends MxPart {
    @FXML
    protected TableView<ObExecutionOtc> tableExecution;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSource;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecurityId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSymbol;
    @FXML
    private TableColumn<ObExecutionOtc, String> colMarket;
    @FXML
    private TableColumn<ObExecutionOtc, Side> colSide;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastQty;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastPx;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastAmount;
    @FXML
    private TableColumn<ObExecutionOtc, String> colExecDate;
    @FXML
    private TableColumn<ObExecutionOtc, String> colExecTime;
    @FXML
    private TableColumn<ObExecutionOtc, String> colExtOrderId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colExecId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInvestorId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInvestorSecId;
    @FXML
    protected TableView<ObExecutionOtc> tableDealSum;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecurityIdSum;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSymbolSum;
    @FXML
    private TableColumn<ObExecutionOtc, String> colMarketSum;
    @FXML
    private TableColumn<ObExecutionOtc, Side> colSideSum;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastQtySum;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastPxSum;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colLastAmountSum;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colDealTimes;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInvestorIdSum;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInvestorSecIdSum;
    @FXML
    protected TextField searchText;
    @FXML
    private Label lbPort;
    @FXML
    private Label lbSide;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbSec;
    @FXML
    private Label lbCash;
    @Inject
    protected HKExecutionModel model;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    protected ToggleGroup group = new ToggleGroup();
    @Inject
    protected OtcPortfolioAccountModel portfolioModel;
    protected MxList<ObExecutionOtc> mxList = new MxList();
    private static final Logger logger = LogManager.getLogger(HKExecutionPart.class);
    protected MxList<ObExecutionOtc> mxCountList = new MxList();
    @Inject
    private MxAlert alert;
    protected InvalidationListener sumLabel = ob -> {
        if (this.detailRadio.isSelected()) {
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxList.getList());
        } else {
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxCountList.getList());
        }
    };
    protected Predicate<ObExecutionOtc> pd = deal -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObExecutionOtc)deal)) {
            return false;
        }
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (deal.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObExecutionOtc)deal);
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<ObExecutionOtc> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
            this.mxCountList.filter(this.sumCountList((List<ObExecutionOtc>)this.model.getList()), this.pd);
        }
        if (this.detailRadio.isSelected()) {
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxList.getList());
        } else {
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxCountList.getList());
        }
    };
    protected InvalidationListener lstnModel = ob -> {
        List<ObExecutionOtc> list = Collections.synchronizedList(new ArrayList());
        ObservableList<ObExecutionOtc> observableList = this.model.getList();
        synchronized (observableList) {
            list.addAll((Collection<ObExecutionOtc>)this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(list, this.pd);
            this.mxCountList.update(this.sumCountList(list), this.pd);
            this.lstnSearch.invalidated(null);
            this.tableExecution.sort();
            this.tableExecution.refresh();
            this.tableDealSum.sort();
            this.tableDealSum.refresh();
        });
    };
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.createCountTable();
        this.refresh();
        this.onFocus();
        this.setRadio();
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableExecution.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealSum.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.lstnSearch.invalidated(null);
        this.detailRadio.selectedProperty().addListener(this.sumLabel);
    }

    public void lstnExtendOperation(List<ObExecutionOtc> list) {
        long sec = 0L;
        double cash = 0.0;
        for (ObExecutionOtc exec : list) {
            sec = (long)((double)sec + exec.getLastQty());
            cash += exec.getLastAmount();
            exec.getExecFee();
        }
        this.lbSec.setText(StringUtils.toThousands((Number)sec));
        this.lbCash.setText(StringUtils.toThousands((Number)cash, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)list.size()));
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    @Focus
    public void onFocus() {
        this.tableExecution.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableExecution);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableExecution, (String)"\u6210\u4ea4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copySum() {
        TableUtils.copyContentWithHead(this.tableDealSum);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tableDealSum, (String)"\u6210\u4ea4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    public boolean premise(ObExecutionOtc e) {
        return true;
    }

    public boolean extend(ObExecutionOtc e) {
        return false;
    }

    protected void createTable() {
        this.colSource.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).sourceProperty());
        this.colSource.setCellFactory(data -> new TooltipTableCell<ObExecutionOtc, String>(false){

            public String tooltip() {
                if (this.getTableRow().getItem() != null && ((ObExecutionOtc)this.getValue()).getAttachment() != null) {
                    return ((ObExecutionOtc)this.getValue()).getAttachment().getHkDesc();
                }
                return null;
            }
        });
        this.colSecurityId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).securityIdProperty());
        this.colSymbol.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).marketProperty());
        this.colSide.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).sideProperty());
        this.colLastQty.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastQtyProperty());
        this.colLastQty.setCellFactory(data -> new NumberTableCell());
        this.colLastPx.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastPxProperty());
        this.colLastPx.setCellFactory(data -> new DoubleTableCell(4));
        this.colLastAmount.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastAmountProperty());
        this.colLastAmount.setCellFactory(data -> new DoubleTableCell());
        this.colExecDate.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execDateProperty());
        this.colExecTime.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execTimeProperty());
        this.colExtOrderId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).extOrderIdProperty());
        this.colExecId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execIdProperty());
        this.colInvestorId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).investorIdProperty());
        this.colInvestorSecId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).investorSecIdProperty());
        this.tableExecution.setPlaceholder((Node)new Label());
        this.tableExecution.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableExecution);
    }

    protected void createCountTable() {
        this.colSecurityIdSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).securityIdProperty());
        this.colSymbolSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).symbolProperty());
        this.colMarketSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).marketProperty());
        this.colSideSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).sideProperty());
        this.colLastQtySum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastQtyProperty());
        this.colLastQtySum.setCellFactory(data -> new NumberTableCell());
        this.colLastPxSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastPxProperty());
        this.colLastPxSum.setCellFactory(data -> new DoubleTableCell(4));
        this.colLastAmountSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastAmountProperty());
        this.colLastAmountSum.setCellFactory(data -> new DoubleTableCell());
        this.colInvestorIdSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).investorIdProperty());
        this.colInvestorSecIdSum.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).investorSecIdProperty());
        this.colDealTimes.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).dealTimesProperty());
        this.tableDealSum.setPlaceholder((Node)new Label());
        this.tableDealSum.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealSum);
    }

    protected void selectRow(ObExecutionOtc execution) {
        this.tableExecution.getSelectionModel().select((Object)execution);
    }

    protected ReadOnlyObjectWrapper<Object> setOperation(ObExecutionOtc execution) {
        HBox box = new HBox(){

            public String toString() {
                return "\u9644\u4ef6";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button button = new Button("\u9644\u4ef6");
        button.getStyleClass().add((Object)"btnOperation");
        button.setOnAction(event -> this.showOperation(execution));
        box.getChildren().addAll((Object[])new Node[]{button});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showOperation(ObExecutionOtc execution) {
        this.selectRow(execution);
        ExecutionDownDialog obj = (ExecutionDownDialog)((Object)this.of.create(ExecutionDownDialog.class));
        obj.setExecution(execution);
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9644\u4ef6\u8be6\u60c5");
        dialog.launch();
    }

    private List<ObExecutionOtc> sumCountList(List<ObExecutionOtc> list2) {
        HashMap<String, ObExecutionOtc> map = new HashMap<String, ObExecutionOtc>();
        LinkedList<ObExecutionOtc> list = new LinkedList<ObExecutionOtc>();
        for (ObExecutionOtc deal : list2) {
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                ObExecutionOtc newDeal = new ObExecutionOtc();
                newDeal.update((Object)deal);
                newDeal.setExtOrderId("");
                newDeal.setInvestorId(deal.getInvestorId());
                newDeal.setDealTimes(1);
                list.add(newDeal);
                map.put(key, newDeal);
                continue;
            }
            ObExecutionOtc oldDeal = (ObExecutionOtc)map.get(key);
            double qty = deal.getLastQty();
            double amount = deal.getLastAmount();
            double oldQty = oldDeal.getLastQty();
            double oldAmount = oldDeal.getLastAmount();
            int dealTime = oldDeal.getDealTimes() + 1;
            oldDeal.setLastQty(oldQty + qty);
            oldDeal.setLastAmount(oldAmount + amount);
            oldDeal.setLastPx(oldDeal.getLastAmount() / oldDeal.getLastQty());
            oldDeal.setDealTimes(dealTime);
        }
        return list;
    }

    private String getKey(ObExecutionOtc deal) {
        return String.valueOf(deal.getSecurityId()) + deal.getSide() + deal.getInvestorSecId();
    }

    public class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private int scale = 3;

        public DoubleTableCell() {
        }

        public DoubleTableCell(int scale) {
            this.scale = scale;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(StringUtils.toThousands((String)String.valueOf(item), (int)this.scale));
                }
            } else {
                this.setText(null);
            }
        }
    }
}

