/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.FutureCrossOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.FutureCrossOrderModel;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.rights.IUiRightService;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureCrossOrderPart
extends MxPart {
    private static final Integer PAGE_NUM = 100;
    public static final String CROSS_ORDER_SELECT_EVENT = "future.cross.order.select.changed";
    @FXML
    private TableView<FutureCrossOrder> tableCOrder;
    @Inject
    private MObjFactory of;
    @FXML
    private TableColumn<FutureCrossOrder, Boolean> checkBoxCol;
    @FXML
    TableColumn<FutureCrossOrder, String> id;
    @FXML
    TableColumn<FutureCrossOrder, String> source;
    @FXML
    TableColumn<FutureCrossOrder, String> ordTime;
    @FXML
    TableColumn<FutureCrossOrder, String> code;
    @FXML
    TableColumn<FutureCrossOrder, String> user;
    @FXML
    TableColumn<FutureCrossOrder, String> statusDetail;
    @FXML
    TableColumn<FutureCrossOrder, String> investorSecId;
    @FXML
    TableColumn<FutureCrossOrder, String> legStatus;
    @FXML
    TableColumn<FutureCrossOrder, String> investorId;
    @FXML
    private TableColumn<FutureCrossOrder, Boolean> selected;
    private MxList<FutureCrossOrder> mList = new MxList(PAGE_NUM.intValue());
    @Inject
    private FutureCrossOrderModel model;
    @FXML
    private Button refreshBtn;
    @FXML
    private Button btnOrderCancel;
    @Inject
    private MxAlert alert;
    private ObservableList<FutureCrossOrder> selectList = FxUtils.newList();
    @FXML
    private TextField searchText;
    @Inject
    private ExecutorService exe;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    protected IUiRightService rightsModel;
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    private ObservableList<Boolean> returnList = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(FutureCrossOrderPart.class);
    private MxNode node;
    @Inject
    protected MEventService es;
    private ScrollBar bar;
    private Predicate<FutureCrossOrder> pd = cross -> {
        String text = this.searchText.getText().trim();
        try {
            boolean flag = cross.getId().contains(text) || cross.getCode().contains(text) || cross.getInstName().contains(text) || cross.getAccntId().contains(text) || cross.getSecAccntId().contains(text) || cross.getSource().contains(text) || cross.getUser().contains(text);
            return flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    };
    private InvalidationListener lstnModel = ob -> {
        if (this.model.getOrderList() != null) {
            ArrayList<FutureCrossOrder> newList = new ArrayList<FutureCrossOrder>();
            List<FutureCrossOrder> list = this.model.getOrderList();
            synchronized (list) {
                newList.addAll(this.model.getOrderList());
            }
            this.mList.update(newList, this.pd);
            this.sort();
            this.mList.updatePageList();
            Platform.runLater(() -> {
                this.tableCOrder.refresh();
                this.lbTotalCount.setText(String.valueOf(this.model.getOrderList().size()));
                this.lbCurrentCount.setText(String.valueOf(this.mList.getPageList().size()));
            });
        }
    };
    private InvalidationListener lstnSearch = ob -> {
        if (this.model.getOrderList() != null) {
            this.mList.filter(this.model.getOrderList(), this.pd);
            this.sort();
            this.mList.updatePageList();
            Platform.runLater(() -> {
                this.tableCOrder.refresh();
                this.lbTotalCount.setText(String.valueOf(this.model.getOrderList().size()));
                this.lbCurrentCount.setText(String.valueOf(this.mList.getPageList().size()));
            });
        }
    };
    private double lastPosition = 0.0;
    public Callback<TableView<FutureCrossOrder>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<FutureCrossOrder>(){

        @Override
        public void afterSort() {
            FutureCrossOrderPart.this.refreshOrder();
        }
    };
    private static final String VALIDCHOOSE = "\u8bf7\u52fe\u9009\u5f85\u64a4\u505a\u5e02\u5355";
    private static final String VALIDENOCANCEL = "\u6240\u9009\u5217\u8868\u5b58\u5728\u65e0\u6cd5\u64a4\u5355\u7684\u505a\u5e02\u5355,\u8bf7\u91cd\u65b0\u9009\u62e9";

    public int getDelayTime() {
        return 0;
    }

    @FXML
    public void initialize() {
        this.tableCOrder.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.node = ((MxNode)this.of.create(MxNode.class)).load("ord_status", "");
        this.query();
        this.bingUI();
        this.createCrossTable();
        this.buildeCtxtMenu();
        if (this.rightsModel.registerCheck((Control)this.btnOrderCancel, new String[]{"cms.tmx.future.part.strategy.crossorder_cancel"})) {
            TableUtils.doubleClicked(this.tableCOrder, item -> {
                this.clickOrder();
                return true;
            });
        }
        this.tableCOrder.setOnScroll(ob -> {
            if (ob.getDeltaY() > 0.0) {
                return;
            }
            this.loadNewData();
        });
        this.refreshOrder();
        this.tableCOrder.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableCOrder.lookup(".scroll-bar:vertical");
                }
                double old = this.lastPosition;
                if (this.bar.getValue() <= this.lastPosition) {
                    this.lastPosition = this.bar.getValue();
                    return;
                }
                this.lastPosition = this.bar.getValue();
                if (this.bar.getValue() >= this.bar.getMax() * 0.9) {
                    logger.info("----------------------");
                    logger.info("getvalue" + this.bar.getValue());
                    logger.info("last" + old);
                    logger.info("max" + this.bar.getMax());
                    this.loadNewData();
                }
            }
        });
        this.tableCOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                return;
            }
            FutureCrossOrder crossOrder = (FutureCrossOrder)this.tableCOrder.getSelectionModel().getSelectedItem();
            if (crossOrder == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"input_ctp_market_making", (Object)crossOrder.getCode());
            this.es.postEvent("input_ctp_market_making", e);
        });
    }

    private void loadNewData() {
        if (this.model.getOrderList().size() == this.mList.getPageList().size()) {
            return;
        }
        this.mList.num += PAGE_NUM.intValue();
        this.lstnModel.invalidated(null);
    }

    private void clickOrder() {
        this.selectList.clear();
        FutureCrossOrder cs = (FutureCrossOrder)this.tableCOrder.getSelectionModel().getSelectedItem();
        if (cs == null) {
            return;
        }
        this.selectList.add((Object)cs);
        if (!this.checkOneStatus((List<FutureCrossOrder>)this.selectList)) {
            return;
        }
        if (this.valid((List<FutureCrossOrder>)this.selectList)) {
            this.confirmCancelOrder((List<FutureCrossOrder>)this.selectList);
        }
    }

    private void confirmCancelOrder(List<FutureCrossOrder> list) {
        this.returnList.clear();
        try {
            for (FutureCrossOrder cs : list) {
                if (this.canBeCancel(cs.getOrdStatus())) {
                    int status = this.model.cancelOrder(cs.getAccntId(), cs.getSecAccntId(), 0, cs.getCode(), cs.getMarket(), cs.getType(), cs);
                    if (status == 1) {
                        this.returnList.add((Object)true);
                        continue;
                    }
                    this.returnList.add((Object)false);
                    continue;
                }
                this.returnList.add((Object)false);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f:" + this.returnList.filtered(each -> each).size() + "\u7b14" + "\n" + "\u5931\u8d25:" + this.returnList.filtered(each -> each == false).size() + "\u7b14");
    }

    private void bingUI() {
        FxUtils.makePC((Node)this.refreshBtn, (String)"strong", (boolean)true);
        this.searchText.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 32));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    private boolean canBeCancel(int crossOrderStatus) {
        return this.check(crossOrderStatus);
    }

    private boolean check(int crossOrderStatus) {
        int firstLegStatus = this.getFirstLeg(crossOrderStatus);
        int secondLegStatus = this.getSecondLeg(crossOrderStatus);
        return this.legCanBeCancel(firstLegStatus) || this.legCanBeCancel(secondLegStatus);
    }

    private boolean legCanBeCancel(int legOrderStatus) {
        return String.valueOf(legOrderStatus).equals("48") || String.valueOf(legOrderStatus).equals("49");
    }

    private int getFirstLeg(int ordStatus) {
        return ordStatus / 100;
    }

    private int getSecondLeg(int ordStatus) {
        return ordStatus % 100;
    }

    private void createCrossTable() {
        CheckBox checkBox = new CheckBox();
        checkBox.selectedProperty().addListener((obv, old, now) -> this.mList.getList().forEach(e -> e.setSelected(now.booleanValue())));
        this.selected.setGraphic((Node)checkBox);
        this.selected.setCellValueFactory(data -> ((FutureCrossOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.id.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getId()));
        this.source.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getSource()));
        this.ordTime.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getOrdTime()));
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getCode()));
        this.user.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getUser()));
        this.legStatus.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getLegStatus()));
        this.statusDetail.setCellFactory(data -> new AutoTableCell());
        this.statusDetail.setCellValueFactory(data -> ((FutureCrossOrder)data.getValue()).statusDetailProperty());
        this.investorSecId.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getInvestorSecId()));
        this.investorId.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getInvestorId()));
        this.tableCOrder.setPlaceholder((Node)new Label());
        this.tableCOrder.setItems(this.mList.getPageList());
    }

    private void sort() {
        try {
            this.mList.getList().sort((o1, o2) -> o2.getId().compareTo(o1.getId()));
            this.mList.getList().sort((o1, o2) -> o1.getSortNum() - o2.getSortNum());
            ObservableList sortOrder = this.tableCOrder.getSortOrder();
            for (TableColumn column : sortOrder) {
                this.mList.getList().sort((o1, o2) -> {
                    try {
                        Method method = FutureCrossOrder.class.getMethod("get" + FutureCrossOrderPart.capitalize(column.getId()), new Class[0]);
                        String sort1 = (String)method.invoke(o1, new Object[0]);
                        String sort2 = (String)method.invoke(o2, new Object[0]);
                        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
                            return sort1.compareTo(sort2);
                        }
                        return sort2.compareTo(sort1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    @PreDestroy
    private void close() {
    }

    private void query() {
        this.exe.execute(() -> this.model.query());
    }

    private boolean checkOneStatus(List<FutureCrossOrder> list) {
        boolean flag = this.alert.check(this.canBeCancel(list.get(0).getOrdStatus()), Alert.AlertType.INFORMATION, VALIDENOCANCEL);
        return flag;
    }

    private boolean checkMoreStatus(ObservableList<FutureCrossOrder> list) {
        FilteredList filterList = list.filtered(each -> String.valueOf(this.getFirstLeg(each.getOrdStatus())).equals("48") || String.valueOf(this.getFirstLeg(each.getOrdStatus())).equals("49") || String.valueOf(this.getSecondLeg(each.getOrdStatus())).equals("48") || String.valueOf(this.getSecondLeg(each.getOrdStatus())).equals("49"));
        boolean flag = this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, VALIDCHOOSE) && this.alert.check(!filterList.isEmpty(), Alert.AlertType.INFORMATION, VALIDENOCANCEL);
        return flag;
    }

    private boolean valid(List<FutureCrossOrder> list) {
        return this.check(list);
    }

    private boolean check(List<FutureCrossOrder> list) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (FutureCrossOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getAccntId(), or.getSecAccntId());
            en.setSec(or.getCode());
            en.setSecName(or.getInstName());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setMarket(or.getMarket());
            en.setOrderType(or.getOrdType());
            en.setTip("\u505a\u5e02\u5355\u7f16\u53f7\uff1a" + or.getId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        return dialog.launch() == ButtonType.OK;
    }

    @FXML
    public void cancelOrder() {
        FilteredList list = this.mList.getList().filtered(p -> p.isSelected());
        if (!this.checkMoreStatus((ObservableList<FutureCrossOrder>)list)) {
            return;
        }
        if (this.valid((List<FutureCrossOrder>)list)) {
            this.confirmCancelOrder((List<FutureCrossOrder>)list);
        }
        this.refreshOrder();
    }

    @FXML
    public void refreshOrder() {
        ObservableList list = FxUtils.newList();
        for (FutureCrossOrder selectedOrder : this.mList.getPageList().filtered(p -> p.isSelected())) {
            list.add((Object)selectedOrder);
        }
        this.exe.execute(() -> this.model.query());
        for (FutureCrossOrder newOrder : this.mList.getPageList()) {
            for (FutureCrossOrder oldOrder : list) {
                if (!newOrder.getId().equals(oldOrder.getId())) continue;
                newOrder.setSelected(false);
            }
        }
    }

    private void buildeCtxtMenu() {
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRef = new MenuItem("\u5237\u65b0");
        MenuItem itemExport = new MenuItem("\u5bfc\u51faEXCEL");
        itemRef.setOnAction(value -> this.refreshOrder());
        itemCopy.setOnAction(event -> this.copy());
        itemExport.setOnAction(event -> this.export());
        ContextMenu cxt = new ContextMenu(new MenuItem[]{itemCopy, itemRef, itemExport});
        this.tableCOrder.setContextMenu(cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy() {
        ObservableList observableList = this.mList.getList();
        synchronized (observableList) {
            TableUtils.copyContentWithHead(this.tableCOrder, (ObservableList)this.mList.getList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableCOrder, (List)listOrder, (String)"\u505a\u5e02\u5355\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    public class AutoTableCell<S, T>
    extends TableCell<FutureCrossOrder, T> {
        protected void updateItem(T item, boolean empty) {
            block39: {
                super.updateItem(item, empty);
                if (this.getTableRow() == null) break block39;
                FutureCrossOrder orderExtra = (FutureCrossOrder)this.getTableRow().getItem();
                boolean bFirstLegErr = false;
                boolean bSecondLegErr = false;
                if (orderExtra == null) {
                    return;
                }
                int ordStatus = orderExtra.getOrdStatus();
                this.setText(orderExtra.getStatusDetail());
                int firstLegStatus = ordStatus / 100;
                int secondLegStatus = ordStatus % 100;
                switch (String.valueOf(firstLegStatus)) {
                    case "48": 
                    case "49": 
                    case "50": 
                    case "52": 
                    case "54": 
                    case "70": 
                    case "90": {
                        bFirstLegErr = false;
                        break;
                    }
                    default: {
                        bFirstLegErr = true;
                    }
                }
                switch (String.valueOf(secondLegStatus)) {
                    case "48": 
                    case "49": 
                    case "50": 
                    case "52": 
                    case "54": 
                    case "70": 
                    case "90": {
                        bSecondLegErr = false;
                        break;
                    }
                    default: {
                        bSecondLegErr = true;
                    }
                }
                FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (bFirstLegErr || bSecondLegErr ? 1 : 0) != 0);
            }
        }
    }
}

