/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;

public class FutureCancelConfirmDialog
extends DialogObj {
    @FXML
    private TableView<FutureCancelEntrust> tableItems;
    @FXML
    private TableColumn<FutureCancelEntrust, String> index;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colCode;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colName;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colMkt;
    @FXML
    private TableColumn<FutureCancelEntrust, MxNode> colDirection;
    @FXML
    protected TableColumn<FutureCancelEntrust, Number> colCount;
    @FXML
    protected TableColumn<FutureCancelEntrust, Number> colPrice;
    @FXML
    protected TableColumn<FutureCancelEntrust, Number> colAmt;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colAcc;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colSecAcc;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colPorfolio;
    @FXML
    private TableColumn<FutureCancelEntrust, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label lbTotal;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<FutureCancelEntrust> list;
    private long totalCount;
    private double totalAmt;
    private String strTip = "";
    private String dialogType;
    @Inject
    private IRefDataMng refMng;
    private boolean isSge = false;

    public void setList(List<FutureCancelEntrust> list) {
        this.list = FXCollections.observableList(list);
    }

    private void calTotalInfo() {
        this.totalCount = 0L;
        this.totalAmt = 0.0;
        this.strTip = "";
        for (FutureCancelEntrust item : this.list) {
            this.totalCount += item.getQuantity();
            this.totalAmt += item.getAmt();
            if (item.getTip() == null) continue;
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
        }
    }

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initValue();
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    protected void initValue() {
        this.lbTotalCount.setText(Long.toString(this.totalCount));
        this.lbTotalAmt.setText(StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        this.lbTotal.setVisible(this.totalCount != 0L);
        this.lbTotalCount.setVisible(this.totalCount != 0L);
        this.lbTotalAmt.setVisible(this.totalAmt != 0.0);
        if (this.isSge) {
            this.tableItems.getColumns().remove(this.colAmt);
        }
        this.totalTip.setText(this.strTip);
        switch (this.dialogType) {
            default: {
                this.totalTip.getStyleClass().add((Object)"priceTag");
                CssUtils.makeRise((Control)this.totalTip);
                break;
            }
            case "\u64a4\u5355": 
            case "\u64a4\u5355\u91cd\u4e0b": 
        }
        this.tpTip.setText(this.strTip);
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).secProperty());
        this.colName.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((FutureCancelEntrust)((Object)((Object)m.getValue()))).getMarket()).getValue()));
        this.colDirection.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).sideProperty());
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colAcc.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).accProperty());
        this.colSecAcc.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).secAccProperty());
        this.colPorfolio.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).portfolioNameProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).tipProperty());
        this.colCount.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).priceProperty());
        this.colAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colAmt.setCellValueFactory(m -> ((FutureCancelEntrust)((Object)((Object)m.getValue()))).amtProperty());
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setItems(this.list);
    }

    public void setDialogType(String dialogType) {
        this.dialogType = dialogType;
    }

    public void setSge(boolean isSge) {
        this.isSge = isSge;
    }

    private class ItemPriceCell
    extends TableCell<FutureCancelEntrust, Number> {
        int scale = 3;

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            FutureCancelEntrust item = (FutureCancelEntrust)((Object)FutureCancelEntrust.class.cast(this.getTableRow().getItem()));
            if (item == null || item.getPrice() == 0.0) {
                this.setText(null);
                return;
            }
            RefItem refItem = FutureCancelConfirmDialog.this.refMng.getItem(item.getMarket(), item.getSec());
            if (refItem != null) {
                this.scale = refItem.getScale();
            }
            this.setText(StringUtils.toStr((double)value.doubleValue(), (int)this.scale));
        }
    }

    private class SideCell
    extends TableCell<FutureCancelEntrust, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            switch (FutureCancelConfirmDialog.this.dialogType) {
                case "\u64a4\u5355\u91cd\u4e0b": {
                    this.label.setText(String.valueOf(value.getValue()) + "\u64a4\u5355\u91cd\u4e0b");
                    break;
                }
                case "\u64a4\u5355": {
                    this.label.setText(String.valueOf(value.getValue()) + "\u64a4\u5355");
                    break;
                }
                default: {
                    this.label.setText(value.getValue());
                }
            }
            switch (side) {
                case 49: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<FutureCancelEntrust, String> {
        private Label label = new Label();

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Enabled aggressive block sorting
         */
        private TipCell() {
            switch (FutureCancelConfirmDialog.this.dialogType) {
                default: {
                    this.label.getStyleClass().add((Object)"priceTag");
                    CssUtils.makeRise((Control)this.label);
                    return;
                }
                case "\u4e0b\u5355": 
                case "\u64a4\u5355": 
                case "\u64a4\u5355\u91cd\u4e0b": 
            }
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                this.label.setTooltip(null);
                return;
            }
            this.label.setText(value);
            this.label.setTooltip(new Tooltip(value));
            this.setGraphic((Node)this.label);
            FutureCancelEntrust item = (FutureCancelEntrust)((Object)this.getTableRow().getItem());
            if (item.isIsModified()) {
                this.label.getStyleClass().add((Object)"priceTag");
                CssUtils.makeRise((Control)this.label);
            }
        }
    }
}

