/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxList;
import cms.tmx.query.history.views.InstructionSideCell;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class FairTradeDialog
extends DialogObj {
    @FXML
    private TableView<Instruction> tableItems;
    @FXML
    protected TableColumn<Instruction, Boolean> colSelected;
    @FXML
    private TableColumn<Instruction, String> colInsId;
    @FXML
    private TableColumn<Instruction, String> colCode;
    @FXML
    private TableColumn<Instruction, String> colName;
    @FXML
    private TableColumn<Instruction, String> colBelongTo;
    @FXML
    private TableColumn<Instruction, String> colSide;
    @FXML
    private TableColumn<Instruction, String> colPriceType;
    @FXML
    private TableColumn<Instruction, String> colPriceLimit;
    @FXML
    private TableColumn<Instruction, Number> colPrice;
    @FXML
    private TableColumn<Instruction, Number> colQty;
    @FXML
    private TableColumn<Instruction, Number> colOrderAmount;
    @FXML
    private Label lbInstQty;
    @FXML
    private Label lbOrderQty;
    @FXML
    private Label lbOrderAmount;
    @FXML
    private Label lbError;
    @Inject
    private MxAlert alert;
    private CheckBox checkBox = new CheckBox();
    private MxList<Instruction> mxList = new MxList();
    private List<Instruction> dataList = new ArrayList<Instruction>();
    private List<Instruction> updateList = new ArrayList<Instruction>();
    private List<Instruction> instList = new ArrayList<Instruction>();
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setOrderSelected(now.booleanValue()));
        }
    };

    @FXML
    public void initialize() {
        this.initValue();
        this.initControl(false);
        this.createTable();
        this.listener();
    }

    private void initValue() {
        Platform.runLater(() -> {
            this.mxList.update(this.dataList);
            this.mxList.getList().sort((a, b) -> b.getExpireDate().compareTo(a.getExpireDate()));
            this.tableItems.sort();
            this.tableItems.refresh();
        });
    }

    private void initControl(boolean upFlag) {
        int instQty = 0;
        long sumQty = 0L;
        double totalAmount = 0.0;
        if (!upFlag) {
            this.updateList = this.dataList;
            for (Instruction inst : this.updateList) {
                inst.setOrderSelected(true);
                inst.setOrderAmount(inst.getOrderPrice() * (double)inst.getOrderQty());
                sumQty += inst.getOrderQty();
                totalAmount += inst.getOrderAmount();
                ++instQty;
            }
        } else {
            this.updateList = this.mxList.getList();
            for (Instruction inst : this.updateList) {
                inst.setOrderAmount(inst.getOrderPrice() * (double)inst.getOrderQty());
                if (!inst.isOrderSelected()) continue;
                sumQty += inst.getOrderQty();
                totalAmount += inst.getOrderAmount();
                ++instQty;
            }
        }
        this.lbInstQty.setText(String.valueOf(instQty));
        this.lbOrderQty.setText(String.valueOf(sumQty));
        BigDecimal bAmount = new BigDecimal(Double.toString(totalAmount)).setScale(2, 4);
        this.lbOrderAmount.setText(String.valueOf(bAmount));
    }

    protected void listener() {
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
    }

    @PreDestroy
    protected void close() {
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
    }

    public boolean isOK(ButtonType bt) {
        return this.hotkeyApprove(this.dataList.stream().filter(item -> item.isOrderSelected()).collect(Collectors.toList()));
    }

    private boolean hotkeyApprove(List<Instruction> instructions) {
        if (instructions.isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u4e2d\u6307\u4ee4");
            return false;
        }
        Collections.shuffle(instructions);
        this.instList.addAll(instructions);
        return true;
    }

    protected void createTable() {
        this.colSelected.setGraphic((Node)this.checkBox);
        this.colSelected.setCellValueFactory(data -> ((Instruction)data.getValue()).orderSelectedProperty());
        this.colSelected.setCellFactory(data -> new FairTradeCheckBoxTableCell());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colInsId.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colCode.setCellValueFactory(data -> new SimpleStringProperty(((Instruction)data.getValue()).getSecurityCode()));
        this.colName.setCellValueFactory(data -> ((Instruction)data.getValue()).orderObjProperty());
        this.colBelongTo.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colSide.setCellValueFactory(data -> ((Instruction)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colPriceType.setCellValueFactory(data -> ((Instruction)data.getValue()).priceTypeProperty());
        this.colPriceLimit.setCellValueFactory(data -> ((Instruction)data.getValue()).priceLimitProperty());
        this.colPrice.setCellValueFactory(data -> ((Instruction)data.getValue()).orderPriceProperty());
        this.colPrice.setCellFactory(cell -> new NumberTableCell());
        this.colPrice.setCellFactory(p -> new PriceCell(3));
        this.colQty.setCellValueFactory(data -> ((Instruction)data.getValue()).orderQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colQty.setCellFactory(p -> new QtyCell(0));
        this.colOrderAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.tableItems.setItems(this.mxList.getList());
        this.tableItems.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableItems);
    }

    public List<Instruction> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<Instruction> dataList) {
        this.dataList = dataList;
    }

    public List<Instruction> getInstList() {
        return this.instList;
    }

    public void setInstList(List<Instruction> instList) {
        this.instList = instList;
    }

    public class FairTradeCheckBoxTableCell
    extends MxCheckBoxTableCell<Instruction, Boolean> {
        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    FairTradeDialog.this.initControl(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class PriceCell
    extends EditTableCell<Instruction> {
        PriceCell(int i) {
            super(i);
        }

        public void commitEdit(Number newValue) {
            TableView table;
            Instruction po = (Instruction)this.getTableRow().getItem();
            if (po == null) {
                FairTradeDialog.this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u884c\u8bb0\u5f55\u4e3a\u7a7a");
                return;
            }
            double limitVal = po.getOrderAdvice().getPrice();
            String limit = po.getPriceLimit();
            if (!"\u9650\u4ef7\u59d4\u6258".equals(po.getPriceType()) || "\u6307\u5b9a".equals(po.getPriceLimit())) {
                po.setOrderPrice(limitVal);
                super.commitEdit((Number)limitVal);
                return;
            }
            if (!newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                FairTradeDialog.this.lbError.setText("");
                if ("\u4e0a\u9650".equals(limit)) {
                    if (limitVal >= newValue.doubleValue()) {
                        po.setOrderPrice(newValue.doubleValue());
                        super.commitEdit((Number)newValue.doubleValue());
                    } else {
                        po.setOrderPrice(limitVal);
                        super.commitEdit((Number)limitVal);
                    }
                } else if ("\u4e0b\u9650".equals(limit)) {
                    if (newValue.doubleValue() >= limitVal) {
                        po.setOrderPrice(newValue.doubleValue());
                        super.commitEdit((Number)newValue.doubleValue());
                    } else {
                        po.setOrderPrice(limitVal);
                        super.commitEdit((Number)limitVal);
                    }
                } else {
                    po.setOrderPrice(newValue.doubleValue());
                }
                FairTradeDialog.this.initControl(true);
            }
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }

    private class QtyCell
    extends EditTableCell<Instruction> {
        QtyCell(int i) {
            super(i);
        }

        public void commitEdit(Number newValue) {
            TableView table;
            Instruction po = (Instruction)this.getTableRow().getItem();
            if (po == null) {
                FairTradeDialog.this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u884c\u8bb0\u5f55\u4e3a\u7a7a");
                return;
            }
            long totalQty = po.getTotalExpectationQty();
            if (!newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                if (totalQty >= newValue.longValue()) {
                    po.setOrderQty(newValue.longValue());
                    super.commitEdit((Number)newValue.longValue());
                } else {
                    po.setOrderQty(totalQty);
                    super.commitEdit((Number)totalQty);
                }
            }
            FairTradeDialog.this.initControl(true);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

