/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.EtfRefreshModel;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsUnfinishedOrderPart;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.GridPane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class EtfUnfinishedOrderPart
extends CcsUnfinishedOrderPart {
    @Inject
    private EtfRefreshModel etfMng;
    @FXML
    private Button btnCancelRep;
    @FXML
    private Button btnOrderCancel;
    @FXML
    private Label labPric;
    @FXML
    private Label labRise;
    @FXML
    private GridPane gridPric;
    @FXML
    protected TableColumn<CcsOrder, MxNode> colLegMode;
    @FXML
    protected TableColumn<CcsOrder, String> colParentId;
    @FXML
    protected Button btnAllOrderCancel;
    @Inject
    protected MEventService es;
    @Inject
    private UserPreOrderTips setTips;
    private ChangeListener<String> lstnParentID = (ob, old, now) -> this.changeSelect((String)now);

    @Override
    public void initialize() {
        super.initialize();
        this.btnCancelRep.setVisible(false);
        this.labPric.setVisible(false);
        this.labRise.setVisible(false);
        this.gridPric.setVisible(false);
        this.cmbPriceTp.setVisible(false);
        this.etfMng.changedProperty().addListener(this.lstnModel);
        this.etfMng.parentIdProperty().addListener(this.lstnParentID);
        this.colLegMode.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getLegMode()));
        this.colParentId.setCellFactory(data -> new AutoTableCell());
        this.tableUnOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getParentId()));
    }

    @Override
    @PreDestroy
    protected void close() {
        super.close();
        this.etfMng.changedProperty().removeListener(this.lstnModel);
        this.etfMng.parentIdProperty().removeListener(this.lstnParentID);
    }

    @Override
    protected void initCheckComboBox() {
    }

    @Override
    protected void lbqueryListener() {
    }

    private void changeSelect(String newValue) {
        this.tableUnOrder.getSelectionModel().clearSelection();
        for (CcsOrder item : this.tableUnOrder.getItems()) {
            if (!item.getParentId().equals(newValue)) continue;
            this.tableUnOrder.getSelectionModel().select((Object)item);
        }
    }

    @Override
    protected void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55")) {
            return;
        }
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel((List<CcsOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @Override
    @FXML
    protected void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55")) {
            return;
        }
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel((List<CcsOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @Override
    protected void orderCancelOne(CcsOrder order) {
        ObservableList list = FxUtils.newList();
        list.add((Object)order);
        if (list.size() < 1) {
            return;
        }
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        MEvent event = this.model.cancel((List<CcsOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @Override
    public boolean extend(CcsOrder c) {
        String text = this.searchText.getText().trim();
        return c.getExtAccntId().contains(text) || c.getParentId().contains(text) || c.getExtSecAccntId().contains(text);
    }

    public class AutoTableCell<S, T>
    extends TableCell<CcsOrder, T> {
        CcsOrder orderExtra;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    this.setText(null);
                    return;
                }
                if (this.orderExtra.getErrCode() != 1 || this.orderExtra.getWthErrCode() != 1) {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)true);
                } else {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)false);
                }
                if (!this.orderExtra.getLegMode().getRaw().equals("2")) {
                    this.setText(this.orderExtra.getParentId());
                }
            } else {
                this.setText(null);
            }
        }
    }
}

