/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.mng.EtfManualMng;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.EtfRefreshModel;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtfQueryPart
extends MxPart {
    @FXML
    private TableView<CrossOrder> tableCOrder;
    @Inject
    private MObjFactory of;
    @FXML
    private TableColumn<CrossOrder, Boolean> checkBoxCol;
    @FXML
    TableColumn<CrossOrder, String> id;
    @FXML
    TableColumn<CrossOrder, String> source;
    @FXML
    TableColumn<CrossOrder, String> ordTime;
    @FXML
    TableColumn<CrossOrder, String> code;
    @FXML
    TableColumn<CrossOrder, String> instName;
    @FXML
    TableColumn<CrossOrder, String> user;
    @FXML
    TableColumn<CrossOrder, Number> ordStatus;
    @FXML
    TableColumn<CrossOrder, String> secAccntId;
    @FXML
    TableColumn<CrossOrder, String> legStatus;
    @FXML
    TableColumn<CrossOrder, String> accntId;
    @FXML
    private TableColumn<CrossOrder, Boolean> selected;
    private MxList<CrossOrder> mList = new MxList();
    @Inject
    private EtfManualMng etfMng;
    @Inject
    private EtfRefreshModel refreshMng;
    @FXML
    private Button btnRefresh;
    @FXML
    private Button btnCancel;
    @Inject
    private MxAlert alert;
    private ObservableList<CrossOrder> selectList = FxUtils.newList();
    @FXML
    private TextField txtSearch;
    private static final int CLICKNUM = 2;
    @Inject
    private ExecutorService exe;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    protected IUiRightService rightsModel;
    private ObservableList<Boolean> returnList = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(EtfQueryPart.class);
    private MxNode node;
    private Predicate<CrossOrder> pd = cross -> this.check((CrossOrder)cross);
    @Inject
    protected MEventService es;
    private InvalidationListener listModel = ob -> {
        if (this.etfMng.getOrderList() != null) {
            this.mList.update(this.etfMng.getOrderList(), this.pd);
            this.sort();
        }
    };
    private InvalidationListener lstnSearch = ob -> {
        if (this.etfMng.getOrderList() != null) {
            this.mList.filter(this.etfMng.getOrderList(), this.pd);
            this.sort();
        }
    };
    private static final String VALIDCHOOSE = "\u8bf7\u52fe\u9009\u5f85\u64a4\u505a\u5e02\u5355";
    private static final String VALIDENOCANCEL = "\u6240\u9009\u5217\u8868\u5b58\u5728\u65e0\u6cd5\u64a4\u5355\u7684\u505a\u5e02\u5355,\u8bf7\u91cd\u65b0\u9009\u62e9";
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;

    private boolean check(CrossOrder cross) {
        String text = this.txtSearch.getText().trim();
        boolean flag = cross.getId().contains(text) || cross.getCode().contains(text) || cross.getInstName().contains(text) || cross.getAccntId().contains(text) || cross.getSecAccntId().contains(text) || cross.getSource().contains(text);
        return flag;
    }

    private void sort() {
        this.mList.getList().sort((o1, o2) -> o2.getId().compareTo(o1.getId()));
        Collections.sort(this.mList.getList(), (o1, o2) -> o1.compareTo(o2));
        this.tableCOrder.sort();
    }

    @FXML
    public void initialize() {
        this.etfMng.changedProperty().addListener(this.listModel);
        this.node = MxNodeFactory.create((String)"etf_order_status", (String)"");
        this.query();
        this.bingUI();
        this.createCrossTable();
        this.buildeCtxtMenu();
        this.isPop();
        if (this.rightsModel.registerCheck((Control)this.btnCancel, new String[]{"cms.tmx.fund.part.query.cross.order_cancel"})) {
            TableUtils.doubleClicked(this.tableCOrder, item -> {
                this.clickOrder();
                return true;
            });
        }
    }

    @PreDestroy
    private void close() {
        this.etfMng.changedProperty().removeListener(this.listModel);
    }

    private void isPop() {
        this.refreshMng.setType("2", "200006");
        try {
            this.refreshMng.doSet();
        }
        catch (MException mException) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25");
        }
    }

    private void clickOrder() {
        this.selectList.clear();
        CrossOrder cs = (CrossOrder)this.tableCOrder.getSelectionModel().getSelectedItem();
        if (cs == null) {
            return;
        }
        this.selectList.add((Object)cs);
        if (!this.checkOneStatus((List<CrossOrder>)this.selectList)) {
            return;
        }
        if (this.valid((List<CrossOrder>)this.selectList)) {
            this.confirmCancelOrder((List<CrossOrder>)this.selectList);
        }
    }

    private boolean checkAutoStatus(ObservableList<CrossOrder> list) {
        this.es.sendEvent("etf.auto.query", null);
        ArrayList<Integer> filterList = new ArrayList<Integer>();
        for (EtfStrategy strategy : this.etfMng.getAutoList()) {
            for (CrossOrder crossOrder : list) {
                if (Integer.parseInt(strategy.getContextId()) != crossOrder.getModeAutoId()) continue;
                filterList.add(crossOrder.getModeAutoId());
            }
        }
        if (filterList.size() > 0 && list.filtered(each -> !each.getModeType().equals("EXEC_MODE_TYPE_MANUAL")).size() > 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6709\u7b56\u7565\u5904\u4e8e\u8fd0\u884c\u6216\u6682\u505c\u72b6\u6001\uff0c\u8bf7\u5148\u505c\u6b62\u7b56\u7565");
            return false;
        }
        return true;
    }

    private void confirmCancelOrder(List<CrossOrder> list) {
        this.returnList.clear();
        try {
            for (CrossOrder cs : list) {
                if (this.canBeCancel(cs.getOrdStatus())) {
                    int status = this.etfMng.cancelOrder(cs.getAccntId(), cs.getSecAccntId(), 0, cs.getCode(), cs.getMarket(), cs.getType(), cs);
                    if (status == 1) {
                        this.returnList.add((Object)true);
                        continue;
                    }
                    this.returnList.add((Object)false);
                    continue;
                }
                this.returnList.add((Object)false);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f:" + this.returnList.filtered(each -> each).size() + "\u7b14" + "\n" + "\u5931\u8d25:" + this.returnList.filtered(each -> each == false).size() + "\u7b14");
    }

    private void bingUI() {
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 32));
        this.txtSearch.textProperty().addListener(this.lstnSearch);
    }

    private boolean canBeCancel(int crossOrderStatus) {
        return this.check(crossOrderStatus);
    }

    private boolean check(int crossOrderStatus) {
        int firstLegStatus = this.getFirstLeg(crossOrderStatus);
        int secondLegStatus = this.getSecondLeg(crossOrderStatus);
        return this.legCanBeCancel(firstLegStatus) || this.legCanBeCancel(secondLegStatus);
    }

    private boolean legCanBeCancel(int legOrderStatus) {
        return legOrderStatus == Integer.valueOf("48") || legOrderStatus == Integer.valueOf("49");
    }

    private int getFirstLeg(int ordStatus) {
        return ordStatus / 100;
    }

    private int getSecondLeg(int ordStatus) {
        return ordStatus % 100;
    }

    private void createCrossTable() {
        CheckBox checkBox = new CheckBox();
        checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mList.getList();
            synchronized (observableList) {
                this.mList.getList().stream().forEach(item -> item.setSelected(now.booleanValue()));
            }
        });
        this.selected.setGraphic((Node)checkBox);
        this.selected.setCellValueFactory(data -> ((CrossOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.selected.setCellValueFactory(data -> ((CrossOrder)data.getValue()).selectedProperty());
        this.id.setCellValueFactory(data -> ((CrossOrder)data.getValue()).idProperty());
        this.source.setCellValueFactory(data -> ((CrossOrder)data.getValue()).sourceProperty());
        this.ordTime.setCellValueFactory(data -> ((CrossOrder)data.getValue()).ordTimeProperty());
        this.code.setCellValueFactory(data -> ((CrossOrder)data.getValue()).codeProperty());
        this.instName.setCellValueFactory(data -> ((CrossOrder)data.getValue()).instNameProperty());
        this.user.setCellValueFactory(data -> ((CrossOrder)data.getValue()).userProperty());
        this.legStatus.setCellFactory(data -> new LegCell());
        this.legStatus.setCellValueFactory(data -> ((CrossOrder)data.getValue()).legStatusProperty());
        this.ordStatus.setCellFactory(data -> new AutoTableCell());
        this.ordStatus.setCellValueFactory(data -> ((CrossOrder)data.getValue()).ordStatusProperty());
        this.secAccntId.setCellValueFactory(data -> ((CrossOrder)data.getValue()).inverstorSecIdProperty());
        this.accntId.setCellValueFactory(data -> ((CrossOrder)data.getValue()).investorIdProperty());
        this.tableCOrder.setPlaceholder((Node)new Label());
        this.tableCOrder.setItems(this.mList.getList());
        this.tableCOrder.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.refreshMng.setParentId(now.toString());
            }
        });
    }

    private void query() {
        this.exe.execute(() -> this.queryCrossOrder(true));
    }

    private boolean checkOneStatus(List<CrossOrder> list) {
        boolean flag = this.alert.check(this.canBeCancel(list.get(0).getOrdStatus()), Alert.AlertType.INFORMATION, VALIDENOCANCEL);
        return flag;
    }

    private boolean checkMoreStatus(ObservableList<CrossOrder> list) {
        FilteredList filterList = list.filtered(each -> this.getFirstLeg(each.getOrdStatus()) == Integer.valueOf("48").intValue() || this.getFirstLeg(each.getOrdStatus()) == Integer.valueOf("49").intValue() || this.getSecondLeg(each.getOrdStatus()) == Integer.valueOf("48").intValue() || this.getSecondLeg(each.getOrdStatus()) == Integer.valueOf("49").intValue());
        boolean flag = this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, VALIDCHOOSE) && this.alert.check(!filterList.isEmpty(), Alert.AlertType.INFORMATION, VALIDENOCANCEL);
        return flag;
    }

    private boolean valid(List<CrossOrder> list) {
        if (this.refreshMng.isPopBeforeCancel()) {
            return this.check(list);
        }
        return true;
    }

    private boolean check(List<CrossOrder> list) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CrossOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getAccntId(), or.getSecAccntId());
            en.setSec(or.getCode());
            en.setSecName(or.getInstName());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setMarket(or.getMarket());
            en.setOrderType(or.getOrdType());
            en.setTip("\u505a\u5e02\u5355\u7f16\u53f7\uff1a" + or.getId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        return dialog.launch() == ButtonType.OK;
    }

    @FXML
    public void cancelOrder() {
        FilteredList list = this.mList.getList().filtered(p -> p.isSelected());
        if (!this.checkMoreStatus((ObservableList<CrossOrder>)list)) {
            return;
        }
        if (this.valid((List<CrossOrder>)list)) {
            this.confirmCancelOrder((List<CrossOrder>)list);
        }
        this.refreshOrder();
    }

    private void queryCrossOrder(boolean flag) {
        try {
            this.etfMng.queryOrder(flag);
            if (this.mList.getList() != null) {
                this.refreshMng.setOrderList((ObservableList<CrossOrder>)this.mList.getList());
                this.refreshMng.tableChange();
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refreshOrder() {
        ObservableList list = FxUtils.newList();
        for (CrossOrder selectedOrder : this.mList.getList().filtered(p -> p.isSelected())) {
            list.add((Object)selectedOrder);
        }
        this.exe.execute(() -> this.queryCrossOrder(true));
        for (CrossOrder newOrder : this.mList.getList()) {
            for (CrossOrder oldOrder : list) {
                if (!newOrder.getId().equals(oldOrder.getId())) continue;
                newOrder.setSelected(false);
            }
        }
    }

    private void buildeCtxtMenu() {
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRef = new MenuItem("\u5237\u65b0");
        MenuItem itemExport = new MenuItem("\u5bfc\u51faEXCEL");
        itemRef.setOnAction(value -> this.refreshOrder());
        itemCopy.setOnAction(event -> this.copy());
        itemExport.setOnAction(event -> this.export());
        ContextMenu cxt = new ContextMenu(new MenuItem[]{itemCopy, itemRef, itemExport});
        this.tableCOrder.setContextMenu(cxt);
    }

    private void copy() {
        TableUtils.copyContentWithHead(this.tableCOrder, (int)1, (int)0);
    }

    private void export() {
        try {
            ExcelUtils.writeExcel(this.tableCOrder, (String)"ETF\u505a\u5e02\u5355\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private String getOrderText(int ordStatus) {
        this.node.setRaw(Integer.toString(ordStatus / 100));
        String groupStatus = "\u4e70\u5355" + this.node.getValue();
        this.node.setRaw(Integer.toString(ordStatus % 100));
        groupStatus = String.valueOf(groupStatus) + ",\u5356\u5355" + this.node.getValue();
        return groupStatus;
    }

    public class AutoTableCell<S, T>
    extends TableCell<CrossOrder, T> {
        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                CrossOrder orderExtra = (CrossOrder)this.getTableRow().getItem();
                if (orderExtra == null) {
                    this.setText(null);
                    return;
                }
                int ordStatus = orderExtra.getOrdStatus();
                this.setText(EtfQueryPart.this.getOrderText(ordStatus));
                int firstLegStatus = ordStatus / 100;
                int secondLegStatus = ordStatus % 100;
                if (firstLegStatus == Integer.valueOf("49") || firstLegStatus == Integer.valueOf("50") || secondLegStatus == Integer.valueOf("49") || secondLegStatus == Integer.valueOf("50")) {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfCrossOrder", (boolean)true);
                } else {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfCrossOrder", (boolean)false);
                }
                switch (firstLegStatus) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 11: {
                        break;
                    }
                }
                switch (secondLegStatus) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 11: {
                        break;
                    }
                }
            }
        }
    }

    public class LegCell<S, T>
    extends TableCell<CrossOrder, T> {
        private LegCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                CrossOrder orderExtra = (CrossOrder)this.getTableRow().getItem();
                if (orderExtra == null) {
                    this.setText(null);
                    return;
                }
                String legStr = orderExtra.getLegStatus();
                if (legStr.equals("leg_pending")) {
                    legStr = "\u6709\u6548\u72b6\u6001";
                } else if (legStr.equals("leg_over")) {
                    legStr = "\u5b8c\u7ed3\u72b6\u6001";
                }
                this.setText(legStr);
            }
        }
    }
}

