/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.EtfRefreshModel;
import cms.tmx.query.current.views.CcsOrderPart;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class EtfOrderPart
extends CcsOrderPart {
    @Inject
    private EtfRefreshModel etfMng;
    @FXML
    protected TableColumn<CcsOrder, MxNode> colLegMode;
    @FXML
    protected TableColumn<CcsOrder, String> colParentId;
    private ChangeListener<String> lstnParentID = (ob, old, now) -> this.changeSelect((String)now);

    @Override
    public void initialize() {
        super.initialize();
        this.tableOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.etfMng.changedProperty().addListener(this.lstnModel);
        this.etfMng.parentIdProperty().addListener(this.lstnParentID);
        this.colLegMode.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getLegMode()));
        this.colParentId.setCellFactory(data -> new AutoTableCell());
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getParentId()));
    }

    @Override
    @PreDestroy
    protected void close() {
        super.close();
        this.etfMng.changedProperty().removeListener(this.lstnModel);
        this.etfMng.parentIdProperty().removeListener(this.lstnParentID);
    }

    private void changeSelect(String newValue) {
        this.tableOrder.getSelectionModel().clearSelection();
        for (CcsOrder item : this.tableOrder.getItems()) {
            if (!item.getParentId().equals(newValue)) continue;
            this.tableOrder.getSelectionModel().select((Object)item);
        }
    }

    @Override
    public boolean premise(CcsOrder c) {
        String fundAcc = this.etfMng.getFundAcc();
        String secAcc = this.etfMng.getSecAcc();
        if (fundAcc.isEmpty() && secAcc.isEmpty()) {
            return true;
        }
        boolean flagFund = c.getExtAccntId().contains(fundAcc);
        if (secAcc.isEmpty()) {
            return flagFund;
        }
        boolean flagSec = c.getExtSecAccntId().contains(secAcc);
        return flagFund && flagSec;
    }

    @Override
    public boolean extend(CcsOrder c) {
        String text = this.searchText.getText().trim();
        if (c.getLegMode().getRaw().equals("2")) {
            c.setParentId("");
        }
        return c.getExtAccntId().contains(text) || c.getParentId().contains(text) || c.getExtSecAccntId().contains(text);
    }

    public class AutoTableCell<S, T>
    extends TableCell<CcsOrder, T> {
        CcsOrder orderExtra;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    this.setText(null);
                    return;
                }
                if (this.orderExtra.getErrCode() != 1 || this.orderExtra.getWthErrCode() != 1) {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)true);
                } else {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)false);
                }
                if (!this.orderExtra.getLegMode().getRaw().equals("2")) {
                    this.setText(this.orderExtra.getParentId());
                }
            }
        }
    }
}

