/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.query.current.views.FutureCancelConfirmDialog;
import cms.tmx.query.current.views.FutureReplaceConfirmDialog;
import cms.tmx.query.utils.SideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpUnfinishedOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(CtpUnfinishedOrderPart.class);
    public static String parentID = "";
    @FXML
    protected TableView<CtpOrder> tableCtpUnOrder;
    @FXML
    protected TableColumn<CtpOrder, Boolean> selected;
    @FXML
    protected TableColumn<CtpOrder, String> colContId;
    @FXML
    protected TableColumn<CtpOrder, String> colContName;
    @FXML
    protected TableColumn<CtpOrder, MxNode> colMarket;
    @FXML
    protected TableColumn<CtpOrder, MxNode> colSecSide;
    @FXML
    protected TableColumn<CtpOrder, MxNode> colOrdStatus;
    @FXML
    protected TableColumn<CtpOrder, MxNode> colOC;
    @FXML
    protected TableColumn<CtpOrder, MxNode> colSH;
    @FXML
    protected TableColumn<CtpOrder, String> colOrderId;
    @FXML
    protected TableColumn<CtpOrder, String> colAccId;
    @FXML
    protected TableColumn<CtpOrder, String> colSecAcc;
    @FXML
    protected TableColumn<CtpOrder, String> colOrdDateTime;
    @FXML
    protected TableColumn<CtpOrder, Number> colPrice;
    @FXML
    protected TableColumn<CtpOrder, Number> colOrderQty;
    @FXML
    protected TableColumn<CtpOrder, Number> colDoneVol;
    @FXML
    protected TableColumn<CtpOrder, Number> colPercent;
    @FXML
    protected TableColumn<CtpOrder, Number> colAvgPrice;
    @FXML
    protected TableColumn<CtpOrder, Number> colFrzMargin;
    @FXML
    protected TableColumn<CtpOrder, String> colInfo;
    @FXML
    protected TableColumn<CtpOrder, String> colUser;
    @FXML
    protected TextField searchText;
    @FXML
    private ComboBox<MxNode> cmbPriceTp;
    @FXML
    private Spinner<Double> spnPriceFlP;
    @FXML
    private Spinner<Double> spnPriceFlU;
    @FXML
    private Label labFloatU;
    @FXML
    private Button btnOrderCancel;
    @FXML
    private Button btnAllOrderCancel;
    @FXML
    private HBox boxCancelAndOrder;
    @FXML
    private ComboBox<String> cmbAccnt;
    @Inject
    protected CtpUnfinishedOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private IUiRightService rightsModel;
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    private MxGroup group = new MxGroup();
    protected MxList<CtpOrder> mxList = new MxList();
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    public static final String CONFIRM_CANCEL = "\u786e\u8ba4\u64a4\u6389\u6307\u5b9a\u59d4\u6258\uff1f\u59d4\u6258\u7f16\u53f7 ";
    public static final String CANCEL_SELECTED = "\u786e\u8ba4\u64a4\u6389\u5df2\u52fe\u9009\u59d4\u6258\uff1f";
    public static final String REPLACE_SELECTED = "\u662f\u5426\u64a4\u5355\u91cd\u4e0b\uff1f";
    private static final String ALL = "\u5168\u90e8";
    @Inject
    private FutureCancelFactory cf;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    protected MEventHandler handler = event -> {
        if (parentID.isEmpty()) {
            return;
        }
        this.tableCtpUnOrder.getSelectionModel().clearSelection();
        this.tableCtpUnOrder.getItems().forEach(item -> {
            if (item.getParentId().equals(parentID)) {
                this.tableCtpUnOrder.getSelectionModel().select(item);
            }
        });
    };
    private boolean ctrlPressed = false;
    private boolean shiftPressed = false;
    private int lastIndex = -1;
    private Predicate<CtpOrder> pd = en -> {
        String accntNow;
        String type = en.getExecType();
        if (!type.equals("\u505a\u5e02\u5355")) {
            type = "\u975e\u505a\u5e02\u5355";
        }
        if ((accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem()) != null) {
            String[] split = accntNow.split("__");
            if (!ALL.equals(accntNow) && !en.getExtAccntId().contains(split[0])) {
                return false;
            }
        }
        String text = this.searchText.getText().toUpperCase().trim();
        return en.getInstrument().getSecId().toUpperCase().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getUserName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.getPredicate());
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableCtpUnOrder.sort();
            this.tableCtpUnOrder.refresh();
            this.layout();
        });
    };
    protected InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        this.mxList.filter(this.model.getList(), this.getPredicate());
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableCtpUnOrder.sort();
        this.tableCtpUnOrder.refresh();
    });
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            System.out.println("ctpUnfinishedOrder   |  " + Thread.currentThread().getName());
            this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
        }
    };

    private void setKey() {
        this.tableCtpUnOrder.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = true;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = true;
                CtpOrder strategy = (CtpOrder)this.tableCtpUnOrder.getSelectionModel().getSelectedItem();
                if (strategy != null) {
                    this.lastIndex = this.tableCtpUnOrder.getItems().indexOf((Object)strategy);
                }
            }
        });
        this.tableCtpUnOrder.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = false;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = false;
            }
        });
        this.tableCtpUnOrder.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            block8: {
                CtpOrder strategy = (CtpOrder)this.tableCtpUnOrder.getSelectionModel().getSelectedItem();
                if (strategy == null) break block8;
                boolean isSelect = strategy.isSelected();
                System.err.println(">>>>> " + strategy.getSysOrderId() + strategy.getOrderId());
                if (this.ctrlPressed) {
                    strategy.setSelected(!isSelect);
                } else {
                    this.tableCtpUnOrder.getItems().forEach(item -> {
                        if (item.equals((Object)strategy)) {
                            item.setSelected(true);
                        } else {
                            item.setSelected(false);
                        }
                    });
                }
                if (this.shiftPressed) {
                    if (this.lastIndex == -1) {
                        return;
                    }
                    int index = this.tableCtpUnOrder.getItems().indexOf((Object)strategy);
                    if (index > this.lastIndex) {
                        int i = this.lastIndex;
                        while (i <= index) {
                            ((CtpOrder)this.tableCtpUnOrder.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    } else {
                        int i = index;
                        while (i <= this.lastIndex) {
                            ((CtpOrder)this.tableCtpUnOrder.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    }
                }
            }
        });
    }

    @FXML
    public void initialize() {
        this.setKey();
        this.initValues();
        this.createTableView();
        this.bind();
        this.listener();
        this.refresh();
        this.checkRights();
        this.isPop();
        this.tableCtpUnOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.es.subscribe("future.cross.order.select.changed", this.handler);
        this.handler.onEvent(null);
        this.tableCtpUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpOrder order = (CtpOrder)this.tableCtpUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.unorder")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)order.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.model.getFundList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
    }

    protected void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
    }

    @PreDestroy
    protected void close() {
        this.es.unSubscribe("future.cross.order.select.changed", this.handler);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
    }

    private void checkRights() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String cancel = "";
        String cancelAndOrder = "";
        switch (parentId) {
            case "CMS-TMX-FUTURES-PART-STRATEGY-UNFINISHEDORDER": {
                cancel = "cms.tmx.futures.part.strategy.unfinishedorder_cancel";
                cancelAndOrder = "cms.tmx.futures.part.strategy.unfinishedorder_cancelandorder";
                break;
            }
            case "CMS-TMX-FUTURE-PART-UNORDER": {
                cancel = "cms.tmx.future.part.unorder_cancel";
                cancelAndOrder = "cms.tmx.future.part.unorder_update";
                break;
            }
            case "CMS-TMX-FUTURES-PART-ARBITRAGE-UNFINISHED-ORDER": {
                cancel = "cms.tmx.futures.part.strategy.unfinishedorder_cancel";
                cancelAndOrder = "cms.tmx.futures.part.strategy.unfinishedorder_cancelandorder";
            }
        }
        this.rightsModel.registerCheck((Pane)this.boxCancelAndOrder, new String[]{cancelAndOrder});
        if (this.rightsModel.registerCheck((Control)this.btnOrderCancel, new String[]{cancel})) {
            TableUtils.doubleClicked(this.tableCtpUnOrder, item -> {
                item.setSelected(true);
                this.orderCancelOne((CtpOrder)item);
                return true;
            });
        }
    }

    protected void isPop() {
        String parentId;
        switch (parentId = this.p.getParent().getParent().getId().toUpperCase()) {
            case "CMS-TMX-FUTURES-PART-STRATEGY-UNFINISHEDORDER": 
            case "CMS-TMX-FUTURE-PART-UNORDER": {
                this.model.setType("5", "200005002");
                break;
            }
        }
        this.model.doSet();
    }

    protected Predicate<CtpOrder> getPredicate() {
        return this.pd;
    }

    protected void initValues() {
        MxNode node = MxNodeFactory.create((String)"price_adjust_unit", (String)"1");
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
    }

    public List<String> getNationalDebtCode(Collection<RefItem> items) {
        ArrayList<String> list = new ArrayList<String>();
        for (RefItem item : items) {
            if (!(item instanceof CtpRefItem)) continue;
            CtpRefItem it = (CtpRefItem)CtpRefItem.class.cast(item);
            if (!StringUtils.belongto((String)it.getProductId(), (String[])new String[]{"TS", "TF", "T"})) continue;
            list.add(it.getCode());
        }
        list.sort((o1, o2) -> o1.compareTo((String)o2));
        return list;
    }

    private void bind() {
        this.cmbPriceTp.setItems(this.model.getPriceType().getNodes());
        this.model.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.model.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.model.priceTypeProperty());
    }

    private void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }

    private void createTableView() {
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableCtpUnOrder.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((CtpOrder)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)checkBox);
        this.selected.setSortable(false);
        this.colContId.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().secIdProperty());
        this.colContName.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().marketProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOcFlag()));
        this.colSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getShFlag()));
        this.colFrzMargin.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getFrozenMargin()));
        this.colFrzMargin.setCellFactory(p -> new DoubleTableCell());
        this.colFrzMargin.setEditable(false);
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colPrice.setEditable(false);
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getOrderQty()));
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getCumQty()));
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new PriceCell());
        this.colAvgPrice.setEditable(false);
        this.colOrdDateTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOrdStatus()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInverstorSecId()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrderId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CtpOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CtpOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getUserId()));
        this.tableCtpUnOrder.setItems(this.mxList.getList());
        this.tableCtpUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableCtpUnOrder);
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpUnOrder, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpUnOrder, (String)"\u672a\u5b8c\u6210\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    @FXML
    private void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog((List<CtpOrder>)list)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel((List<CtpOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @FXML
    private void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog((List<CtpOrder>)list)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel((List<CtpOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private void orderCancelOne(CtpOrder order) {
        ObservableList list = FxUtils.newList();
        list.add((Object)order);
        if (list.size() < 1) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog((List<CtpOrder>)list)) {
            return;
        }
        MEvent event = this.model.cancel((List<CtpOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @FXML
    private void cancelAndOrder() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        FutureReplaceConfirmDialog obj = (FutureReplaceConfirmDialog)((Object)this.of.create(FutureReplaceConfirmDialog.class));
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        HashMap<FutureCancelEntrust, CtpOrder> enOrMap = new HashMap<FutureCancelEntrust, CtpOrder>();
        ArrayList<String> referenceIds = new ArrayList<String>();
        this.model.queryMarketItem((List<CtpOrder>)list);
        for (CtpOrder or2 : list) {
            FutureCancelEntrust en = this.cf.createSingle(or2.getExtAccntId(), or2.getExtSecAccntId());
            en.setSec(or2.getInstrument().getSecId());
            en.setSecName(or2.getInstrument().getSymbol());
            en.setAcc(or2.getInvestorId());
            en.setSecAcc(or2.getInverstorSecId());
            en.setSecType(or2.getInstrument().getSecType());
            en.setMarket(or2.getInstrument().getMarket().getRaw());
            en.setOrderType(or2.getOrdType());
            en.setOrderId(or2.getOrderId());
            en.setQuantity(or2.getOrderQty() - or2.getCumQty());
            en.setSide(or2.getSide());
            en.setPrice(this.model.getNewPrice((Order)or2, null, this.model.getFloatUnit(), this.model.getPriceFloat()));
            if (!StringUtils.isEmpty((String)or2.getReference())) {
                en.setReference(or2.getReference());
                referenceIds.add(or2.getReference());
            }
            or2.setNewPrice(en.getPrice());
            en.setAmt(this.model.getAmt((Order)or2, or2.getOcFlag().getRaw(), en.getPrice(), en.getQuantity()));
            if (StringUtils.isEmpty((String)or2.getReference()) && 50 == or2.getOrdType() && Double.doubleToLongBits(or2.getNewPrice()) == Double.doubleToLongBits(or2.getPrice())) {
                en.setTip("".equals(or2.getOrderId()) ? null : "\u4e0e\u539f\u59d4\u6258\u4ef7\u683c\u76f8\u540c\uff0c\u65e0\u9700\u64a4\u5355\u91cd\u4e0b\u3002\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getOrderId());
                or2.setCanCancelReplace(false);
                en.setIsModified(true);
            } else {
                or2.setCanCancelReplace(true);
                en.setTip("".equals(or2.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getOrderId());
            }
            enList.add(en);
            enOrMap.put(en, or2);
        }
        if (referenceIds.size() > 0) {
            try {
                this.model.checkInstructionPrice(enOrMap, referenceIds);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u6307\u4ee4\u4fe1\u606f\u5931\u8d25");
                logger.error("get instruction failed : " + e.getMessage());
                return;
            }
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355\u91cd\u4e0b");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u91cd\u4e0b\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        FilteredList filteredList = list.filtered(or -> or.isCanCancelReplace());
        if (filteredList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u4e0d\u7b26\u5408\u64a4\u5355\u91cd\u4e0b\u6761\u4ef6\u3002");
            return;
        }
        MEvent event = this.model.cancelAndOrder((List<CtpOrder>)filteredList);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private boolean createDialog(List<CtpOrder> list) {
        FutureCancelConfirmDialog obj = (FutureCancelConfirmDialog)((Object)this.of.create(FutureCancelConfirmDialog.class));
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        for (CtpOrder or : list) {
            FutureCancelEntrust en = this.cf.createSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setOrderId(or.getOrderId());
            if (!StringUtils.isEmpty((String)or.getReference())) {
                en.setReference(or.getReference());
            }
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setQuantity(or.getOrderQty() - or.getCumQty());
            en.setPrice(or.getPrice());
            en.setAmt(this.model.getAmt((Order)or, or.getOcFlag().getRaw(), en.getPrice(), en.getQuantity()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private class PriceCell
    extends DoubleTableCell<CtpOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CtpOrder order = (CtpOrder)CtpOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpUnfinishedOrderPart.this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

