/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpPositionModel;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.query.current.views.FutureReplaceConfirmDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CtpPositionPart
extends MxPart {
    @FXML
    private TextField searchText;
    @FXML
    protected TableView<CtpPosition> tableCtpPosition;
    @FXML
    private TableColumn<CtpPosition, String> colSecId;
    @FXML
    private TableColumn<CtpPosition, String> colSecName;
    @FXML
    private TableColumn<CtpPosition, MxNode> colMarket;
    @FXML
    private TableColumn<CtpPosition, MxNode> colPosiDire;
    @FXML
    private TableColumn<CtpPosition, MxNode> colHedgeFlag;
    @FXML
    private TableColumn<CtpPosition, Number> colTdPosi;
    @FXML
    private TableColumn<CtpPosition, Number> colYdPosi;
    @FXML
    private TableColumn<CtpPosition, Number> colPosi;
    @FXML
    private TableColumn<CtpPosition, Number> colCanClose;
    @FXML
    private TableColumn<CtpPosition, Number> colSecValue;
    @FXML
    private TableColumn<CtpPosition, Number> colPosiProfit;
    @FXML
    private TableColumn<CtpPosition, Number> colUseMargin;
    @FXML
    private TableColumn<CtpPosition, String> colAcc;
    @FXML
    private TableColumn<CtpPosition, String> colSecAcc;
    @FXML
    private MenuItem close;
    @FXML
    private MenuItem clear;
    @Inject
    private CtpPositionModel model;
    @Inject
    protected MEventService es;
    @Inject
    private IUiRightService rightModel;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private FutureCancelFactory cf;
    @FXML
    private RadioButton allRadio;
    @FXML
    private RadioButton filterRadio;
    private ToggleGroup group = new ToggleGroup();
    @FXML
    private ComboBox<String> cmbAccnt;
    private static final String ALL = "\u5168\u90e8";
    private MxList<CtpPosition> mxList = new MxList();
    private MxList<CtpPosition> mxFilterList = new MxList();
    private static final Logger logger = LogManager.getLogger(CtpPositionPart.class);
    private Predicate<CtpPosition> pd = p -> {
        if (!this.checkAccnt((CtpPosition)p)) {
            return false;
        }
        String txt = this.searchText.getText().toUpperCase().trim();
        return p.getSecId().toUpperCase().contains(txt) || p.getSecName().toUpperCase().contains(txt);
    };
    private InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            ArrayList newList = new ArrayList();
            ArrayList filterList = new ArrayList();
            newList.addAll(this.model.getList());
            filterList.addAll(this.model.getList().filtered(pos -> pos.getPosition() > 0L));
            this.mxList.update(newList, this.pd);
            this.mxFilterList.update(filterList, this.pd);
        }
        Collections.sort(this.mxList.getList(), (o1, o2) -> o1.getSecId().toLowerCase().compareTo(o2.getSecId().toLowerCase()));
        Collections.sort(this.mxFilterList.getList(), (o1, o2) -> o1.getSecId().toLowerCase().compareTo(o2.getSecId().toLowerCase()));
        this.tableCtpPosition.sort();
        this.tableCtpPosition.refresh();
    };
    protected InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.mxFilterList.filter((List)this.model.getList().filtered(pos -> pos.getPosition() > 0L), this.pd);
    };

    @FXML
    public void initialize() {
        this.listener();
        this.refresh();
        this.createTable();
        this.onFocus();
        this.check();
        this.setRadio();
        this.tableCtpPosition.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                return;
            }
            CtpPosition position = (CtpPosition)this.tableCtpPosition.getSelectionModel().getSelectedItem();
            if (position == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.position")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)position.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.model.getFundsList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    private void setRadio() {
        this.allRadio.setToggleGroup(this.group);
        this.filterRadio.setToggleGroup(this.group);
        this.filterRadio.selectedProperty().addListener((ob, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.tableCtpPosition.setItems(this.mxFilterList.getList());
            } else {
                this.tableCtpPosition.setItems(this.mxList.getList());
            }
        });
        this.filterRadio.setSelected(true);
    }

    private void check() {
        if (!this.rightModel.registerCheck(new String[]{"cms.tmx.future.part.position_close"})) {
            this.close.setVisible(false);
        }
        if (!this.rightModel.registerCheck(new String[]{"cms.tmx.future.part.position_clear"})) {
            this.clear.setVisible(false);
        }
    }

    private boolean checkAccnt(CtpPosition deal) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return true;
        }
        String[] split = accntNow.split("__");
        return ALL.equals(accntNow) || deal.getInvestorId().equals(split[0]);
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Focus
    public void onFocus() {
        this.tableCtpPosition.refresh();
    }

    private void createTable() {
        int clickCount = 2;
        this.tableCtpPosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CtpPosition pos;
            if (event.getClickCount() == clickCount && (pos = (CtpPosition)this.tableCtpPosition.getSelectionModel().getSelectedItem()) != null) {
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)pos.getSecId());
                eCall.put((Object)"count", (Object)pos.getPosition());
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"side_sell", (Object)pos.getPosiDirection().getRaw());
                eCall.put((Object)"hedgeFlag", (Object)pos.getHedgeFlag().getRaw());
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("ctpTradePanelSetCode", eCall);
            }
        });
        this.colSecId.setCellValueFactory(data -> ((CtpPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CtpPosition)data.getValue()).secNameProperty());
        this.colMarket.setCellValueFactory(data -> ((CtpPosition)data.getValue()).marketProperty());
        this.colPosiDire.setCellValueFactory(data -> ((CtpPosition)data.getValue()).posiDirectionProperty());
        this.colPosiDire.setCellFactory(cell -> new SideCell());
        this.colHedgeFlag.setCellValueFactory(data -> ((CtpPosition)data.getValue()).hedgeFlagProperty());
        this.colTdPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).tdPositionProperty());
        this.colTdPosi.setCellFactory(cell -> new NumberTableCell());
        this.colYdPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).ydPositionProperty());
        this.colYdPosi.setCellFactory(cell -> new NumberTableCell());
        this.colPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).positionProperty());
        this.colPosi.setCellFactory(cell -> new NumberTableCell());
        this.colCanClose.setCellValueFactory(data -> ((CtpPosition)data.getValue()).canCloseProperty());
        this.colCanClose.setCellFactory(cell -> new NumberTableCell());
        this.colSecValue.setCellValueFactory(data -> ((CtpPosition)data.getValue()).secValueProperty());
        this.colSecValue.setCellFactory(cell -> new DoubleTableCell());
        this.colPosiProfit.setCellValueFactory(data -> ((CtpPosition)data.getValue()).positionProfitProperty());
        this.colPosiProfit.setCellFactory(cell -> new DoubleTableCell());
        this.colUseMargin.setCellValueFactory(data -> ((CtpPosition)data.getValue()).useMarginProperty());
        this.colUseMargin.setCellFactory(cell -> new DoubleTableCell());
        this.colAcc.setCellValueFactory(data -> ((CtpPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CtpPosition)data.getValue()).inverstorSecIdProperty());
        this.tableCtpPosition.setPlaceholder((Node)new Label());
        this.tableCtpPosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableCtpPosition);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpPosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpPosition, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void closePosi() {
        CtpPosition position = (CtpPosition)this.tableCtpPosition.getSelectionModel().getSelectedItem();
        if (position == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5e73\u4ed3");
            return;
        }
        if (position.getCanClose() == 0L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ef\u5e73\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u5e73\u4ed3");
            return;
        }
        LinkedList<CtpPosition> posList = new LinkedList<CtpPosition>();
        posList.add(position);
        if (this.createDialog(posList)) {
            return;
        }
        MEvent event = this.model.close(position);
        int countSuc = event.getInt("suc.count");
        if (countSuc == 1) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5e73\u4ed3\u63d0\u4ea4\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
        }
    }

    @FXML
    public void clearPosi() {
        if (this.tableCtpPosition.getItems().size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u8868\u683c\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
            return;
        }
        FilteredList posList = this.tableCtpPosition.getItems().filtered(pos -> pos.getCanClose() > 0L);
        if (posList.size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u65e0\u53ef\u6e05\u4ed3\u6570\u636e");
            return;
        }
        if (this.createDialog((List<CtpPosition>)posList)) {
            return;
        }
        this.exe.execute(() -> this.lambda$31((ObservableList)posList));
    }

    private boolean createDialog(List<CtpPosition> posList) {
        FutureReplaceConfirmDialog obj = (FutureReplaceConfirmDialog)((Object)this.of.create(FutureReplaceConfirmDialog.class));
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        this.model.queryMarketItem(posList);
        for (CtpPosition po : posList) {
            FutureCancelEntrust en = this.cf.createSingle(po.getExtAccId(), po.getExtSecAccId());
            en.setSec(po.getSecId());
            en.setSecName(po.getSecName());
            en.setAcc(po.getInvestorId());
            en.setSecAcc(po.getInverstorSecId());
            en.setSecType(po.getSecType());
            en.setMarket(po.getMarket().getRaw());
            en.setOrderType(50);
            en.setQuantity(po.getCanClose());
            if ("1".equals(po.getPosiDirection().getRaw())) {
                en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(50)));
            } else if ("2".equals(po.getPosiDirection().getRaw())) {
                en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(49)));
            }
            try {
                en.setPrice(this.model.getNewPrice(po));
                po.setNewPrice(en.getPrice());
                en.setAmt(this.model.getAmt(po, en.getPrice(), en.getQuantity()));
            }
            catch (MException e) {
                en.setTip("\u884c\u60c5\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u4e0b\u5355");
                logger.error("\u5e73\u4ed3\u83b7\u53d6\u884c\u60c5\u5931\u8d25", (Throwable)e);
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u5e73\u4ed3");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private void clear(List<CtpPosition> list) {
        MEvent event = this.model.clear(list);
        Platform.runLater(() -> this.alert.alert(Alert.AlertType.INFORMATION, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14"));
    }

    private /* synthetic */ void lambda$31(ObservableList observableList) {
        this.clear((List<CtpPosition>)observableList);
    }

    private class SideCell
    extends TableCell<CtpPosition, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 1: {
                    this.label.setText(value.getValue());
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case 2: {
                    this.label.setText("    " + value.getValue());
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

