/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.CtpOrderModel;
import cms.tmx.query.history.views.TypeCell;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CtpOrderPart
extends MxPart {
    public static String parentID = "";
    @FXML
    protected TableView<CtpOrder> tableCtpOrder;
    @FXML
    private TableColumn<CtpOrder, String> colParentId;
    @FXML
    private TableColumn<CtpOrder, String> colSource;
    @FXML
    private TableColumn<CtpOrder, String> colContId;
    @FXML
    private TableColumn<CtpOrder, String> colContName;
    @FXML
    private TableColumn<CtpOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CtpOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CtpOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<CtpOrder, MxNode> colOC;
    @FXML
    private TableColumn<CtpOrder, MxNode> colSH;
    @FXML
    private TableColumn<CtpOrder, String> colOrderId;
    @FXML
    private TableColumn<CtpOrder, String> colAccId;
    @FXML
    private TableColumn<CtpOrder, String> colSecAcc;
    @FXML
    private TableColumn<CtpOrder, String> colOrdTime;
    @FXML
    private TableColumn<CtpOrder, Number> colPrice;
    @FXML
    private TableColumn<CtpOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CtpOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CtpOrder, Number> colPercent;
    @FXML
    private TableColumn<CtpOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CtpOrder, Number> colFrzMargin;
    @FXML
    private TableColumn<CtpOrder, String> colInfo;
    @FXML
    private TableColumn<CtpOrder, String> colUser;
    @FXML
    private TableColumn<CtpOrder, String> colUserName;
    @FXML
    private TableColumn<CtpOrder, String> colType;
    @FXML
    private TextField searchText;
    @Inject
    private CtpOrderModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    private static final Logger logger = LogManager.getLogger(CtpOrderPart.class);
    private MxList<CtpOrder> mxList = new MxList();
    private Predicate<CtpOrder> pd = en -> {
        String text = this.searchText.getText().toUpperCase().trim();
        return en.getInstrument().getSecId().toUpperCase().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getUserName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableCtpOrder.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };
    protected MEventHandler handler = event -> {
        if (parentID.isEmpty()) {
            return;
        }
        this.tableCtpOrder.getSelectionModel().clearSelection();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.tableCtpOrder.getItems().forEach(item -> {
                if (item.getParentId().equals(parentID)) {
                    this.tableCtpOrder.getSelectionModel().select(item);
                }
            });
        }
    };

    @Focus
    public void onFocus() {
        this.tableCtpOrder.refresh();
    }

    @FXML
    public void initialize() {
        this.listener();
        this.refresh();
        this.createTableView();
        this.onFocus();
        this.tableCtpOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.es.subscribe("future.cross.order.select.changed", this.handler);
        this.handler.onEvent(null);
        this.tableCtpOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpOrder order = (CtpOrder)this.tableCtpOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.order")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)order.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.es.unSubscribe("future.cross.order.select.changed", this.handler);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpOrder);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpOrder, (String)"\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTableView() {
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getParentId()));
        this.colSource.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getSource()));
        this.colContId.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().secIdProperty());
        this.colContName.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().marketProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOcFlag()));
        this.colSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getShFlag()));
        this.colFrzMargin.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getFrozenMargin()));
        this.colFrzMargin.setCellFactory(p -> new DoubleTableCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(p -> new NumberTableCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(p -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new PriceCell());
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOrdStatus()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInverstorSecId()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrderId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CtpOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CtpOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getUserId()));
        this.colUserName.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getUserName()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getExecType()));
        this.colType.setCellFactory(cell -> new TypeCell());
        this.tableCtpOrder.setPlaceholder((Node)new Label());
        this.tableCtpOrder.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableCtpOrder);
    }

    private class PriceCell
    extends DoubleTableCell<CtpOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CtpOrder order = (CtpOrder)CtpOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpOrderPart.this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

