/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.ObCtpOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CtpOrderModel;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CtpOrderPagePart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    public static String parentID = "";
    @FXML
    protected TableView<ObCtpOrder> tableCtpOrder;
    @FXML
    private TableColumn<ObCtpOrder, String> secId;
    @FXML
    private TableColumn<ObCtpOrder, String> secName;
    @FXML
    private TableColumn<ObCtpOrder, MxNode> exMarket;
    @FXML
    private TableColumn<ObCtpOrder, String> side;
    @FXML
    private TableColumn<ObCtpOrder, String> exOrdStatus;
    @FXML
    private TableColumn<ObCtpOrder, MxNode> exOcFlag;
    @FXML
    private TableColumn<ObCtpOrder, MxNode> exShFlag;
    @FXML
    private TableColumn<ObCtpOrder, String> orderId;
    @FXML
    private TableColumn<ObCtpOrder, String> investorId;
    @FXML
    private TableColumn<ObCtpOrder, String> inverstorSecId;
    @FXML
    private TableColumn<ObCtpOrder, String> ordDateTime;
    @FXML
    private TableColumn<ObCtpOrder, Number> price;
    @FXML
    private TableColumn<ObCtpOrder, Number> orderQty;
    @FXML
    private TableColumn<ObCtpOrder, Number> cumQty;
    @FXML
    private TableColumn<ObCtpOrder, Number> donePercent;
    @FXML
    private TableColumn<ObCtpOrder, Number> avgPx;
    @FXML
    private TableColumn<ObCtpOrder, Number> frozenMargin;
    @FXML
    private TableColumn<ObCtpOrder, String> errInfo;
    @FXML
    private TableColumn<ObCtpOrder, String> userId;
    @FXML
    private TableColumn<ObCtpOrder, String> userName;
    @FXML
    private TextField searchText;
    @FXML
    private Label lbQuerying;
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    @Inject
    private CtpOrderModel model;
    @Inject
    private IRefDataMng refMng;
    @FXML
    private Label lbCountSeparator;
    @FXML
    private ComboBox<String> cmbAccnt;
    private static final String ALL = "\u5168\u90e8";
    private static final Logger logger = LogManager.getLogger(CtpOrderPagePart.class);
    @Inject
    private MxAlert alert;
    protected MxPageList<CtpOrder, ObCtpOrder> mxList = new MxPageList(PAGE_SIZE.intValue(), ObCtpOrder.class);
    private Predicate<CtpOrder> pd = en -> {
        String text = this.searchText.getText().toUpperCase().trim();
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow != null) {
            String[] split = accntNow.split("__");
            if (!ALL.equals(accntNow) && !en.getExtAccntId().contains(split[0])) {
                return false;
            }
        }
        return en.getInstrument().getSecId().toUpperCase().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getUserName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        this.refreshList();
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        this.sort();
        this.mxList.updatePageList();
        this.tableCtpOrder.refresh();
        this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
        this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
    };
    protected MEventHandler handler = event -> {
        if (parentID.isEmpty()) {
            return;
        }
        this.tableCtpOrder.getSelectionModel().clearSelection();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            System.out.println("ctpOrderPagePart:   |  " + Thread.currentThread().getName());
            this.tableCtpOrder.getItems().forEach(item -> {
                if (item.getParentId().equals(parentID)) {
                    this.tableCtpOrder.getSelectionModel().select(item);
                }
            });
        }
    };
    private ScrollBar bar;
    private double lastPosition = 0.0;
    private boolean dragFlag = false;
    private long lastDragTime = 0L;
    public Callback<TableView<ObCtpOrder>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<ObCtpOrder>(){

        @Override
        public void afterSort() {
            CtpOrderPagePart.this.lstnModel.invalidated(null);
        }
    };
    long lastLoadTime = 0L;

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Focus
    public void onFocus() {
        this.tableCtpOrder.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        this.sort();
        Platform.runLater(() -> this.mxList.updatePageList());
        if (this.lbCurrentCount != null && this.lbTotalCount != null) {
            String currentCount = String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE));
            Platform.runLater(() -> {
                this.lbCurrentCount.setText(currentCount);
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            });
        }
    }

    protected void sort() {
        try {
            ObservableList sortOrder = this.tableCtpOrder.getSortOrder();
            if (sortOrder == null || sortOrder.isEmpty()) {
                this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            }
            for (TableColumn column : sortOrder) {
                this.mxList.getList().sort((o1, o2) -> {
                    try {
                        Method method = CtpOrder.class.getMethod("get" + CtpOrderPagePart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return QueryUtils.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return QueryUtils.compareMxNode(column, s1, s2);
                        }
                        return QueryUtils.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u59d4\u6258\u6392\u5e8f\u5931\u8d25", (Throwable)e);
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    private void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    private void loadPrevPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() == 0) {
            return;
        }
        if (this.mxList.getBeginIndex() - PAGE_SIZE < 0) {
            this.mxList.setBeginIndex(0);
        } else {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() - PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    @FXML
    public void initialize() {
        this.tableCtpOrder.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.listener();
        this.refresh();
        this.createTableView();
        this.onFocus();
        this.tableCtpOrder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.es.subscribe("future.cross.order.select.changed", this.handler);
        this.handler.onEvent(null);
        this.tableCtpOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCtpOrder order = (ObCtpOrder)this.tableCtpOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.order")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)order.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
        this.tableCtpOrder.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableCtpOrder.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 100L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() <= this.bar.getMax() * 0.1) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() >= this.bar.getMax() * 0.9) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableCtpOrder.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
        this.tableCtpOrder.setOnScroll(ob -> {
            long now = System.currentTimeMillis();
            if (now - this.lastLoadTime < 1000L) {
                return;
            }
            this.lastLoadTime = now;
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableCtpOrder.lookup(".scroll-bar:vertical");
            }
            if (ob.getDeltaY() > 0.0) {
                if (this.lbCurrentCount.getText().startsWith("1-")) {
                    return;
                }
                this.loadPrevPage();
                this.bar.setValue(1.0);
                return;
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.model.getFundList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.queryingProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (newV.booleanValue()) {
                this.lbQuerying.setVisible(true);
            } else {
                this.lbQuerying.setVisible(false);
            }
        }));
    }

    @PreDestroy
    protected void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.es.unSubscribe("future.cross.order.select.changed", this.handler);
    }

    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpOrder);
    }

    @FXML
    public void exportExcel() {
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableCtpOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    private void createTableView() {
        this.secId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).secNameProperty());
        this.exMarket.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).getInstrument().marketProperty());
        this.side.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).sideProperty());
        this.side.setCellFactory(cell -> new SideCell());
        this.exOcFlag.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).ocFlagProperty());
        this.exShFlag.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).shFlagProperty());
        this.frozenMargin.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).frozenMarginProperty());
        this.frozenMargin.setCellFactory(p -> new DoubleTableCell());
        this.price.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).priceProperty());
        this.price.setCellFactory(p -> new PriceCell());
        this.orderQty.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).orderQtyProperty());
        this.orderQty.setCellFactory(p -> new NumberTableCell());
        this.cumQty.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).cumQtyProperty());
        this.cumQty.setCellFactory(p -> new NumberTableCell());
        this.donePercent.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).donePercentProperty());
        this.donePercent.setCellFactory(column -> new DoubleTableCell());
        this.avgPx.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).avgPxProperty());
        this.avgPx.setCellFactory(p -> new PriceCell());
        this.ordDateTime.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).ordTimeProperty());
        this.exOrdStatus.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).ordStatusProperty());
        this.investorId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).investorIdProperty());
        this.inverstorSecId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).inverstorSecIdProperty());
        this.orderId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).orderIdProperty());
        this.errInfo.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).errInfoProperty());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObCtpOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObCtpOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.userId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).userIdProperty());
        this.userName.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).userNameProperty());
        this.tableCtpOrder.setPlaceholder((Node)new Label());
        this.tableCtpOrder.setItems(this.mxList.getPageList());
        TableUtils.orgnizeClmWidth(this.tableCtpOrder);
    }

    private class PriceCell
    extends DoubleTableCell<ObCtpOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCtpOrder order = (ObCtpOrder)ObCtpOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpOrderPagePart.this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObCtpOrder, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCtpOrder order = (ObCtpOrder)ObCtpOrder.class.cast(this.getTableRow().getItem());
            if (order == null) {
                return;
            }
            int side = StringUtils.parseInt((String)order.getSideRaw());
            this.label.setText(value);
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

