/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.views.CtpUnfinishedOrderPart;
import cms.tmx.query.history.views.TypeCell;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;

public class CtpMmUnfinishedOrderPart
extends CtpUnfinishedOrderPart {
    @FXML
    private ComboBox<String> cmbType;
    @FXML
    private ComboBox<String> cmbCode;
    @FXML
    private TableColumn<CtpOrder, String> colParentId;
    @FXML
    private TableColumn<CtpOrder, String> colSource;
    @FXML
    private TableColumn<CtpOrder, String> colType;
    @FXML
    private TableColumn<CtpOrder, Number> colExecModeId;
    private MEventHandler handler = event -> this.calcelSpecifiedPrice(event);
    private Predicate<CtpOrder> pd = en -> {
        String type = en.getExecType();
        String typeSelected = (String)this.cmbType.getSelectionModel().getSelectedItem();
        if (this.cmbCode.getSelectionModel() == null) {
            return false;
        }
        if (!(String.valueOf(en.getInstrument().getSecId().toUpperCase()) + "\u5168\u90e8").contains((CharSequence)this.cmbCode.getSelectionModel().getSelectedItem())) {
            return false;
        }
        switch (typeSelected) {
            case "\u975e\u505a\u5e02\u5355": {
                if (!"\u505a\u5e02\u5355".equals(type)) break;
                return false;
            }
            case "\u505a\u5e02\u5355": 
            case "\u5bf9\u51b2\u5355": 
            case "\u666e\u901a\u5355": {
                if (!type.equals(typeSelected)) {
                    return false;
                }
            }
            case "\u7b97\u6cd5": {
                if (type.contains(typeSelected)) break;
                return false;
            }
        }
        String text = this.searchText.getText().toUpperCase().trim();
        return en.getInstrument().getSecId().toUpperCase().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getInstrument().getSymbol().toUpperCase().contains(text) || en.getUserId().contains(text) || en.getSource().contains(text) || en.getUserName().contains(text);
    };
    private InvalidationListener listenerRefMng = ob -> Platform.runLater(() -> {
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"})));
        this.cmbCode.setItems(code);
        this.cmbCode.setValue((Object)"\u5168\u90e8");
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcelSpecifiedPrice(MEvent event) {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        ArrayList<CtpOrder> cancelList = new ArrayList<CtpOrder>();
        double price = event.getDouble("price");
        for (CtpOrder order : newList) {
            if (order.getPrice() != price || order.getExecType().equals("\u5bf9\u51b2\u5355")) continue;
            cancelList.add(order);
        }
        this.model.cancel(cancelList);
    }

    @Override
    @FXML
    public void initialize() {
        this.es.subscribe("monitor.cancel.order", this.handler);
        super.initialize();
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getParentId()));
        this.colSource.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getSource()));
        this.colExecModeId.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getExecModeId()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getExecType()));
        this.colType.setCellFactory(cell -> new TypeCell());
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.cmbCode.getSelectionModel().selectedItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.refMng.changedProperty().addListener(this.listenerRefMng);
        this.tableCtpUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpOrder order = (CtpOrder)this.tableCtpUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"input_ctp_market_making", (Object)order.getSecId());
            this.es.postEvent("input_ctp_market_making", e);
            MEvent eCall = new MEvent();
            eCall.put((Object)"sec_code", (Object)order.getSecId());
            eCall.put((Object)"side_sell", (Object)order.getSide().getRaw());
            this.es.postEvent("input_futures_trade_market", eCall);
        });
    }

    @Override
    protected void initValues() {
        super.initValues();
        ObservableList type = FxUtils.newList();
        type.add((Object)"\u5168\u90e8");
        type.add((Object)"\u666e\u901a\u5355");
        type.add((Object)"\u5bf9\u51b2\u5355");
        type.add((Object)"\u505a\u5e02\u5355");
        type.add((Object)"\u975e\u505a\u5e02\u5355");
        type.add((Object)"\u7b97\u6cd5");
        this.cmbType.setItems(type);
        this.cmbType.setValue((Object)"\u5168\u90e8");
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"})));
        this.cmbCode.setItems(code);
        this.cmbCode.setValue((Object)"\u5168\u90e8");
    }

    @Override
    @PreDestroy
    protected void close() {
        super.close();
        this.es.unSubscribe("future.cross.order.select.changed", this.handler);
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
        this.es.unSubscribe("monitor.cancel.order", this.handler);
    }

    @FXML
    public void withdraw() {
        LinkedList orderList = new LinkedList();
        this.tableCtpUnOrder.getItems().forEach(item -> {
            if (item.getExecType().equals("\u505a\u5e02\u5355") || item.getExecType().equals("\u5957\u5229\u5355")) {
                orderList.add(item);
            }
        });
        if (orderList.size() > 0) {
            MEvent eCall = new MEvent();
            eCall.setObj(orderList);
            this.es.postEvent("input_futures_stopped_cancel_market", eCall);
        }
    }

    @Override
    protected Predicate<CtpOrder> getPredicate() {
        return this.pd;
    }
}

