/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.FutureDealSum;
import cms.tmx.entity.trade.ObCtpDeal;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.views.CtpDealPagePart;
import cms.tmx.query.current.views.SumDeep;
import cms.tmx.query.history.views.TypeCell;
import cms.tmx.query.utils.SideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.inject.Inject;

public class CtpMmDealPagePart
extends CtpDealPagePart {
    @FXML
    private HBox hboxRadios;
    @FXML
    private TableColumn<ObCtpDeal, String> parentId;
    @FXML
    private TableColumn<ObCtpDeal, String> source;
    @FXML
    private TableColumn<ObCtpDeal, String> type;
    @FXML
    protected TableView<ObCtpDeal> tableCtpDeal;
    @FXML
    protected TableView<CtpDeal> tableCtpDealSum;
    @FXML
    protected TableView<SumDeep> tableSumDeep;
    @FXML
    private TableColumn<SumDeep, String> codeType;
    @FXML
    private TableColumn<SumDeep, Number> countBuy;
    @FXML
    private TableColumn<SumDeep, Number> countSell;
    @FXML
    private TableColumn<SumDeep, Number> countSub;
    @FXML
    private TableColumn<SumDeep, Number> countActive;
    @FXML
    private TableColumn<SumDeep, Number> countPassive;
    @FXML
    private TableColumn<SumDeep, Number> countDiff;
    @FXML
    private RadioButton sumDeepRadio;
    @FXML
    private RadioButton radioContract;
    @FXML
    private RadioButton radioStrategy;
    private ObservableList<SumDeep> listSumDeep = FxUtils.newList();
    @FXML
    private TableView<FutureDealSum> tableSum;
    @FXML
    private TableColumn<FutureDealSum, String> code;
    @FXML
    private TableColumn<FutureDealSum, String> name;
    @FXML
    private TableColumn<FutureDealSum, MxNode> side1;
    @FXML
    private TableColumn<FutureDealSum, MxNode> ocFlag;
    @FXML
    private TableColumn<FutureDealSum, MxNode> shFlag;
    @FXML
    private TableColumn<FutureDealSum, String> type1;
    @FXML
    private TableColumn<FutureDealSum, Number> count;
    @FXML
    private TableColumn<FutureDealSum, Number> price;
    @FXML
    private TableColumn<FutureDealSum, String> account;
    @FXML
    private TableColumn<FutureDealSum, String> source1;
    private ObservableList<FutureDealSum> list = FxUtils.newList();
    private List<FutureDealSum> listAll = new ArrayList<FutureDealSum>();
    private Predicate<FutureDealSum> pdSum = new Predicate<FutureDealSum>(){

        @Override
        public boolean test(FutureDealSum t) {
            return t.getCode().trim().toUpperCase().contains(CtpMmDealPagePart.this.searchText.getText().trim().toUpperCase());
        }
    };
    @Inject
    private IUiRightService rightsModel;
    private Map<String, SumDeep> map = new HashMap<String, SumDeep>();

    @Override
    public boolean premise(CtpDeal order) {
        return false;
    }

    @Override
    protected String getKey(CtpDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getSecId() + deal.getSide().getRaw() + deal.getShFlag().getRaw();
        return key;
    }

    @Override
    protected void setRadio() {
        this.sumDeepRadio.setToggleGroup(this.group);
        this.radioContract.setToggleGroup(this.group);
        this.radioStrategy.setToggleGroup(this.group);
        super.setRadio();
        this.tableSumDeep.visibleProperty().bind((ObservableValue)this.sumDeepRadio.selectedProperty());
        this.tableSum.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!this.radioContract.isSelected() && !this.radioStrategy.isSelected()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.radioContract.selectedProperty(), this.radioStrategy.selectedProperty()}));
    }

    @Override
    protected void refreshList() {
        super.refreshList();
        if (this.sumDeepRadio.isSelected()) {
            this.createSumDeepList();
        }
        if (this.radioStrategy.isSelected() || this.radioContract.isSelected()) {
            this.resetTableSum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTableSum() {
        ArrayList dealList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            dealList.addAll(this.model.getList());
        }
        HashMap<String, FutureDealSum> map = new HashMap<String, FutureDealSum>();
        HashSet<String> set = new HashSet<String>();
        for (CtpDeal deal : dealList) {
            FutureDealSum sum;
            if (deal == null || deal.getSource() == null || deal.getSource().isEmpty()) continue;
            String key = this.radioContract.isSelected() ? String.valueOf(deal.getSecId()) + deal.getType() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getInvestorId() : String.valueOf(deal.getSecId()) + deal.getType() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getInvestorId() + deal.getSource();
            if (set.contains(key)) {
                sum = (FutureDealSum)map.get(key);
                sum.setCount(sum.getCount() + deal.getLastQty());
                sum.setAmount(sum.getAmount() + deal.getLastPx() * deal.getLastQty());
                continue;
            }
            sum = new FutureDealSum();
            sum.update(deal);
            map.put(key, sum);
            set.add(key);
        }
        for (FutureDealSum sum : map.values()) {
            sum.setPrice(sum.getAmount() / sum.getCount());
        }
        this.listAll.clear();
        this.listAll.addAll(map.values());
        this.filterSumTable();
    }

    @Override
    protected void filterSumTable() {
        if (this.radioContract.isSelected() || this.radioStrategy.isSelected()) {
            this.list.setAll((Collection)this.listAll.stream().filter(this.pdSum).collect(Collectors.toList()));
            this.tableSum.refresh();
            this.list.sort((o1, o2) -> o1.getCode().compareTo(o2.getCode()));
            this.tableSum.sort();
        }
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.createTableSum();
        this.checkRights();
        this.group.selectedToggleProperty().addListener((ob, old, now) -> this.lstnModel.invalidated(null));
        this.colOCSum.setVisible(false);
        this.codeType.setCellValueFactory(value -> ((SumDeep)value.getValue()).codeProperty());
        this.countBuy.setCellValueFactory(value -> ((SumDeep)value.getValue()).buyProperty());
        this.countSell.setCellValueFactory(value -> ((SumDeep)value.getValue()).sellProperty());
        this.countSub.setCellValueFactory(value -> ((SumDeep)value.getValue()).subProperty());
        this.countSub.setCellFactory(cell -> new DiffTypeCell());
        this.countActive.setCellValueFactory(value -> ((SumDeep)value.getValue()).activeProperty());
        this.countPassive.setCellValueFactory(value -> ((SumDeep)value.getValue()).passiveProperty());
        this.countDiff.setCellValueFactory(value -> ((SumDeep)value.getValue()).diffProperty());
        this.countDiff.setCellFactory(cell -> new DiffTypeCell());
        this.tableSumDeep.setPlaceholder((Node)new Label());
        this.tableSumDeep.setItems(this.listSumDeep);
        this.parentId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).parentIdProperty());
        this.source.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).sourceProperty());
        this.type.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).typeProperty());
        this.type.setCellFactory(cell -> new TypeCell());
        this.tableCtpDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCtpDeal deal = (ObCtpDeal)this.tableCtpDeal.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"input_ctp_market_making", (Object)deal.getSecId());
            this.es.postEvent("input_ctp_market_making", e);
            MEvent eCall = new MEvent();
            eCall.put((Object)"sec_code", (Object)deal.getSecId());
            eCall.put((Object)"side_sell", (Object)deal.getSideRaw());
            this.es.postEvent("input_futures_trade_market", eCall);
        });
        this.tableCtpDealSum.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpDeal deal = (CtpDeal)this.tableCtpDealSum.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"input_ctp_market_making", (Object)deal.getSecId());
            this.es.postEvent("input_ctp_market_making", e);
            MEvent eCall = new MEvent();
            eCall.put((Object)"sec_code", (Object)deal.getSecId());
            eCall.put((Object)"side_sell", (Object)deal.getSide().getRaw());
            this.es.postEvent("input_futures_trade_market", eCall);
        });
    }

    @FXML
    private void copySumDeep() {
        TableUtils.copyContentWithHead(this.tableSumDeep);
    }

    @FXML
    private void exportSumDeep() {
        try {
            ExcelUtils.writeExcel(this.tableSumDeep, (String)"\u7c7b\u522b\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void copySum2() {
        TableUtils.copyContentWithHead(this.tableSum);
    }

    @FXML
    private void exportSum2() {
        String name = "\u7b56\u7565\u6c47\u603b";
        if (this.radioContract.isSelected()) {
            name = "\u5408\u7ea6\u6c47\u603b";
        }
        try {
            ExcelUtils.writeExcel(this.tableSum, (String)name);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void checkRights() {
        this.rightsModel.registerCheck((Control)this.sumRadio, new String[]{"cms.tmx.futures.part.strategy.deal_sum"});
        this.rightsModel.registerCheck((Control)this.sumDeepRadio, new String[]{"cms.tmx.futures.part.strategy.deal_typesum"});
        this.rightsModel.registerCheck((Control)this.radioContract, new String[]{"cms.tmx.futures.part.strategy.deal_contractsum"});
        this.rightsModel.registerCheck((Control)this.radioStrategy, new String[]{"cms.tmx.futures.part.strategy.deal_strategysum"});
        this.hboxRadios.getChildren().clear();
        if (this.sumRadio.isVisible()) {
            this.hboxRadios.getChildren().add((Object)this.sumRadio);
        }
        if (this.sumDeepRadio.isVisible()) {
            this.hboxRadios.getChildren().add((Object)this.sumDeepRadio);
        }
        if (this.radioContract.isVisible()) {
            this.hboxRadios.getChildren().add((Object)this.radioContract);
        }
        if (this.radioStrategy.isVisible()) {
            this.hboxRadios.getChildren().add((Object)this.radioStrategy);
        }
    }

    private void createTableSum() {
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getCode()));
        this.name.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getName()));
        this.side1.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("side", ((FutureDealSum)data.getValue()).getSide());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.side1.setCellFactory(cell -> new SideCell());
        this.ocFlag.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("position_effect", ((FutureDealSum)data.getValue()).getOcFlag());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.shFlag.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("sh_flag", ((FutureDealSum)data.getValue()).getShFlag());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.type1.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getType()));
        this.count.setCellValueFactory(data -> new SimpleLongProperty((long)((FutureDealSum)data.getValue()).getCount()));
        this.price.setCellValueFactory(data -> new SimpleDoubleProperty(((FutureDealSum)data.getValue()).getPrice()));
        this.price.setCellFactory(cell -> new PriceCell());
        this.account.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getAccount()));
        this.source1.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getSource()));
        this.tableSum.setPlaceholder((Node)new Label());
        this.tableSum.setItems(this.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSumDeepList() {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        HashSet<String> set = new HashSet<String>();
        for (CtpDeal deal : newList) {
            set.add(deal.getSecId());
        }
        this.map.clear();
        for (String code : set) {
            this.map.put(code, new SumDeep(code));
        }
        int tsBuy = 0;
        int tsSell = 0;
        int tfBuy = 0;
        int tfSell = 0;
        int tBuy = 0;
        int tSell = 0;
        int tsActive = 0;
        int tsPassive = 0;
        int tfActive = 0;
        int tfPassive = 0;
        int tActive = 0;
        int tPassive = 0;
        for (CtpDeal deal : newList) {
            SumDeep sumDeep = this.map.get(deal.getSecId());
            if (deal.getSide().getRaw().equals("49")) {
                sumDeep.setBuy((int)((double)sumDeep.getBuy() + deal.getLastQty()));
            } else {
                sumDeep.setSell((int)((double)sumDeep.getSell() + deal.getLastQty()));
            }
            if (deal.getDealType().is("1")) {
                sumDeep.setActive((int)((double)sumDeep.getActive() + deal.getLastQty()));
            } else {
                sumDeep.setPassive((int)((double)sumDeep.getPassive() + deal.getLastQty()));
            }
            sumDeep.setSub(sumDeep.getBuy() - sumDeep.getSell());
            sumDeep.setDiff(-sumDeep.getActive() + sumDeep.getPassive());
            if (deal.getSecId().startsWith("TS")) {
                if (deal.getSide().getRaw().equals("49")) {
                    tsBuy = (int)((double)tsBuy + deal.getLastQty());
                } else {
                    tsSell = (int)((double)tsSell + deal.getLastQty());
                }
                if (deal.getDealType().is("1")) {
                    tsActive = (int)((double)tsActive + deal.getLastQty());
                    continue;
                }
                tsPassive = (int)((double)tsPassive + deal.getLastQty());
                continue;
            }
            if (deal.getSecId().startsWith("TF")) {
                if (deal.getSide().getRaw().equals("49")) {
                    tfBuy = (int)((double)tfBuy + deal.getLastQty());
                } else {
                    tfSell = (int)((double)tfSell + deal.getLastQty());
                }
                if (deal.getDealType().is("1")) {
                    tfActive = (int)((double)tfActive + deal.getLastQty());
                    continue;
                }
                tfPassive = (int)((double)tfPassive + deal.getLastQty());
                continue;
            }
            if (deal.getSide().getRaw().equals("49")) {
                tBuy = (int)((double)tBuy + deal.getLastQty());
            } else {
                tSell = (int)((double)tSell + deal.getLastQty());
            }
            if (deal.getDealType().is("1")) {
                tActive = (int)((double)tActive + deal.getLastQty());
                continue;
            }
            tPassive = (int)((double)tPassive + deal.getLastQty());
        }
        ObservableList<SumDeep> observableList2 = this.listSumDeep;
        synchronized (observableList2) {
            this.listSumDeep.clear();
            this.listSumDeep.add((Object)new SumDeep("\u6c47\u603b", tBuy + tsBuy + tfBuy, tSell + tsSell + tfSell, tBuy + tsBuy + tfBuy - (tSell + tsSell + tfSell), tActive + tsActive + tfActive, tPassive + tsPassive + tfPassive, -(tActive + tsActive + tfActive) + (tPassive + tsPassive + tfPassive)));
            this.listSumDeep.add((Object)new SumDeep("T", tBuy, tSell, tBuy - tSell, tActive, tPassive, -tActive + tPassive));
            this.listSumDeep.add((Object)new SumDeep("TF", tfBuy, tfSell, tfBuy - tfSell, tfActive, tfPassive, -tfActive + tfPassive));
            this.listSumDeep.add((Object)new SumDeep("TS", tsBuy, tsSell, tsBuy - tsSell, tsActive, tsPassive, -tsActive + tsPassive));
            ArrayList<SumDeep> temp = new ArrayList<SumDeep>();
            temp.addAll(this.map.values());
            temp.sort((o1, o2) -> o1.getCode().compareTo(o2.getCode()));
            for (SumDeep sumDeep : temp) {
                this.listSumDeep.add((Object)sumDeep);
            }
        }
    }

    class DiffTypeCell
    extends TableCell<SumDeep, Number> {
        private Label label = new Label();

        private DiffTypeCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            this.label.setText(value.toString());
            if (value.intValue() > 0) {
                CssUtils.makeRise((Control)this.label);
            } else if (value.intValue() < 0) {
                CssUtils.makeFall((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }

    class PriceCell
    extends TableCell<FutureDealSum, Number> {
        int scale = 3;

        PriceCell() {
        }

        protected void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                FutureDealSum sum = (FutureDealSum)this.getTableRow().getItem();
                RefItem refItem = CtpMmDealPagePart.this.refMng.getItem(sum.getMarket(), sum.getCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

